/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.print;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;

public class GanttPrintable
implements Printable {
    public static final double REDUCE_FACTOR_DEFAULT = 1.5;
    private double reduceFactor;
    private BufferedImage image;
    private int x;
    private int y;

    public GanttPrintable(BufferedImage image, double reduceFactor) {
        this.image = image;
        this.y = 0;
        this.x = 0;
        this.reduceFactor = reduceFactor < 1.0 ? 1.5 : reduceFactor;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        System.out.println(this.reduceFactor);
        System.err.println("[GanttPrintable] print(): image: w=" + this.image.getWidth() + " h=" + this.image.getHeight());
        System.err.println("[GanttPrintable] print(): page=" + pageIndex);
        int pagesPerRow = (int)((double)this.image.getWidth() / this.reduceFactor / pageFormat.getImageableWidth() + 1.0);
        int numRows = (int)((double)this.image.getHeight() / this.reduceFactor / pageFormat.getImageableHeight() + 1.0);
        System.err.println("[GanttPrintable] print(): numrows=" + numRows + " pagesPerRow=" + pagesPerRow);
        int totalPages = pagesPerRow * numRows;
        if (pageIndex >= totalPages) {
            return 1;
        }
        int currentRow = pageIndex / pagesPerRow;
        int currentColumn = pageIndex - currentRow * pagesPerRow;
        System.err.println("[GanttPrintable] print(): curentpage=" + currentColumn + " current row=" + currentRow);
        int leftx = (int)((double)currentColumn * pageFormat.getImageableWidth() * this.reduceFactor);
        int topy = (int)((double)currentRow * pageFormat.getImageableHeight() * this.reduceFactor);
        System.err.println("[GanttPrintable] print(): leftx=" + leftx + " topy=" + topy);
        int height = (int)(currentRow + 1 < numRows ? pageFormat.getImageableHeight() * this.reduceFactor : (double)this.image.getHeight() - pageFormat.getImageableHeight() * this.reduceFactor * (double)(numRows - 1));
        int width = (int)(currentColumn + 1 < pagesPerRow ? pageFormat.getImageableWidth() * this.reduceFactor : (double)this.image.getWidth() - pageFormat.getImageableWidth() * this.reduceFactor * (double)(pagesPerRow - 1));
        System.err.println("[GanttPrintable] print(): height=" + height + " width=" + width);
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        BufferedImage subimage = this.image.getSubimage(leftx, topy, width, height);
        int h = (int)((double)subimage.getHeight() / this.reduceFactor);
        int w = (int)((double)subimage.getWidth() / this.reduceFactor);
        g2d.drawImage(subimage, 0, 0, w, h, null);
        return 0;
    }
}

