/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.resource;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.ganttproject.calendar.GanttDaysOff;
import net.sourceforge.ganttproject.resource.HumanResource;
import net.sourceforge.ganttproject.resource.ProjectResource;
import net.sourceforge.ganttproject.resource.ResourceEvent;
import net.sourceforge.ganttproject.resource.ResourceManager;
import net.sourceforge.ganttproject.resource.ResourceView;
import net.sourceforge.ganttproject.roles.Role;
import net.sourceforge.ganttproject.undo.GPUndoManager;

public class HumanResourceManager
implements ResourceManager {
    private List myViews = new ArrayList();
    private List resources = new ArrayList();
    private int nextFreeId = 0;
    private final Role myDefaultRole;
    private Hashtable customFields = null;
    private final List myListeners = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public HumanResourceManager(Role defaultRole) {
        this.myDefaultRole = defaultRole;
        this.customFields = new Hashtable();
    }

    public HumanResource newHumanResource() {
        HumanResource result = new HumanResource(this);
        result.setRole(this.myDefaultRole);
        return result;
    }

    public ProjectResource create(String name, int i) {
        HumanResource hr = new HumanResource(name, i, this);
        hr.setRole(this.myDefaultRole);
        this.add(hr);
        return hr;
    }

    public void add(ProjectResource resource) {
        if (resource.getId() == -1) {
            resource.setId(this.nextFreeId);
        }
        if (resource.getId() >= this.nextFreeId) {
            this.nextFreeId = resource.getId() + 1;
        }
        this.resources.add(resource);
        this.fireResourceAdded(resource);
    }

    public void addCustomField(String title, Object defVal) {
        this.customFields.put(title, defVal);
        Iterator it = this.resources.iterator();
        while (it.hasNext()) {
            ((HumanResource)it.next()).addCustomField(title, defVal);
        }
    }

    public boolean checkCustomField(String title) {
        return this.customFields.containsKey(title);
    }

    public void removeCustomField(String title) {
        this.customFields.remove(title);
        Iterator it = this.resources.iterator();
        while (it.hasNext()) {
            ((HumanResource)it.next()).removeCustomField(title);
        }
    }

    public Hashtable getCustomFields() {
        return this.customFields;
    }

    public ProjectResource getById(int id) {
        ProjectResource pr = null;
        for (int i = 0; i < this.resources.size(); ++i) {
            if (((ProjectResource)this.resources.get(i)).getId() != id) continue;
            pr = (ProjectResource)this.resources.get(i);
            break;
        }
        return pr;
    }

    public List getResources() {
        return this.resources;
    }

    public ProjectResource[] getResourcesArray() {
        return this.resources.toArray(new ProjectResource[this.resources.size()]);
    }

    public void remove(ProjectResource resource) {
        this.fireResourcesRemoved(new ProjectResource[]{resource});
        this.resources.remove(resource);
    }

    public void remove(ProjectResource resource, GPUndoManager myUndoManager) {
        final ProjectResource res = resource;
        myUndoManager.undoableEdit("Delete Human OK", new Runnable(){

            public void run() {
                HumanResourceManager.this.fireResourcesRemoved(new ProjectResource[]{res});
                HumanResourceManager.this.resources.remove(res);
            }
        });
    }

    public void save(OutputStream target) {
    }

    public void clear() {
        this.fireCleanup();
        this.resources.clear();
    }

    public void addView(ResourceView view) {
        this.myViews.add(view);
    }

    private void fireResourceAdded(ProjectResource resource) {
        ResourceEvent e = new ResourceEvent((ResourceManager)this, resource);
        Iterator i = this.myViews.iterator();
        while (i.hasNext()) {
            ResourceView nextView = (ResourceView)i.next();
            nextView.resourceAdded(e);
        }
    }

    void fireResourceChanged(ProjectResource resource) {
        ResourceEvent e = new ResourceEvent((ResourceManager)this, resource);
        Iterator i = this.myViews.iterator();
        while (i.hasNext()) {
            ResourceView nextView = (ResourceView)i.next();
            nextView.resourceChanged(e);
        }
    }

    private void fireResourcesRemoved(ProjectResource[] resources) {
        ResourceEvent e = new ResourceEvent((ResourceManager)this, resources);
        for (int i = 0; i < this.myViews.size(); ++i) {
            ResourceView nextView = (ResourceView)this.myViews.get(i);
            nextView.resourcesRemoved(e);
        }
    }

    public void fireAssignmentsChanged(ProjectResource resource) {
        ResourceEvent e = new ResourceEvent((ResourceManager)this, resource);
        Iterator i = this.myViews.iterator();
        while (i.hasNext()) {
            ResourceView nextView = (ResourceView)i.next();
            nextView.resourceAssignmentsChanged(e);
        }
    }

    private void fireCleanup() {
        this.fireResourcesRemoved(this.resources.toArray(new ProjectResource[this.resources.size()]));
    }

    public void up(HumanResource hr) {
        int index = this.resources.indexOf(hr);
        if (!$assertionsDisabled && index < 0) {
            throw new AssertionError();
        }
        this.resources.remove(index);
        this.resources.add(index - 1, hr);
        this.fireResourceChanged(hr);
    }

    public void down(HumanResource hr) {
        int index = this.resources.indexOf(hr);
        if (!$assertionsDisabled && index < 0) {
            throw new AssertionError();
        }
        this.resources.remove(index);
        this.resources.add(index + 1, hr);
        this.fireResourceChanged(hr);
    }

    public Map importData(ResourceManager resourceManager) {
        HashMap original2imported = new HashMap();
        if (!(resourceManager instanceof HumanResourceManager)) {
            throw new IllegalArgumentException("I expect resource manager to be HumanResourceManager");
        }
        HumanResourceManager hrManager = (HumanResourceManager)resourceManager;
        List resources = hrManager.getResources();
        for (int i = 0; i < resources.size(); ++i) {
            HumanResource next = (HumanResource)resources.get(i);
            this.importData(next, original2imported);
        }
        return original2imported;
    }

    private void importData(HumanResource next, Map original2imported) {
        HumanResource imported = (HumanResource)this.create(next.getName(), this.nextFreeId);
        if (next.getDaysOff() != null) {
            for (int i = 0; i < next.getDaysOff().size(); ++i) {
                imported.addDaysOff((GanttDaysOff)((GanttDaysOff)next.getDaysOff().get(i)).clone());
            }
        }
        imported.setName(next.getName());
        imported.setDescription(next.getDescription());
        imported.setMail(next.getMail());
        imported.setPhone(next.getPhone());
        imported.setRole(next.getRole());
        original2imported.put(next, imported);
    }

    static {
        $assertionsDisabled = !HumanResourceManager.class.desiredAssertionStatus();
    }
}

