/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.resource;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListModel;
import net.sourceforge.ganttproject.calendar.GanttDaysOff;
import net.sourceforge.ganttproject.resource.HumanResource;
import net.sourceforge.ganttproject.resource.ProjectResource;
import net.sourceforge.ganttproject.task.ResourceAssignment;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskActivity;
import net.sourceforge.ganttproject.task.TaskLength;
import net.sourceforge.ganttproject.task.TaskManager;
import net.sourceforge.ganttproject.time.TimeUnitStack;

public class LoadDistribution {
    private final List myDaysOff = new LinkedList();
    private final List myLoads = new ArrayList();
    private final List myTasksLoads = new ArrayList();
    private final ProjectResource myResource;
    private final Date myStartDate;
    private final TimeUnitStack myTimeUnitStack;
    private final TaskManager myTaskManager;

    public LoadDistribution(ProjectResource resource, Date startDate, TimeUnitStack timeUnitStack, TaskManager taskManager) {
        this.myStartDate = startDate;
        this.myTimeUnitStack = timeUnitStack;
        this.myTaskManager = taskManager;
        this.myLoads.add(new Load(null, 0.0f, null));
        this.myDaysOff.add(new Load(null, 0.0f, null));
        this.myResource = resource;
        ResourceAssignment[] assignments = this.myResource.getAssignments();
        for (int j = 0; j < assignments.length; ++j) {
            this.processAssignment(assignments[j]);
        }
        this.processDaysOff(this.myResource);
    }

    private void processDaysOff(ProjectResource resource) {
        HumanResource hr = (HumanResource)resource;
        DefaultListModel daysOff = hr.getDaysOff();
        if (daysOff != null) {
            for (int l = 0; l < daysOff.size(); ++l) {
                this.processDayOff((GanttDaysOff)daysOff.get(l));
            }
        }
    }

    private void processDayOff(GanttDaysOff dayOff) {
        Date viewStart = this.myStartDate;
        Date dayOffEnd = dayOff.getFinish().getTime();
        if (dayOffEnd.before(viewStart)) {
            return;
        }
        TaskManager taskManager = this.myTaskManager;
        TaskLength startDelta = taskManager.createLength(this.myTimeUnitStack.getDefaultTimeUnit(), viewStart, dayOff.getStart().getTime());
        TaskLength endDelta = taskManager.createLength(this.myTimeUnitStack.getDefaultTimeUnit(), viewStart, dayOff.getFinish().getTime());
        this.addDayOff(startDelta, endDelta);
    }

    private void processAssignment(ResourceAssignment assignment) {
        Task task = assignment.getTask();
        if (task.getEnd().getTime().before(this.myStartDate)) {
            return;
        }
        TaskActivity[] activities = task.getActivities();
        for (int i = 0; i < activities.length; ++i) {
            this.processActivity(activities[i], assignment.getLoad());
        }
    }

    private void processActivity(TaskActivity activity, float load) {
        Date startDate = this.myStartDate;
        if (activity.getEnd().before(startDate)) {
            return;
        }
        if (activity.getIntensity() == 0.0f) {
            return;
        }
        TaskManager taskManager = activity.getTask().getManager();
        TaskLength startDelta = taskManager.createLength(this.myTimeUnitStack.getDefaultTimeUnit(), startDate, activity.getStart());
        TaskLength endDelta = taskManager.createLength(this.myTimeUnitStack.getDefaultTimeUnit(), startDate, activity.getEnd());
        this.addLoad(startDelta, endDelta, load, activity.getTask());
    }

    void addDayOff(TaskLength startDelta, TaskLength endDelta) {
        this.addLoad(startDelta, endDelta, 100.0f, this.myDaysOff, null);
    }

    void addLoad(TaskLength startDelta, TaskLength endDelta, float load, Task t) {
        this.addLoad(startDelta, endDelta, load, this.myLoads, t);
    }

    private void addLoad(TaskLength startDelta, TaskLength endDelta, float load, List loads, Task t) {
        Load taskLoad = new Load(startDelta, load, t);
        taskLoad.endDelta = endDelta;
        this.myTasksLoads.add(taskLoad);
        int idxStart = -1;
        float currentLoad = 0.0f;
        if (startDelta == null) {
            idxStart = 0;
        } else {
            for (int i = 1; i < loads.size(); ++i) {
                Load nextLoad = (Load)loads.get(i);
                if (startDelta.getValue() >= nextLoad.startDelta.getValue()) {
                    currentLoad = ((Load)loads.get((int)i)).load;
                }
                if (startDelta.getValue() > nextLoad.startDelta.getValue()) continue;
                idxStart = i;
                if (!(startDelta.getValue() < nextLoad.startDelta.getValue())) break;
                loads.add(i, new Load(startDelta, currentLoad, null));
                break;
            }
        }
        if (idxStart == -1) {
            idxStart = loads.size();
            loads.add(new Load(startDelta, 0.0f, t));
        }
        int idxEnd = -1;
        if (endDelta == null) {
            idxEnd = loads.size() - 1;
        } else {
            for (int i = idxStart; i < loads.size(); ++i) {
                Load nextLoad = (Load)loads.get(i);
                if (endDelta.getValue() > nextLoad.startDelta.getValue()) {
                    nextLoad.load += load;
                    continue;
                }
                idxEnd = i;
                if (!(endDelta.getValue() < nextLoad.startDelta.getValue())) break;
                Load prevLoad = (Load)loads.get(i - 1);
                loads.add(i, new Load(endDelta, prevLoad.load - load, null));
                break;
            }
        }
        if (idxEnd == -1) {
            idxEnd = loads.size();
            loads.add(new Load(endDelta, 0.0f, t));
        }
    }

    public ProjectResource getResource() {
        return this.myResource;
    }

    public List getLoads() {
        return this.myLoads;
    }

    public List getDaysOff() {
        return this.myDaysOff;
    }

    public List getTasksLoads() {
        return this.myTasksLoads;
    }

    public static class Load {
        public final TaskLength startDelta;
        public float load;
        public final Task refTask;
        public TaskLength endDelta = null;

        Load(TaskLength startDelta, float load, Task ref) {
            this.startDelta = startDelta;
            this.load = load;
            this.refTask = ref;
        }

        public String toString() {
            return "delta=" + this.startDelta + " load=" + this.load + " refTask = " + this.refTask;
        }
    }
}

