/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.shape;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.ganttproject.shape.ColorConstants;
import net.sourceforge.ganttproject.shape.JPaintCombo;
import net.sourceforge.ganttproject.shape.JPaintList;
import net.sourceforge.ganttproject.shape.PreviewPanel;
import net.sourceforge.ganttproject.shape.ShapeConstants;
import net.sourceforge.ganttproject.shape.ShapePaint;

public class Shape
extends JPanel
implements ActionListener,
ListSelectionListener {
    public static final boolean COMBO = true;
    public static final boolean LIST = false;
    protected ArrayList listeners = new ArrayList();
    protected boolean compactDisplay;
    protected JPaintCombo patternCombo;
    protected JPaintCombo foregroundCombo;
    protected JPaintCombo backgroundCombo;
    protected JPaintList patternList;
    protected JPaintList foregroundList;
    protected JPaintList backgroundList;
    protected PreviewPanel preview;

    public Shape(boolean compactDisplay) {
        this.compactDisplay = compactDisplay;
        JPanel choicePanel = new JPanel(new BorderLayout(4, 4));
        this.preview = new PreviewPanel();
        if (compactDisplay) {
            JPanel prompts = new JPanel(new GridLayout(3, 1, 4, 4));
            prompts.add(new JLabel("Pattern:", 4));
            prompts.add(new JLabel("Foreground:", 4));
            prompts.add(new JLabel("Background:", 4));
            JPanel menus = new JPanel(new GridLayout(3, 1, 4, 4));
            this.patternCombo = new JPaintCombo(ShapeConstants.PATTERN_LIST);
            menus.add(this.patternCombo);
            this.foregroundCombo = new JPaintCombo(ColorConstants.SHORT_LIST);
            menus.add(this.foregroundCombo);
            this.backgroundCombo = new JPaintCombo(ColorConstants.SHORT_LIST);
            menus.add(this.backgroundCombo);
            this.patternCombo.addActionListener(this);
            this.foregroundCombo.addActionListener(this);
            this.backgroundCombo.addActionListener(this);
            choicePanel.add("West", prompts);
            choicePanel.add("Center", menus);
            this.preview.setPattern((ShapePaint)this.patternCombo.getSelectedPaint());
        } else {
            JPanel labels = new JPanel(new GridLayout(1, 3, 4, 4));
            labels.add(new JLabel("Pattern:"));
            labels.add(new JLabel("Foreground:"));
            labels.add(new JLabel("Background:"));
            this.patternList = new JPaintList(ShapeConstants.PATTERN_LIST);
            this.foregroundList = new JPaintList(ColorConstants.SHORT_LIST);
            this.backgroundList = new JPaintList(ColorConstants.SHORT_LIST);
            JPanel lists = new JPanel(new GridLayout(1, 3, 4, 4));
            lists.add(new JScrollPane(this.patternList, 22, 31));
            lists.add(new JScrollPane(this.foregroundList, 22, 31));
            lists.add(new JScrollPane(this.backgroundList, 22, 31));
            this.patternList.addListSelectionListener(this);
            this.foregroundList.addListSelectionListener(this);
            this.backgroundList.addListSelectionListener(this);
            choicePanel.add("North", labels);
            choicePanel.add("Center", lists);
            this.preview.setPattern((ShapePaint)this.patternList.getSelectedPaint());
        }
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setLayout(new BorderLayout(8, 8));
        this.add("North", choicePanel);
        this.add("Center", this.preview);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.patternCombo) {
            this.preview.setPattern((ShapePaint)this.patternCombo.getSelectedPaint());
        }
        if (source == this.foregroundCombo) {
            this.preview.setForeground((Color)this.foregroundCombo.getSelectedPaint());
        }
        if (source == this.backgroundCombo) {
            this.preview.setBackground((Color)this.backgroundCombo.getSelectedPaint());
        }
        this.fireActionEvent();
        this.preview.repaint();
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        Object source = event.getSource();
        if (source == this.patternList) {
            this.preview.setPattern((ShapePaint)this.patternList.getSelectedPaint());
        }
        if (source == this.foregroundList) {
            this.preview.setForeground((Color)this.foregroundList.getSelectedPaint());
        }
        if (source == this.backgroundList) {
            this.preview.setBackground((Color)this.backgroundList.getSelectedPaint());
        }
        this.fireActionEvent();
        this.preview.repaint();
    }

    public ShapePaint getPattern() {
        return this.preview.getPattern();
    }

    public void setPattern(ShapePaint pattern) {
        this.preview.setPattern(pattern);
        if (this.compactDisplay) {
            this.patternCombo.setSelectedItem(new ShapePaint(pattern, Color.black, Color.white));
            this.foregroundCombo.setSelectedItem(pattern.foreground);
            this.backgroundCombo.setSelectedItem(pattern.background);
        } else {
            this.patternList.setSelectedValue(new ShapePaint(pattern, Color.black, Color.white), true);
            this.foregroundList.setSelectedValue(pattern.foreground, true);
            this.backgroundList.setSelectedValue(pattern.background, true);
        }
        this.fireActionEvent();
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    public void fireActionEvent() {
        ActionEvent event = new ActionEvent(this, 1001, "Pattern");
        ArrayList list = (ArrayList)this.listeners.clone();
        for (int i = 0; i < list.size(); ++i) {
            ActionListener listener = (ActionListener)list.get(i);
            listener.actionPerformed(event);
        }
    }
}

