/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.task.CustomColumn;
import net.sourceforge.ganttproject.task.CustomColumnsException;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.util.DateUtils;

public class CustomColumnsStorage {
    public static List availableTypes = null;
    public static GanttLanguage language = GanttLanguage.getInstance();
    private static int nextId;
    private static final String ID_PREFIX = "tpc";
    private Map mapIdCustomColum = new HashMap();

    public void reset() {
        CustomColumnsStorage.initTypes();
        this.mapIdCustomColum.clear();
        nextId = 0;
    }

    private static void initTypes() {
        availableTypes = new Vector(6);
        availableTypes.add(language.getText("text"));
        availableTypes.add(language.getText("integer"));
        availableTypes.add(language.getText("double"));
        availableTypes.add(language.getText("date"));
        availableTypes.add(language.getText("boolean"));
    }

    public static void changeLanguage(GanttLanguage lang) {
        language = lang;
        CustomColumnsStorage.initTypes();
    }

    public void addCustomColumn(CustomColumn col) throws CustomColumnsException {
        if (this.getCustomColumnsNames().contains(col.getName())) {
            throw new CustomColumnsException(0, col.getName());
        }
        if (this.mapIdCustomColum == null) {
            this.mapIdCustomColum = new HashMap();
        }
        String id = col.getId();
        while (id == null) {
            id = ID_PREFIX + nextId++;
            if (!this.existsForID(id)) continue;
            id = null;
        }
        this.mapIdCustomColum.put(id, col);
        col.setId(id);
    }

    public void removeCustomColumn(String name) {
        try {
            CustomColumn cc = this.getCustomColumn(name);
            this.mapIdCustomColum.remove(cc.getId());
        }
        catch (CustomColumnsException e) {
            e.printStackTrace();
        }
    }

    public int getCustomColumnCount() {
        return this.mapIdCustomColum.size();
    }

    public List getCustomColumnsNames() {
        ArrayList<String> c = new ArrayList<String>();
        Iterator it = this.mapIdCustomColum.keySet().iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            c.add(((CustomColumn)this.mapIdCustomColum.get(id)).getName());
        }
        return c;
    }

    public Collection getCustomColums() {
        return this.mapIdCustomColum.values();
    }

    public CustomColumn getCustomColumn(String name) throws CustomColumnsException {
        String id = this.getIdFromName(name);
        if (id == null) {
            throw new CustomColumnsException(1, name);
        }
        return (CustomColumn)this.mapIdCustomColum.get(id);
    }

    public CustomColumn getCustomColumnByID(String id) {
        return (CustomColumn)this.mapIdCustomColum.get(id);
    }

    public boolean exists(String colName) {
        return this.getIdFromName(colName) != null;
    }

    public boolean existsForID(String id) {
        return this.mapIdCustomColum.keySet().contains(id);
    }

    public void renameCustomColumn(String name, String newName) {
        String id = this.getIdFromName(name);
        if (id != null) {
            CustomColumn cc = (CustomColumn)this.mapIdCustomColum.get(id);
            cc.setName(newName);
        }
    }

    public void changeDefaultValue(String colName, Object newDefaultValue) throws CustomColumnsException {
        String id = this.getIdFromName(colName);
        if (id != null) {
            CustomColumn cc = (CustomColumn)this.mapIdCustomColum.get(id);
            if (newDefaultValue.getClass().isAssignableFrom(cc.getType())) {
                cc.setDefaultValue(newDefaultValue);
            } else {
                try {
                    if (cc.getType().equals(Boolean.class)) {
                        cc.setDefaultValue(Boolean.valueOf(newDefaultValue.toString()));
                    } else if (cc.getType().equals(Integer.class)) {
                        cc.setDefaultValue(Integer.valueOf(newDefaultValue.toString()));
                    } else if (cc.getType().equals(Double.class)) {
                        cc.setDefaultValue(Double.valueOf(newDefaultValue.toString()));
                    } else if (GregorianCalendar.class.isAssignableFrom(cc.getType())) {
                        cc.setDefaultValue(DateUtils.parseDate(newDefaultValue.toString(), GanttLanguage.getInstance().getLocale()));
                    }
                }
                catch (Exception ee) {
                    throw new CustomColumnsException(2, "Try to set a '" + newDefaultValue.getClass() + "' for '" + cc.getType() + "'");
                }
            }
        }
    }

    public String getIdFromName(String name) {
        String id = null;
        Iterator it = this.mapIdCustomColum.values().iterator();
        while (it.hasNext()) {
            CustomColumn cc = (CustomColumn)it.next();
            if (!cc.getName().equals(name)) continue;
            id = cc.getId();
            break;
        }
        return id;
    }

    public String getNameFromId(String id) {
        return ((CustomColumn)this.mapIdCustomColum.get(id)).getName();
    }

    public void processNewTask(Task task) {
        Iterator it = this.mapIdCustomColum.values().iterator();
        while (it.hasNext()) {
            CustomColumn cc = (CustomColumn)it.next();
            try {
                task.getCustomValues().setValue(cc.getName(), cc.getDefaultValue());
            }
            catch (CustomColumnsException e) {
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        return this.mapIdCustomColum.toString();
    }

    static {
        CustomColumnsStorage.initTypes();
    }
}

