/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.task;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.ganttproject.Mediator;
import net.sourceforge.ganttproject.task.CustomColumnsException;
import net.sourceforge.ganttproject.task.CustomColumnsStorage;

public class CustomColumnsValues
implements Cloneable {
    private Map mapCustomColumnValue = new HashMap();

    public void setValue(String customColName, Object value) throws CustomColumnsException {
        CustomColumnsStorage ccs = Mediator.getCustomColumnsStorage();
        if (!Mediator.getCustomColumnsStorage().exists(customColName)) {
            throw new CustomColumnsException(1, customColName);
        }
        Class c1 = Mediator.getCustomColumnsStorage().getCustomColumn(customColName).getType();
        Class<?> c2 = value.getClass();
        if (value != null && !c1.isAssignableFrom(c2)) {
            throw new CustomColumnsException(2, null);
        }
        this.mapCustomColumnValue.put(customColName, value);
    }

    public Object getValue(String customColName) {
        return this.mapCustomColumnValue.get(customColName);
    }

    public void removeCustomColumn(String colName) {
        this.mapCustomColumnValue.remove(colName);
    }

    public void renameCustomColumn(String oldName, String newName) {
        Object o = this.mapCustomColumnValue.get(oldName);
        this.mapCustomColumnValue.put(newName, o);
        this.mapCustomColumnValue.remove(oldName);
    }

    public Object clone() {
        CustomColumnsValues res = new CustomColumnsValues();
        Iterator it = this.mapCustomColumnValue.keySet().iterator();
        while (it.hasNext()) {
            Object k = it.next();
            res.mapCustomColumnValue.put(k, this.mapCustomColumnValue.get(k));
        }
        return res;
    }

    public String toString() {
        return this.mapCustomColumnValue.toString();
    }
}

