/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.task.algorithm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskContainmentHierarchyFacade;
import net.sourceforge.ganttproject.task.TaskMutator;
import net.sourceforge.ganttproject.task.algorithm.AlgorithmBase;
import net.sourceforge.ganttproject.task.algorithm.RecalculateTaskScheduleAlgorithm;
import net.sourceforge.ganttproject.task.algorithm.SortTasksAlgorithm;
import net.sourceforge.ganttproject.task.dependency.TaskDependencyException;

public abstract class AdjustTaskBoundsAlgorithm
extends AlgorithmBase {
    private Set myModifiedTasks = new HashSet();

    public void run(Task task) {
        this.run(new Task[]{task});
    }

    public void run(Task[] tasks) {
        if (!this.isEnabled()) {
            return;
        }
        HashSet<Task> taskSet = new HashSet<Task>(Arrays.asList(tasks));
        this.myModifiedTasks.addAll(taskSet);
        TaskContainmentHierarchyFacade containmentFacade = this.createContainmentFacade();
        while (!taskSet.isEmpty()) {
            this.recalculateSupertaskScheduleBottomUp(taskSet, containmentFacade);
            taskSet.clear();
            Iterator modified = this.myModifiedTasks.iterator();
            while (modified.hasNext()) {
                Task nextTask = (Task)modified.next();
                Task supertask = containmentFacade.getContainer(nextTask);
                if (supertask == null) continue;
                taskSet.add(supertask);
            }
            this.myModifiedTasks.clear();
        }
        this.myModifiedTasks.clear();
    }

    public void adjustNestedTasks(Task supertask) throws TaskDependencyException {
        TaskContainmentHierarchyFacade containmentFacade = this.createContainmentFacade();
        ArrayList<Task> nestedTasks = new ArrayList<Task>(Arrays.asList(containmentFacade.getNestedTasks(supertask)));
        if (nestedTasks.size() == 0) {
            return;
        }
        SortTasksAlgorithm sortAlgorithm = new SortTasksAlgorithm();
        sortAlgorithm.sortTasksByStartDate(nestedTasks);
        HashSet<Task> modifiedTasks = new HashSet<Task>();
        for (int i = 0; i < nestedTasks.size(); ++i) {
            TaskMutator mutator;
            Task nextNested = (Task)nestedTasks.get(i);
            if (nextNested.getStart().getTime().before(supertask.getStart().getTime())) {
                mutator = nextNested.createMutatorFixingDuration();
                mutator.setStart(supertask.getStart());
                mutator.commit();
                modifiedTasks.add(nextNested);
            }
            if (!nextNested.getEnd().getTime().after(supertask.getEnd().getTime())) continue;
            mutator = nextNested.createMutatorFixingDuration();
            mutator.shift(supertask.getManager().createLength(supertask.getDuration().getTimeUnit(), nextNested.getEnd().getTime(), supertask.getEnd().getTime()));
            mutator.commit();
            modifiedTasks.add(nextNested);
        }
        this.run(modifiedTasks.toArray(new Task[0]));
        RecalculateTaskScheduleAlgorithm alg = new RecalculateTaskScheduleAlgorithm(this){

            protected TaskContainmentHierarchyFacade createContainmentFacade() {
                return AdjustTaskBoundsAlgorithm.this.createContainmentFacade();
            }
        };
        alg.run(modifiedTasks);
    }

    private void recalculateSupertaskScheduleBottomUp(Set supertasks, TaskContainmentHierarchyFacade containmentFacade) {
        Iterator it = supertasks.iterator();
        while (it.hasNext()) {
            Task nextSupertask = (Task)it.next();
            this.recalculateSupertaskSchedule(nextSupertask, containmentFacade);
        }
    }

    private void recalculateSupertaskSchedule(Task supertask, TaskContainmentHierarchyFacade containmentFacade) {
        Task[] nested = containmentFacade.getNestedTasks(supertask);
        if (nested.length == 0) {
            return;
        }
        GanttCalendar maxEnd = null;
        GanttCalendar minStart = null;
        for (int i = 0; i < nested.length; ++i) {
            Task nextNested = nested[i];
            GanttCalendar nextStart = nextNested.getStart();
            if (minStart == null || nextStart.compareTo(minStart) < 0) {
                minStart = nextStart;
            }
            GanttCalendar nextEnd = nextNested.getEnd();
            if (maxEnd != null && nextEnd.compareTo(maxEnd) <= 0) continue;
            maxEnd = nextEnd;
        }
        TaskMutator mutator = supertask.createMutator();
        if (minStart.compareTo(supertask.getStart()) != 0) {
            mutator.setStart(minStart);
        }
        if (maxEnd.compareTo(supertask.getEnd()) != 0) {
            mutator.setEnd(maxEnd);
        }
        mutator.commit();
    }

    protected abstract TaskContainmentHierarchyFacade createContainmentFacade();
}

