/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.task.dependency;

import java.util.Date;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskActivity;
import net.sourceforge.ganttproject.task.dependency.TaskDependencyConstraint;

public interface TaskDependency {
    public Task getDependant();

    public Task getDependee();

    public void setConstraint(TaskDependencyConstraint var1);

    public TaskDependencyConstraint getConstraint();

    public ActivityBinding getActivityBinding();

    public void delete();

    public int getDifference();

    public void setDifference(int var1);

    public Hardness getHardness();

    public void setHardness(Hardness var1);

    public static interface ActivityBinding {
        public TaskActivity getDependantActivity();

        public TaskActivity getDependeeActivity();

        public Date[] getAlignedBounds();
    }

    public static abstract class Hardness {
        public static final Hardness RUBBER = new Hardness("Rubber"){

            public String toString() {
                return GanttLanguage.getInstance().getText("hardness.rubber");
            }
        };
        public static final Hardness STRONG = new Hardness("Strong"){

            public String toString() {
                return GanttLanguage.getInstance().getText("hardness.strong");
            }
        };
        private String myID;

        public static Hardness parse(String hardnessAsString) {
            if (hardnessAsString == null) {
                throw new IllegalArgumentException("Null value is not allowed as hardness");
            }
            if ("Rubber".equals(hardnessAsString.trim())) {
                return RUBBER;
            }
            if ("Strong".equals(hardnessAsString.trim())) {
                return STRONG;
            }
            throw new IllegalArgumentException("Unexpected hardness string value=" + hardnessAsString);
        }

        private Hardness(String id) {
            this.myID = id;
        }

        public String getIdentifier() {
            return this.myID;
        }
    }
}

