/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.task.dependency;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskContainmentHierarchyFacade;
import net.sourceforge.ganttproject.task.dependency.EventDispatcher;
import net.sourceforge.ganttproject.task.dependency.RangeSearchFromKey;
import net.sourceforge.ganttproject.task.dependency.RangeSearchToKey;
import net.sourceforge.ganttproject.task.dependency.SearchKey;
import net.sourceforge.ganttproject.task.dependency.TaskDependency;
import net.sourceforge.ganttproject.task.dependency.TaskDependencyCollection;
import net.sourceforge.ganttproject.task.dependency.TaskDependencyCollectionMutator;
import net.sourceforge.ganttproject.task.dependency.TaskDependencyConstraint;
import net.sourceforge.ganttproject.task.dependency.TaskDependencyException;
import net.sourceforge.ganttproject.task.dependency.TaskDependencyImpl;
import net.sourceforge.ganttproject.task.dependency.constraint.FinishFinishConstraintImpl;
import net.sourceforge.ganttproject.task.dependency.constraint.FinishStartConstraintImpl;

public class TaskDependencyCollectionImpl
implements TaskDependencyCollection {
    private Set myDependencies = new HashSet();
    private SortedMap mySearchKey2dependency = new TreeMap();
    private final EventDispatcher myEventDispatcher;
    private final TaskContainmentHierarchyFacade.Factory myTaskHierarchyFactory;

    public TaskDependencyCollectionImpl(TaskContainmentHierarchyFacade.Factory taskHierarchyFactory, EventDispatcher myEventDispatcher) {
        this.myEventDispatcher = myEventDispatcher;
        this.myTaskHierarchyFactory = taskHierarchyFactory;
    }

    public TaskDependency[] getDependencies() {
        return this.myDependencies.toArray(new TaskDependency[0]);
    }

    public TaskDependency[] getDependencies(Task task) {
        RangeSearchFromKey fromKey = new RangeSearchFromKey(task);
        RangeSearchToKey toKey = new RangeSearchToKey(task);
        SortedMap submap = this.mySearchKey2dependency.subMap(fromKey, toKey);
        return submap.values().toArray(new TaskDependency[0]);
    }

    public TaskDependency[] getDependenciesAsDependant(Task dependant) {
        SearchKey fromKey = new SearchKey(1, dependant.getTaskID(), -1);
        SearchKey toKey = new SearchKey(2, dependant.getTaskID(), -1);
        SortedMap submap = this.mySearchKey2dependency.subMap(fromKey, toKey);
        return submap.values().toArray(new TaskDependency[0]);
    }

    public TaskDependency[] getDependenciesAsDependee(Task dependee) {
        SearchKey fromKey = new SearchKey(2, dependee.getTaskID(), -1);
        SearchKey toKey = new SearchKey(Integer.MAX_VALUE, dependee.getTaskID(), -1);
        SortedMap submap = this.mySearchKey2dependency.subMap(fromKey, toKey);
        return submap.values().toArray(new TaskDependency[0]);
    }

    public TaskDependency createDependency(Task dependant, Task dependee) throws TaskDependencyException {
        return this.createDependency(dependant, dependee, new FinishStartConstraintImpl());
    }

    public TaskDependency createDependency(Task dependant, Task dependee, TaskDependencyConstraint constraint) throws TaskDependencyException {
        TaskDependency result = this.auxCreateDependency(dependant, dependee, constraint);
        this.addDependency(result);
        return result;
    }

    public boolean canCreateDependency(Task dependant, Task dependee) {
        if (dependant == dependee) {
            return false;
        }
        if (!this.getTaskHierarchy().areUnrelated(dependant, dependee)) {
            return false;
        }
        SearchKey key = new SearchKey(1, dependant.getTaskID(), dependee.getTaskID());
        return !this.mySearchKey2dependency.containsKey(key);
    }

    public void deleteDependency(TaskDependency dependency) {
        this.delete(dependency);
    }

    public void clear() {
        this.doClear();
    }

    public TaskDependencyCollectionMutator createMutator() {
        return new MutatorImpl();
    }

    private TaskDependency auxCreateDependency(Task dependant, Task dependee, TaskDependencyConstraint constraint) {
        TaskDependencyImpl result = new TaskDependencyImpl(dependant, dependee, this);
        result.setConstraint(constraint);
        result.setDifference(0);
        return result;
    }

    void addDependency(TaskDependency dep) throws TaskDependencyException {
        if (this.myDependencies.contains(dep)) {
            throw new TaskDependencyException("Dependency=" + dep + " already exists");
        }
        if (this.isLooping(dep)) {
            throw new TaskDependencyException("Dependency=" + dep + " is looping");
        }
        if (!this.getTaskHierarchy().areUnrelated(dep.getDependant(), dep.getDependee())) {
            throw new TaskDependencyException("In dependency=" + dep + " one of participants is a supertask of another");
        }
        this.myDependencies.add(dep);
        this.mySearchKey2dependency.put(new SearchKey(1, (TaskDependencyImpl)dep), dep);
        this.mySearchKey2dependency.put(new SearchKey(2, (TaskDependencyImpl)dep), dep);
        this.myEventDispatcher.fireDependencyAdded(dep);
    }

    boolean isLooping(TaskDependency dep) {
        HashSet<Task> tasksInvolved = new HashSet<Task>();
        tasksInvolved.add(dep.getDependee());
        return this.isLooping(dep, tasksInvolved);
    }

    private boolean isLooping(TaskDependency dep, Set tasksInvolved) {
        int i;
        Task dependant = dep.getDependant();
        if (tasksInvolved.contains(dependant)) {
            return true;
        }
        Iterator tasks = tasksInvolved.iterator();
        while (tasks.hasNext()) {
            Task nextInvolved = (Task)tasks.next();
            if (this.getTaskHierarchy().areUnrelated(nextInvolved, dependant)) continue;
            return true;
        }
        tasksInvolved.add(dependant);
        TaskDependency[] nextDeps = dependant.getDependenciesAsDependee().toArray();
        for (i = 0; i < nextDeps.length; ++i) {
            if (!this.isLooping(nextDeps[i], tasksInvolved)) continue;
            return true;
        }
        Task[] nestedTasks = this.getTaskHierarchy().getNestedTasks(dependant);
        for (i = 0; i < nestedTasks.length; ++i) {
            tasksInvolved.add(nestedTasks[i]);
            TaskDependency[] nextDeps2 = nestedTasks[i].getDependenciesAsDependee().toArray();
            for (int j = 0; j < nextDeps2.length; ++j) {
                if (!this.isLooping(nextDeps2[j], tasksInvolved)) continue;
                return true;
            }
        }
        tasksInvolved.remove(dependant);
        return false;
    }

    void delete(TaskDependency dep) {
        this.myDependencies.remove(dep);
        SearchKey key1 = new SearchKey(1, dep.getDependant().getTaskID(), dep.getDependee().getTaskID());
        SearchKey key2 = new SearchKey(2, dep.getDependee().getTaskID(), dep.getDependant().getTaskID());
        this.mySearchKey2dependency.remove(key1);
        this.mySearchKey2dependency.remove(key2);
        this.myEventDispatcher.fireDependencyRemoved(dep);
    }

    public void doClear() {
        this.myDependencies.clear();
        this.mySearchKey2dependency.clear();
    }

    protected TaskContainmentHierarchyFacade getTaskHierarchy() {
        return this.myTaskHierarchyFactory.createFacede();
    }

    private static class MutationInfo
    implements Comparable {
        static final int ADD = 0;
        static final int DELETE = 1;
        static final int CLEAR = 2;
        final TaskDependency myDependency;
        final int myOperation;
        final int myOrder = ourOrder++;
        static int ourOrder;

        public MutationInfo(TaskDependency myDependency, int myOperation) {
            this.myDependency = myDependency;
            this.myOperation = myOperation;
        }

        public int compareTo(Object o) {
            MutationInfo rvalue = (MutationInfo)o;
            return this.myOrder - rvalue.myOrder;
        }
    }

    private class MutatorImpl
    implements TaskDependencyCollectionMutator {
        private Map myQueue = new LinkedHashMap();
        private MutationInfo myCleanupMutation;

        private MutatorImpl() {
        }

        public void commit() {
            ArrayList mutations = new ArrayList(this.myQueue.values());
            if (this.myCleanupMutation != null) {
                mutations.add(this.myCleanupMutation);
            }
            Collections.sort(mutations);
            block7: for (int i = 0; i < mutations.size(); ++i) {
                MutationInfo next = (MutationInfo)mutations.get(i);
                switch (next.myOperation) {
                    case 0: {
                        try {
                            TaskDependencyCollectionImpl.this.addDependency(next.myDependency);
                        }
                        catch (TaskDependencyException e) {
                            e.printStackTrace();
                        }
                        continue block7;
                    }
                    case 1: {
                        TaskDependencyCollectionImpl.this.delete(next.myDependency);
                        continue block7;
                    }
                    case 2: {
                        TaskDependencyCollectionImpl.this.doClear();
                    }
                }
            }
        }

        public void clear() {
            this.myQueue.clear();
            this.myCleanupMutation = new MutationInfo(null, 2);
        }

        public TaskDependency createDependency(Task dependant, Task dependee) throws TaskDependencyException {
            return this.createDependency(dependant, dependee, new FinishFinishConstraintImpl());
        }

        public TaskDependency createDependency(Task dependant, Task dependee, TaskDependencyConstraint constraint) throws TaskDependencyException {
            TaskDependency result = TaskDependencyCollectionImpl.this.auxCreateDependency(dependant, dependee, constraint);
            this.myQueue.put(result, new MutationInfo(result, 0));
            return result;
        }

        public void deleteDependency(TaskDependency dependency) {
            MutationInfo info = (MutationInfo)this.myQueue.get(dependency);
            if (info == null) {
                this.myQueue.put(dependency, new MutationInfo(dependency, 1));
            } else if (info.myOperation == 0) {
                this.myQueue.remove(dependency);
            }
        }
    }
}

