/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.time;

import java.util.Date;
import net.sourceforge.ganttproject.time.DateFrameable;
import net.sourceforge.ganttproject.time.TextFormatter;
import net.sourceforge.ganttproject.time.TimeUnit;
import net.sourceforge.ganttproject.time.TimeUnitDateFrameableImpl;
import net.sourceforge.ganttproject.time.TimeUnitFunctionOfDate;
import net.sourceforge.ganttproject.time.TimeUnitGraph;
import net.sourceforge.ganttproject.time.TimeUnitText;

public class TimeUnitFunctionOfDateImpl
extends TimeUnitDateFrameableImpl
implements TimeUnitFunctionOfDate {
    private final DateFrameable myDirectFrameable;

    public TimeUnitFunctionOfDateImpl(String name, TimeUnitGraph graph, TimeUnit directAtomUnit, DateFrameable framer) {
        super(name, graph, directAtomUnit, framer);
        if (!(directAtomUnit instanceof DateFrameable)) {
            throw new IllegalArgumentException("Only date frameable time units may be used as atoms for functions of date");
        }
        this.myDirectFrameable = directAtomUnit;
    }

    public TimeUnit createTimeUnit(Date date) {
        return new ParameterizedTimeUnitImpl(date);
    }

    public int getAtomCount(TimeUnit atomUnit) {
        throw new UnsupportedOperationException("This time unit is function of date. Use method createTimeUnit() to create a parameterized instance.");
    }

    private class ParameterizedTimeUnitImpl
    implements TimeUnit,
    DateFrameable {
        private final Date myBaseDate;
        private final Date myRightDate;
        private final Date myLeftDate;
        private int myAtomCount = -1;
        private TextFormatter myTextFormatter;

        public ParameterizedTimeUnitImpl(Date myBaseDate) {
            this.myBaseDate = myBaseDate;
            this.myRightDate = TimeUnitFunctionOfDateImpl.this.adjustRight(myBaseDate);
            this.myLeftDate = TimeUnitFunctionOfDateImpl.this.adjustLeft(myBaseDate);
        }

        public String getName() {
            return TimeUnitFunctionOfDateImpl.this.getName();
        }

        public boolean isConstructedFrom(TimeUnit unit) {
            return TimeUnitFunctionOfDateImpl.this.isConstructedFrom(unit);
        }

        public int getAtomCount(TimeUnit atomUnit) {
            if (atomUnit == TimeUnitFunctionOfDateImpl.this || atomUnit == this) {
                return 1;
            }
            int directAtomCount = this.getDirectAtomCount();
            return directAtomCount * this.getDirectAtomUnit().getAtomCount(atomUnit);
        }

        private int getDirectAtomCount() {
            if (this.myAtomCount == -1) {
                this.myAtomCount = 0;
                Date leftDate = TimeUnitFunctionOfDateImpl.this.myDirectFrameable.jumpLeft(this.myRightDate);
                while (leftDate.compareTo(this.myLeftDate) >= 0) {
                    leftDate = TimeUnitFunctionOfDateImpl.this.myDirectFrameable.jumpLeft(leftDate);
                    ++this.myAtomCount;
                }
            }
            return this.myAtomCount;
        }

        public TimeUnit getDirectAtomUnit() {
            return TimeUnitFunctionOfDateImpl.this.getDirectAtomUnit();
        }

        public Date adjustRight(Date baseDate) {
            return TimeUnitFunctionOfDateImpl.this.adjustRight(baseDate);
        }

        public Date adjustLeft(Date baseDate) {
            return TimeUnitFunctionOfDateImpl.this.adjustLeft(baseDate);
        }

        public Date jumpLeft(Date baseDate) {
            return TimeUnitFunctionOfDateImpl.this.jumpLeft(baseDate);
        }

        public void setTextFormatter(TextFormatter formatter) {
            TimeUnitFunctionOfDateImpl.this.setTextFormatter(formatter);
        }

        public TimeUnitText format(Date baseDate) {
            TextFormatter formatter = TimeUnitFunctionOfDateImpl.this.getTextFormatter();
            return formatter == null ? new TimeUnitText("") : formatter.format(this, baseDate);
        }

        public boolean equals(Object o) {
            return TimeUnitFunctionOfDateImpl.this.equals(o);
        }
    }
}

