/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.time;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.ganttproject.time.DateFrameable;
import net.sourceforge.ganttproject.time.TimeUnit;
import net.sourceforge.ganttproject.time.TimeUnitDateFrameableImpl;
import net.sourceforge.ganttproject.time.TimeUnitFunctionOfDate;
import net.sourceforge.ganttproject.time.TimeUnitFunctionOfDateImpl;
import net.sourceforge.ganttproject.time.TimeUnitImpl;

public class TimeUnitGraph {
    private Map myUnit2compositions = new HashMap();

    public TimeUnit createAtomTimeUnit(String name) {
        TimeUnitImpl result = new TimeUnitImpl(name, this, null);
        ArrayList<Composition> compositions = new ArrayList<Composition>();
        compositions.add(new Composition(result, 1));
        this.myUnit2compositions.put(result, compositions);
        return result;
    }

    TimeUnit createTimeUnit(String name, TimeUnit atomUnit, int count) {
        TimeUnitImpl result = new TimeUnitImpl(name, this, atomUnit);
        this.registerTimeUnit(result, count);
        return result;
    }

    public TimeUnit createDateFrameableTimeUnit(String name, TimeUnit atomUnit, int atomCount, DateFrameable framer) {
        TimeUnitDateFrameableImpl result = new TimeUnitDateFrameableImpl(name, this, atomUnit, framer);
        this.registerTimeUnit(result, atomCount);
        return result;
    }

    public TimeUnitFunctionOfDate createTimeUnitFunctionOfDate(String name, TimeUnit atomUnit, DateFrameable framer) {
        TimeUnitFunctionOfDateImpl result = new TimeUnitFunctionOfDateImpl(name, this, atomUnit, framer);
        this.registerTimeUnit(result, -1);
        return result;
    }

    private void registerTimeUnit(TimeUnit unit, int atomCount) {
        TimeUnit atomUnit = unit.getDirectAtomUnit();
        List transitiveCompositions = (List)this.myUnit2compositions.get(atomUnit);
        if (transitiveCompositions == null) {
            throw new RuntimeException("Atom unit=" + atomUnit + " is unknown");
        }
        ArrayList<Composition> compositions = new ArrayList<Composition>(transitiveCompositions.size() + 1);
        compositions.add(new Composition(unit, 1));
        for (int i = 0; i < transitiveCompositions.size(); ++i) {
            Composition nextTransitive = (Composition)transitiveCompositions.get(i);
            compositions.add(new Composition(nextTransitive, atomCount));
        }
        this.myUnit2compositions.put(unit, compositions);
    }

    public Composition getComposition(TimeUnitImpl timeUnit, TimeUnit atomUnit) {
        Composition result = null;
        List compositions = (List)this.myUnit2compositions.get(timeUnit);
        if (compositions == null) {
            throw new RuntimeException("Unit=" + timeUnit + " has no compositions");
        }
        for (int i = 0; i < compositions.size(); ++i) {
            Composition next = (Composition)compositions.get(i);
            if (!next.myAtom.equals(atomUnit)) continue;
            result = next;
            break;
        }
        return result;
    }

    class Composition {
        final TimeUnit myAtom;
        final int myAtomCount;

        Composition(TimeUnit atomUnit, int atomCount) {
            this.myAtom = atomUnit;
            this.myAtomCount = atomCount;
        }

        Composition(Composition transitiveComposition, int atomCount) {
            this.myAtomCount = atomCount * transitiveComposition.myAtomCount;
            this.myAtom = transitiveComposition.myAtom;
        }

        int getAtomCount() {
            return this.myAtomCount;
        }
    }
}

