/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.time;

import net.sourceforge.ganttproject.util.TextLengthCalculator;

public class TimeUnitText {
    private String myLongText;
    private String myMediumText;
    private String myShortText;
    private int myMinimaxLong = -1;
    private int myMinimaxMedium = -1;
    private int myMinimaxShort = -1;
    private Object myCalculatorState;

    public TimeUnitText(String longText, String mediumText, String shortText) {
        this.myLongText = longText;
        this.myMediumText = mediumText;
        this.myShortText = shortText;
    }

    public TimeUnitText(String mediumText) {
        this.myMediumText = mediumText;
        this.myLongText = mediumText;
        this.myShortText = mediumText;
    }

    public String getText(int maxLength) {
        return this.myMediumText;
    }

    public String getText(int requestedMaxLength, TextLengthCalculator calculator) {
        String result = null;
        if (!calculator.getState().equals(this.myCalculatorState)) {
            this.myCalculatorState = calculator.getState();
            this.myMinimaxLong = calculator.getTextLength(this.myLongText);
            this.myMinimaxMedium = calculator.getTextLength(this.myMediumText);
            this.myMinimaxShort = calculator.getTextLength(this.myShortText);
        }
        return (result = this.getCachedText(requestedMaxLength)) == null ? "" : result;
    }

    private String getCachedText(int maxLength) {
        if (this.myMinimaxLong >= 0 && this.myMinimaxLong <= maxLength) {
            return this.myLongText;
        }
        if (this.myMinimaxMedium >= 0 && this.myMinimaxMedium <= maxLength) {
            return this.myMediumText;
        }
        if (this.myMinimaxShort >= 0 && this.myMinimaxShort <= maxLength) {
            return this.myShortText;
        }
        return null;
    }

    public String toString() {
        return "long=" + this.myLongText + ", medium=" + this.myMediumText + ", short=" + this.myShortText;
    }
}

