/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.jar.Manifest;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentJarClassLoader;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.svg.XMLBaseSupport;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterException;
import org.apache.batik.script.ScriptHandler;
import org.apache.batik.script.Window;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class BaseScriptingEnvironment {
    protected static final String EVENT_NAME = "event";
    protected static final String ALTERNATE_EVENT_NAME = "evt";
    protected BridgeContext bridgeContext;
    protected UserAgent userAgent;
    protected Document document;
    protected ParsedURL docPURL;

    public static boolean isDynamicDocument(Document doc) {
        Element elt = doc.getDocumentElement();
        if (elt.getNamespaceURI().equals("http://www.w3.org/2000/svg")) {
            if (elt.getAttributeNS(null, "onabort").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onerror").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onresize").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onunload").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onscroll").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onzoom").length() > 0) {
                return true;
            }
            return BaseScriptingEnvironment.isDynamicElement(doc.getDocumentElement());
        }
        return false;
    }

    public static boolean isDynamicElement(Element elt) {
        if ("http://www.w3.org/2000/svg".equals(elt.getNamespaceURI())) {
            String name = elt.getLocalName();
            if (name.equals("script")) {
                return true;
            }
            if (name.startsWith("animate") || name.equals("set")) {
                return true;
            }
            if (elt.getAttributeNS(null, "onkeyup").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onkeydown").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onkeypress").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onload").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onerror").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onactivate").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onclick").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onfocusin").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onfocusout").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onmousedown").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onmousemove").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onmouseout").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onmouseover").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onmouseup").length() > 0) {
                return true;
            }
            Node n = elt.getFirstChild();
            while (n != null) {
                if (n.getNodeType() == 1 && BaseScriptingEnvironment.isDynamicElement((Element)n)) {
                    return true;
                }
                n = n.getNextSibling();
            }
        }
        return false;
    }

    public BaseScriptingEnvironment(BridgeContext ctx) {
        this.bridgeContext = ctx;
        this.document = ctx.getDocument();
        this.docPURL = new ParsedURL(((SVGDocument)this.document).getURL());
        this.userAgent = this.bridgeContext.getUserAgent();
    }

    public org.apache.batik.script.Window createWindow(Interpreter interp, String lang) {
        return new Window(interp, lang);
    }

    public org.apache.batik.script.Window createWindow() {
        return this.createWindow(null, null);
    }

    public void initializeEnvironment(Interpreter interp, String lang) {
        interp.bindObject("window", (Object)this.createWindow(interp, lang));
    }

    public void loadScripts() {
        org.apache.batik.script.Window window = null;
        NodeList scripts = this.document.getElementsByTagNameNS("http://www.w3.org/2000/svg", "script");
        int len = scripts.getLength();
        if (len == 0) {
            return;
        }
        HashSet<String> languages = new HashSet<String>();
        int i = 0;
        while (i < len) {
            block23: {
                Element script = (Element)scripts.item(i);
                String type = script.getAttributeNS(null, "type");
                if (type.length() == 0) {
                    type = "text/ecmascript";
                }
                if (type.equals("application/java-archive")) {
                    try {
                        Manifest man;
                        String sh;
                        String href = XLinkSupport.getXLinkHref((Element)script);
                        ParsedURL purl = new ParsedURL(XMLBaseSupport.getCascadedXMLBase(script), href);
                        this.checkCompatibleScriptURL(type, purl);
                        URL docURL = null;
                        try {
                            docURL = new URL(this.docPURL.toString());
                        }
                        catch (MalformedURLException mue) {
                            // empty catch block
                        }
                        DocumentJarClassLoader cll = new DocumentJarClassLoader(new URL(purl.toString()), docURL);
                        URL url = cll.findResource("META-INF/MANIFEST.MF");
                        if (url != null && (sh = (man = new Manifest(url.openStream())).getMainAttributes().getValue("Script-Handler")) != null) {
                            ScriptHandler h = (ScriptHandler)cll.loadClass(sh).newInstance();
                            if (window == null) {
                                window = this.createWindow();
                            }
                            h.run(this.document, window);
                        }
                        break block23;
                    }
                    catch (Exception e) {
                        if (this.userAgent != null) {
                            this.userAgent.displayError(e);
                        }
                        break block23;
                    }
                }
                Interpreter interpreter = this.bridgeContext.getInterpreter(type);
                if (interpreter == null) {
                    UserAgent ua = this.bridgeContext.getUserAgent();
                    if (ua != null) {
                        ua.displayError(new Exception("Unknown language: " + type));
                    }
                    return;
                }
                if (!languages.contains(type)) {
                    languages.add(type);
                    this.initializeEnvironment(interpreter, type);
                }
                try {
                    Reader reader;
                    String href = XLinkSupport.getXLinkHref((Element)script);
                    if (href.length() > 0) {
                        ParsedURL purl = new ParsedURL(XMLBaseSupport.getCascadedXMLBase(script), href);
                        this.checkCompatibleScriptURL(type, purl);
                        reader = new InputStreamReader(purl.openStream());
                    } else {
                        Node n = script.getFirstChild();
                        if (n == null) break block23;
                        StringBuffer sb = new StringBuffer();
                        while (n != null) {
                            sb.append(n.getNodeValue());
                            n = n.getNextSibling();
                        }
                        reader = new StringReader(sb.toString());
                    }
                    interpreter.evaluate(reader);
                }
                catch (IOException e) {
                    if (this.userAgent != null) {
                        this.userAgent.displayError(e);
                    }
                    return;
                }
                catch (InterpreterException e) {
                    this.handleInterpreterException(e);
                    return;
                }
                catch (SecurityException e) {
                    if (this.userAgent == null) break block23;
                    this.userAgent.displayError(e);
                }
            }
            ++i;
        }
    }

    protected void checkCompatibleScriptURL(String scriptType, ParsedURL scriptPURL) {
        this.userAgent.checkLoadScript(scriptType, scriptPURL, this.docPURL);
    }

    public void dispatchSVGLoadEvent() {
        SVGSVGElement root = (SVGSVGElement)this.document.getDocumentElement();
        String lang = root.getContentScriptType();
        Interpreter interp = this.bridgeContext.getInterpreter(lang);
        if (interp == null) {
            UserAgent ua = this.bridgeContext.getUserAgent();
            if (ua != null) {
                ua.displayError(new Exception("Unknown language: " + lang));
            }
            return;
        }
        this.dispatchSVGLoad(root, interp, true, lang);
    }

    protected void dispatchSVGLoad(Element elt, final Interpreter interp, boolean checkCanRun, String lang) {
        Node n = elt.getFirstChild();
        while (n != null) {
            if (n.getNodeType() == 1) {
                this.dispatchSVGLoad((Element)n, interp, checkCanRun, lang);
            }
            n = n.getNextSibling();
        }
        DocumentEvent de = (DocumentEvent)((Object)elt.getOwnerDocument());
        Event ev = de.createEvent("SVGEvents");
        ev.initEvent("SVGLoad", false, false);
        EventTarget t = (EventTarget)((Object)elt);
        final String s = elt.getAttributeNS(null, "onload");
        EventListener l = null;
        if (s.length() > 0) {
            if (checkCanRun) {
                this.checkCompatibleScriptURL(lang, this.docPURL);
                checkCanRun = false;
            }
            l = new EventListener(){

                public void handleEvent(Event evt) {
                    try {
                        interp.bindObject(BaseScriptingEnvironment.EVENT_NAME, (Object)evt);
                        interp.bindObject(BaseScriptingEnvironment.ALTERNATE_EVENT_NAME, (Object)evt);
                        interp.evaluate((Reader)new StringReader(s));
                    }
                    catch (IOException io) {
                    }
                    catch (InterpreterException e) {
                        BaseScriptingEnvironment.this.handleInterpreterException(e);
                    }
                }
            };
            t.addEventListener("SVGLoad", l, false);
        }
        t.dispatchEvent(ev);
        if (s.length() > 0) {
            t.removeEventListener("SVGLoad", l, false);
        }
    }

    protected void handleInterpreterException(InterpreterException ie) {
        if (this.userAgent != null) {
            Exception ex = ie.getException();
            this.userAgent.displayError((Exception)(ex == null ? ie : ex));
        }
    }

    protected void handleSecurityException(SecurityException se) {
        if (this.userAgent != null) {
            this.userAgent.displayError(se);
        }
    }

    static {
        EVENT_NAME = EVENT_NAME;
        ALTERNATE_EVENT_NAME = ALTERNATE_EVENT_NAME;
    }

    protected class Window
    implements org.apache.batik.script.Window {
        protected Interpreter interpreter;
        protected String language;

        public Window(Interpreter interp, String lang) {
            this.interpreter = interp;
            this.language = lang;
        }

        public Object setInterval(String script, long interval) {
            return null;
        }

        public Object setInterval(Runnable r, long interval) {
            return null;
        }

        public void clearInterval(Object interval) {
        }

        public Object setTimeout(String script, long timeout) {
            return null;
        }

        public Object setTimeout(Runnable r, long timeout) {
            return null;
        }

        public void clearTimeout(Object timeout) {
        }

        public DocumentFragment parseXML(String text, Document doc) {
            return null;
        }

        public void getURL(String uri, Window.GetURLHandler h) {
        }

        public void getURL(String uri, Window.GetURLHandler h, String enc) {
        }

        public void alert(String message) {
        }

        public boolean confirm(String message) {
            return false;
        }

        public String prompt(String message) {
            return null;
        }

        public String prompt(String message, String defVal) {
            return null;
        }

        public BridgeContext getBridgeContext() {
            return BaseScriptingEnvironment.this.bridgeContext;
        }

        public Interpreter getInterpreter() {
            return this.interpreter;
        }
    }
}

