/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.AffineTransform;
import java.util.StringTokenizer;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.parser.AWTTransformProducer;
import org.apache.batik.parser.FragmentIdentifierHandler;
import org.apache.batik.parser.FragmentIdentifierParser;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PreserveAspectRatioHandler;
import org.apache.batik.parser.PreserveAspectRatioParser;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ViewBox
implements SVGConstants,
ErrorConstants {
    protected ViewBox() {
    }

    public static AffineTransform getViewTransform(String ref, Element e, float w, float h) {
        boolean meet;
        short align;
        float[] vb;
        if (ref == null || ref.length() == 0) {
            return ViewBox.getPreserveAspectRatioTransform(e, w, h);
        }
        ViewHandler vh = new ViewHandler();
        FragmentIdentifierParser p = new FragmentIdentifierParser();
        p.setFragmentIdentifierHandler((FragmentIdentifierHandler)vh);
        p.parse(ref);
        Element attrDefElement = e;
        if (vh.hasId) {
            Document document = e.getOwnerDocument();
            attrDefElement = document.getElementById(vh.id);
        }
        if (attrDefElement == null) {
            throw new BridgeException(e, "uri.malformed", new Object[]{ref});
        }
        if (!attrDefElement.getNamespaceURI().equals("http://www.w3.org/2000/svg") || !attrDefElement.getLocalName().equals("view")) {
            attrDefElement = ViewBox.getClosestAncestorSVGElement(e);
        }
        if (vh.hasViewBox) {
            vb = vh.viewBox;
        } else {
            String viewBoxStr = attrDefElement.getAttributeNS(null, "viewBox");
            vb = ViewBox.parseViewBoxAttribute(attrDefElement, viewBoxStr);
        }
        if (vh.hasPreserveAspectRatio) {
            align = vh.align;
            meet = vh.meet;
        } else {
            String aspectRatio = attrDefElement.getAttributeNS(null, "preserveAspectRatio");
            PreserveAspectRatioParser pp = new PreserveAspectRatioParser();
            ViewHandler ph = new ViewHandler();
            pp.setPreserveAspectRatioHandler((PreserveAspectRatioHandler)ph);
            try {
                pp.parse(aspectRatio);
            }
            catch (ParseException ex) {
                throw new BridgeException(attrDefElement, "attribute.malformed", new Object[]{"preserveAspectRatio", aspectRatio, ex});
            }
            align = ph.align;
            meet = ph.meet;
        }
        AffineTransform transform = ViewBox.getPreserveAspectRatioTransform(vb, align, meet, w, h);
        if (vh.hasTransform) {
            transform.concatenate(vh.getAffineTransform());
        }
        return transform;
    }

    private static Element getClosestAncestorSVGElement(Element e) {
        Node n = e;
        while (n != null && n.getNodeType() == 1) {
            Element tmp = n;
            if (tmp.getNamespaceURI().equals("http://www.w3.org/2000/svg") && tmp.getLocalName().equals("svg")) {
                return tmp;
            }
            n = n.getParentNode();
        }
        return null;
    }

    public static AffineTransform getPreserveAspectRatioTransform(Element e, float w, float h) {
        String viewBox = e.getAttributeNS(null, "viewBox");
        String aspectRatio = e.getAttributeNS(null, "preserveAspectRatio");
        return ViewBox.getPreserveAspectRatioTransform(e, viewBox, aspectRatio, w, h);
    }

    public static AffineTransform getPreserveAspectRatioTransform(Element e, String viewBox, String aspectRatio, float w, float h) {
        if (viewBox.length() == 0) {
            return new AffineTransform();
        }
        float[] vb = ViewBox.parseViewBoxAttribute(e, viewBox);
        PreserveAspectRatioParser p = new PreserveAspectRatioParser();
        ViewHandler ph = new ViewHandler();
        p.setPreserveAspectRatioHandler((PreserveAspectRatioHandler)ph);
        try {
            p.parse(aspectRatio);
        }
        catch (ParseException ex) {
            throw new BridgeException(e, "attribute.malformed", new Object[]{"preserveAspectRatio", aspectRatio, ex});
        }
        return ViewBox.getPreserveAspectRatioTransform(vb, ph.align, ph.meet, w, h);
    }

    public static AffineTransform getPreserveAspectRatioTransform(Element e, float[] vb, float w, float h) {
        String aspectRatio = e.getAttributeNS(null, "preserveAspectRatio");
        PreserveAspectRatioParser p = new PreserveAspectRatioParser();
        ViewHandler ph = new ViewHandler();
        p.setPreserveAspectRatioHandler((PreserveAspectRatioHandler)ph);
        try {
            p.parse(aspectRatio);
        }
        catch (ParseException ex) {
            throw new BridgeException(e, "attribute.malformed", new Object[]{"preserveAspectRatio", aspectRatio, ex});
        }
        return ViewBox.getPreserveAspectRatioTransform(vb, ph.align, ph.meet, w, h);
    }

    public static float[] parseViewBoxAttribute(Element e, String value) {
        if (value.length() == 0) {
            return null;
        }
        int i = 0;
        float[] vb = new float[4];
        StringTokenizer st = new StringTokenizer(value, " ,");
        try {
            while (i < 4 && st.hasMoreTokens()) {
                vb[i] = Float.parseFloat(st.nextToken());
                ++i;
            }
        }
        catch (NumberFormatException ex) {
            throw new BridgeException(e, "attribute.malformed", new Object[]{"viewBox", value, ex});
        }
        if (i != 4) {
            throw new BridgeException(e, "attribute.malformed", new Object[]{"viewBox", value});
        }
        if (vb[2] < 0.0f || vb[3] < 0.0f) {
            throw new BridgeException(e, "attribute.malformed", new Object[]{"viewBox", value});
        }
        if (vb[2] == 0.0f || vb[3] == 0.0f) {
            return null;
        }
        return vb;
    }

    private static AffineTransform getPreserveAspectRatioTransform(float[] vb, short align, boolean meet, float w, float h) {
        if (vb == null) {
            return new AffineTransform();
        }
        AffineTransform result = new AffineTransform();
        float vpar = vb[2] / vb[3];
        float svgar = w / h;
        if (align == 1) {
            result.scale(w / vb[2], h / vb[3]);
            result.translate(-vb[0], -vb[1]);
        } else if (vpar < svgar && meet || vpar >= svgar && !meet) {
            float sf = h / vb[3];
            result.scale(sf, sf);
            switch (align) {
                case 2: 
                case 5: 
                case 8: {
                    result.translate(-vb[0], -vb[1]);
                    break;
                }
                case 3: 
                case 6: 
                case 9: {
                    result.translate(-vb[0] - (vb[2] - w * vb[3] / h) / 2.0f, -vb[1]);
                    break;
                }
                default: {
                    result.translate(-vb[0] - (vb[2] - w * vb[3] / h), -vb[1]);
                    break;
                }
            }
        } else {
            float sf = w / vb[2];
            result.scale(sf, sf);
            switch (align) {
                case 2: 
                case 3: 
                case 4: {
                    result.translate(-vb[0], -vb[1]);
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    result.translate(-vb[0], -vb[1] - (vb[3] - h * vb[2] / w) / 2.0f);
                    break;
                }
                default: {
                    result.translate(-vb[0], -vb[1] - (vb[3] - h * vb[2] / w));
                }
            }
        }
        return result;
    }

    protected static class ViewHandler
    extends AWTTransformProducer
    implements FragmentIdentifierHandler {
        public boolean hasTransform;
        public boolean hasId;
        public boolean hasViewBox;
        public boolean hasViewTargetParams;
        public boolean hasZoomAndPanParams;
        public String id;
        public float[] viewBox;
        public String viewTargetParams;
        public boolean isMagnify;
        public boolean hasPreserveAspectRatio;
        public short align;
        public boolean meet = true;

        protected ViewHandler() {
        }

        public void endTransformList() throws ParseException {
            super.endTransformList();
            this.hasTransform = true;
        }

        public void startFragmentIdentifier() throws ParseException {
        }

        public void idReference(String s) throws ParseException {
            this.id = s;
            this.hasId = true;
        }

        public void viewBox(float x, float y, float width, float height) throws ParseException {
            this.hasViewBox = true;
            this.viewBox = new float[4];
            this.viewBox[0] = x;
            this.viewBox[1] = y;
            this.viewBox[2] = width;
            this.viewBox[3] = height;
        }

        public void startViewTarget() throws ParseException {
        }

        public void viewTarget(String name) throws ParseException {
            this.viewTargetParams = name;
            this.hasViewTargetParams = true;
        }

        public void endViewTarget() throws ParseException {
        }

        public void zoomAndPan(boolean magnify) {
            this.isMagnify = magnify;
            this.hasZoomAndPanParams = true;
        }

        public void endFragmentIdentifier() throws ParseException {
        }

        public void startPreserveAspectRatio() throws ParseException {
        }

        public void none() throws ParseException {
            this.align = 1;
        }

        public void xMaxYMax() throws ParseException {
            this.align = (short)10;
        }

        public void xMaxYMid() throws ParseException {
            this.align = (short)7;
        }

        public void xMaxYMin() throws ParseException {
            this.align = (short)4;
        }

        public void xMidYMax() throws ParseException {
            this.align = (short)9;
        }

        public void xMidYMid() throws ParseException {
            this.align = (short)6;
        }

        public void xMidYMin() throws ParseException {
            this.align = (short)3;
        }

        public void xMinYMax() throws ParseException {
            this.align = (short)8;
        }

        public void xMinYMid() throws ParseException {
            this.align = (short)5;
        }

        public void xMinYMin() throws ParseException {
            this.align = (short)2;
        }

        public void meet() throws ParseException {
            this.meet = true;
        }

        public void slice() throws ParseException {
            this.meet = false;
        }

        public void endPreserveAspectRatio() throws ParseException {
            this.hasPreserveAspectRatio = true;
        }
    }
}

