/*
 * Decompiled with CFR 0.152.
 */
package org.bardsoftware.impl.eclipsito;

import java.net.URI;
import java.util.logging.Level;
import org.bardsoftware.eclipsito.Boot;
import org.bardsoftware.impl.eclipsito.ApplicationLauncher;
import org.bardsoftware.impl.eclipsito.ModulesDirectoryProcessor;
import org.bardsoftware.impl.eclipsito.PlatformImpl;
import org.bardsoftware.impl.eclipsito.PluginDescriptor;
import org.w3c.dom.Document;

public class BootImpl
extends Boot {
    private static final String ATTRIBUTE_MODULES_DIRECTORY = "modules-directory";
    private static final String ATTRIBUTE_DESCRIPTOR_FILE_PATTERN = "descriptor-file-pattern";
    private static final String ATTRIBUTE_APPLICATION = "application";
    private static final ThreadGroup topThreadGroup = new ThreadGroup("TopThreadGroup"){

        public void uncaughtException(Thread t, Throwable e) {
            Boot.LOG.log(Level.WARNING, "[uncaughtException]" + e, e);
        }
    };
    private PlatformImpl myPlatform;

    public void run(Document config, URI home, String[] args) {
        this.myPlatform = new PlatformImpl(home);
        Boot.LOG.info("Eclipsito platform is running.");
        ShutdownHook.install();
        String application = config.getDocumentElement().getAttribute(ATTRIBUTE_APPLICATION);
        PluginDescriptor[] plugins = this.getPlugins(config, home);
        this.run(plugins, application, args);
    }

    protected PluginDescriptor[] getPlugins(Document config, URI home) {
        String modulesdir = config.getDocumentElement().getAttribute(ATTRIBUTE_MODULES_DIRECTORY);
        String descriptorPattern = config.getDocumentElement().getAttribute(ATTRIBUTE_DESCRIPTOR_FILE_PATTERN);
        URI modulesUrl = home.resolve(modulesdir);
        PluginDescriptor[] plugins = ModulesDirectoryProcessor.process(modulesUrl, descriptorPattern);
        return plugins;
    }

    public void run(PluginDescriptor[] plugins, final String application, final String[] args) {
        this.myPlatform.setup(plugins);
        new Thread(topThreadGroup, "Start"){

            public void run() {
                BootImpl.this.myPlatform.start();
                if (application != null && application.length() > 0) {
                    ApplicationLauncher.launchApplication(application, args);
                }
            }
        }.start();
    }

    public void shutdown() {
        this.myPlatform.stop();
        Boot.LOG.info("Eclipsito platform is shut down.");
    }

    private static class ShutdownHook
    extends Thread {
        public ShutdownHook() {
            super(topThreadGroup, "ShutdownHook-Thread");
            this.setPriority(10);
        }

        public void run() {
            Boot.getInstance().shutdown();
        }

        public static void install() {
            Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        }
    }
}

