/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.datatypes;

import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.messaging.MessageHandler;

public class LengthBase
implements PercentBase {
    public static final int CUSTOM_BASE = 0;
    public static final int FONTSIZE = 1;
    public static final int INH_FONTSIZE = 2;
    public static final int CONTAINING_BOX = 3;
    public static final int CONTAINING_REFAREA = 4;
    protected FObj parentFO;
    private PropertyList propertyList;
    private int iBaseType;

    public LengthBase(FObj parentFO, PropertyList plist, int iBaseType) {
        this.parentFO = parentFO;
        this.propertyList = plist;
        this.iBaseType = iBaseType;
    }

    protected FObj getParentFO() {
        return this.parentFO;
    }

    protected PropertyList getPropertyList() {
        return this.propertyList;
    }

    public int getDimension() {
        return 1;
    }

    public double getBaseValue() {
        return 1.0;
    }

    public int getBaseLength() {
        switch (this.iBaseType) {
            case 1: {
                return this.propertyList.get("font-size").getLength().mvalue();
            }
            case 2: {
                return this.propertyList.getInherited("font-size").getLength().mvalue();
            }
            case 3: {
                return this.parentFO.getContentWidth();
            }
            case 4: {
                FObj fo = this.parentFO;
                while (fo != null && !fo.generatesReferenceAreas()) {
                    fo = fo.getParent();
                }
                return fo != null ? fo.getContentWidth() : 0;
            }
            case 0: {
                MessageHandler.errorln("!!! LengthBase.getBaseLength() called on CUSTOM_BASE type !!!");
                return 0;
            }
        }
        MessageHandler.errorln("Unknown base type for LengthBase.");
        return 0;
    }
}

