/*
 * $Id: MetaDataProvider.java,v 1.2 2004/09/03 21:20:19 aim Exp $
 *
 * Copyright 2004 Sun Microsystems, Inc., 4150 Network Circle,
 * Santa Clara, California 95054, U.S.A. All rights reserved.
 */
package org.jdesktop.swing.data;

/**
 * Interface for marking objects which can return MetaData instances for
 * data objects.
 *
 * @author Jeanette (aka Kleopatra)
 * @author Amy Fowler
 * @version 1.0
 */
public interface MetaDataProvider {

    MetaData[] getMetaData();

    /**
     * Note: String will likely be converted to type Object for the ID
     * @param dataID String containing the id of the data object
     * @return MetaData object which describes properties, edit constraints
     *         and validation logic for a data object
     */
    MetaData getMetaData(String dataID);


}