/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Vector;
import net.sf.memoranda.NoteList;
import net.sf.memoranda.Project;
import net.sf.memoranda.ProjectListener;
import net.sf.memoranda.ProjectManager;
import net.sf.memoranda.ResourcesList;
import net.sf.memoranda.TaskList;
import net.sf.memoranda.ui.AppFrame;
import net.sf.memoranda.util.Context;
import net.sf.memoranda.util.CurrentStorage;
import net.sf.memoranda.util.Storage;

public class CurrentProject {
    private static Project _project = null;
    private static TaskList _tasklist = null;
    private static NoteList _notelist = null;
    private static ResourcesList _resources = null;
    private static Vector projectListeners = new Vector();

    public static Project get() {
        return _project;
    }

    public static TaskList getTaskList() {
        return _tasklist;
    }

    public static NoteList getNoteList() {
        return _notelist;
    }

    public static ResourcesList getResourcesList() {
        return _resources;
    }

    public static void set(Project project) {
        if (project.getID().equals(_project.getID())) {
            return;
        }
        TaskList taskList = CurrentStorage.get().openTaskList(project);
        NoteList noteList = CurrentStorage.get().openNoteList(project);
        ResourcesList resourcesList = CurrentStorage.get().openResourcesList(project);
        CurrentProject.notifyListenersBefore(project, noteList, taskList, resourcesList);
        _project = project;
        _tasklist = taskList;
        _notelist = noteList;
        _resources = resourcesList;
        CurrentProject.notifyListenersAfter();
        Context.put("LAST_OPENED_PROJECT_ID", project.getID());
    }

    public static void addProjectListener(ProjectListener projectListener) {
        projectListeners.add(projectListener);
    }

    public static Collection getChangeListeners() {
        return projectListeners;
    }

    private static void notifyListenersBefore(Project project, NoteList noteList, TaskList taskList, ResourcesList resourcesList) {
        for (int i = 0; i < projectListeners.size(); ++i) {
            ((ProjectListener)projectListeners.get(i)).projectChange(project, noteList, taskList, resourcesList);
        }
    }

    private static void notifyListenersAfter() {
        for (int i = 0; i < projectListeners.size(); ++i) {
            ((ProjectListener)projectListeners.get(i)).projectWasChanged();
        }
    }

    public static void save() {
        Storage storage = CurrentStorage.get();
        storage.storeNoteList(_notelist, _project);
        storage.storeTaskList(_tasklist, _project);
        storage.storeResourcesList(_resources, _project);
        storage.storeProjectManager();
    }

    public static void free() {
        _project = null;
        _tasklist = null;
        _notelist = null;
        _resources = null;
    }

    static {
        String string = (String)Context.get("LAST_OPENED_PROJECT_ID");
        if (string == null) {
            string = "__default";
            Context.put("LAST_OPENED_PROJECT_ID", string);
        }
        if ((_project = ProjectManager.getProject(string)) == null) {
            _project = ProjectManager.getProject("__default");
            if (_project == null) {
                _project = (Project)ProjectManager.getActiveProjects().get(0);
            }
            Context.put("LAST_OPENED_PROJECT_ID", _project.getID());
        }
        _tasklist = CurrentStorage.get().openTaskList(_project);
        _notelist = CurrentStorage.get().openNoteList(_project);
        _resources = CurrentStorage.get().openResourcesList(_project);
        AppFrame.addExitListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CurrentProject.save();
            }
        });
    }
}

