/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda;

import java.util.Date;
import java.util.GregorianCalendar;
import net.sf.memoranda.Event;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.util.Local;
import nu.xom.Attribute;
import nu.xom.Element;

public class EventImpl
implements Event,
Comparable {
    private Element _elem = null;

    public EventImpl(Element element) {
        this._elem = element;
    }

    public int getHour() {
        return new Integer(this._elem.getAttribute("hour").getValue());
    }

    public int getMinute() {
        return new Integer(this._elem.getAttribute("min").getValue());
    }

    public String getTimeString() {
        return Local.getTimeString(this.getHour(), this.getMinute());
    }

    public String getText() {
        return this._elem.getValue();
    }

    public Element getContent() {
        return this._elem;
    }

    public boolean isRepeatable() {
        return this.getStartDate() != null;
    }

    public CalendarDate getStartDate() {
        Attribute attribute = this._elem.getAttribute("startDate");
        if (attribute != null) {
            return new CalendarDate(attribute.getValue());
        }
        return null;
    }

    public CalendarDate getEndDate() {
        Attribute attribute = this._elem.getAttribute("endDate");
        if (attribute != null) {
            return new CalendarDate(attribute.getValue());
        }
        return null;
    }

    public int getPeriod() {
        Attribute attribute = this._elem.getAttribute("period");
        if (attribute != null) {
            return new Integer(attribute.getValue());
        }
        return 0;
    }

    public String getId() {
        Attribute attribute = this._elem.getAttribute("id");
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    public int getRepeat() {
        Attribute attribute = this._elem.getAttribute("repeat-type");
        if (attribute != null) {
            return new Integer(attribute.getValue());
        }
        return 0;
    }

    public Date getTime() {
        Date date = new Date();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Local.getCurrentLocale());
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(11, this.getHour());
        gregorianCalendar.set(12, this.getMinute());
        gregorianCalendar.set(13, 0);
        date = gregorianCalendar.getTime();
        return date;
    }

    public boolean getWorkingDays() {
        Attribute attribute = this._elem.getAttribute("workingDays");
        return attribute != null && attribute.getValue().equals("true");
    }

    public int compareTo(Object object) {
        Event event = (Event)object;
        return this.getHour() * 60 + this.getMinute() - (event.getHour() * 60 + event.getMinute());
    }
}

