/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.memoranda.Event;
import net.sf.memoranda.EventImpl;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.util.CurrentStorage;
import net.sf.memoranda.util.Util;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.ParentNode;

public class EventsManager {
    public static final int NO_REPEAT = 0;
    public static final int REPEAT_DAILY = 1;
    public static final int REPEAT_WEEKLY = 2;
    public static final int REPEAT_MONTHLY = 3;
    public static final int REPEAT_YEARLY = 4;
    public static Document _doc = null;
    static Element _root = null;

    public static void createSticker(String string) {
        Element element = new Element("sticker");
        element.addAttribute(new Attribute("id", Util.generateId()));
        element.appendChild(string);
        _root.appendChild((Node)element);
    }

    public static Map getStickers() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Elements elements = _root.getChildElements("sticker");
        for (int i = 0; i < elements.size(); ++i) {
            Element element = elements.get(i);
            hashMap.put(element.getAttribute("id").getValue(), element.getValue());
        }
        return hashMap;
    }

    public static void removeSticker(String string) {
        Elements elements = _root.getChildElements("sticker");
        for (int i = 0; i < elements.size(); ++i) {
            Element element = elements.get(i);
            if (!element.getAttribute("id").getValue().equals(string)) continue;
            _root.removeChild((Node)element);
            break;
        }
    }

    public static boolean isNREventsForDate(CalendarDate calendarDate) {
        Day day = EventsManager.getDay(calendarDate);
        if (day == null) {
            return false;
        }
        return day.getElement().getChildElements("event").size() > 0;
    }

    public static Collection getEventsForDate(CalendarDate calendarDate) {
        Collection collection;
        Vector<EventImpl> vector = new Vector<EventImpl>();
        Day day = EventsManager.getDay(calendarDate);
        if (day != null) {
            collection = day.getElement().getChildElements("event");
            for (int i = 0; i < collection.size(); ++i) {
                vector.add(new EventImpl(collection.get(i)));
            }
        }
        if ((collection = EventsManager.getRepeatableEventsForDate(calendarDate)).size() > 0) {
            vector.addAll(collection);
        }
        Collections.sort(vector);
        return vector;
    }

    public static Event createEvent(CalendarDate calendarDate, int n, int n2, String string) {
        Element element = new Element("event");
        element.addAttribute(new Attribute("id", Util.generateId()));
        element.addAttribute(new Attribute("hour", String.valueOf(n)));
        element.addAttribute(new Attribute("min", String.valueOf(n2)));
        element.appendChild(string);
        Day day = EventsManager.getDay(calendarDate);
        if (day == null) {
            day = EventsManager.createDay(calendarDate);
        }
        day.getElement().appendChild((Node)element);
        return new EventImpl(element);
    }

    public static Event createRepeatableEvent(int n, CalendarDate calendarDate, CalendarDate calendarDate2, int n2, int n3, int n4, String string, boolean bl) {
        Element element = new Element("event");
        Element element2 = _root.getFirstChildElement("repeatable");
        if (element2 == null) {
            element2 = new Element("repeatable");
            _root.appendChild((Node)element2);
        }
        element.addAttribute(new Attribute("repeat-type", String.valueOf(n)));
        element.addAttribute(new Attribute("id", Util.generateId()));
        element.addAttribute(new Attribute("hour", String.valueOf(n3)));
        element.addAttribute(new Attribute("min", String.valueOf(n4)));
        element.addAttribute(new Attribute("startDate", calendarDate.toString()));
        if (calendarDate2 != null) {
            element.addAttribute(new Attribute("endDate", calendarDate2.toString()));
        }
        element.addAttribute(new Attribute("period", String.valueOf(n2)));
        element.addAttribute(new Attribute("workingDays", String.valueOf(bl)));
        element.appendChild(string);
        element2.appendChild((Node)element);
        return new EventImpl(element);
    }

    public static Collection getRepeatableEvents() {
        Vector<EventImpl> vector = new Vector<EventImpl>();
        Element element = _root.getFirstChildElement("repeatable");
        if (element == null) {
            return vector;
        }
        Elements elements = element.getChildElements("event");
        for (int i = 0; i < elements.size(); ++i) {
            vector.add(new EventImpl(elements.get(i)));
        }
        return vector;
    }

    public static Collection getRepeatableEventsForDate(CalendarDate calendarDate) {
        Vector vector = (Vector)EventsManager.getRepeatableEvents();
        Vector<Event> vector2 = new Vector<Event>();
        for (int i = 0; i < vector.size(); ++i) {
            int n;
            Event event = (Event)vector.get(i);
            if (event.getWorkingDays() && (calendarDate.getCalendar().get(7) == 1 || calendarDate.getCalendar().get(7) == 7) || !calendarDate.inPeriod(event.getStartDate(), event.getEndDate())) continue;
            if (event.getRepeat() == 1) {
                int n2;
                n = calendarDate.getCalendar().get(6);
                if ((n - (n2 = event.getStartDate().getCalendar().get(6))) % event.getPeriod() != 0) continue;
                vector2.add(event);
                continue;
            }
            if (event.getRepeat() == 2) {
                if (calendarDate.getCalendar().get(7) != event.getPeriod()) continue;
                vector2.add(event);
                continue;
            }
            if (event.getRepeat() == 3) {
                if (calendarDate.getCalendar().get(5) != event.getPeriod()) continue;
                vector2.add(event);
                continue;
            }
            if (event.getRepeat() != 4) continue;
            n = event.getPeriod();
            if (calendarDate.getYear() % 4 == 0 && calendarDate.getCalendar().get(6) > 60) {
                ++n;
            }
            if (calendarDate.getCalendar().get(6) != n) continue;
            vector2.add(event);
        }
        return vector2;
    }

    public static Collection getActiveEvents() {
        return EventsManager.getEventsForDate(CalendarDate.today());
    }

    public static Event getEvent(CalendarDate calendarDate, int n, int n2) {
        Day day = EventsManager.getDay(calendarDate);
        if (day == null) {
            return null;
        }
        Elements elements = day.getElement().getChildElements("event");
        for (int i = 0; i < elements.size(); ++i) {
            Element element = elements.get(i);
            if (new Integer(element.getAttribute("hour").getValue()) != n || new Integer(element.getAttribute("min").getValue()) != n2) continue;
            return new EventImpl(element);
        }
        return null;
    }

    public static void removeEvent(CalendarDate calendarDate, int n, int n2) {
        Day day = EventsManager.getDay(calendarDate);
        if (day == null) {
            day.getElement().removeChild((Node)EventsManager.getEvent(calendarDate, n, n2).getContent());
        }
    }

    public static void removeEvent(Event event) {
        ParentNode parentNode = event.getContent().getParent();
        parentNode.removeChild((Node)event.getContent());
    }

    private static Day createDay(CalendarDate calendarDate) {
        Day day;
        Month month;
        Year year = EventsManager.getYear(calendarDate.getYear());
        if (year == null) {
            year = EventsManager.createYear(calendarDate.getYear());
        }
        if ((month = year.getMonth(calendarDate.getMonth())) == null) {
            month = year.createMonth(calendarDate.getMonth());
        }
        if ((day = month.getDay(calendarDate.getDay())) == null) {
            day = month.createDay(calendarDate.getDay());
        }
        return day;
    }

    private static Year createYear(int n) {
        Element element = new Element("year");
        element.addAttribute(new Attribute("year", new Integer(n).toString()));
        _root.appendChild((Node)element);
        return new Year(element);
    }

    private static Year getYear(int n) {
        Elements elements = _root.getChildElements("year");
        String string = new Integer(n).toString();
        for (int i = 0; i < elements.size(); ++i) {
            if (!elements.get(i).getAttribute("year").getValue().equals(string)) continue;
            return new Year(elements.get(i));
        }
        return null;
    }

    private static Day getDay(CalendarDate calendarDate) {
        Year year = EventsManager.getYear(calendarDate.getYear());
        if (year == null) {
            return null;
        }
        Month month = year.getMonth(calendarDate.getMonth());
        if (month == null) {
            return null;
        }
        return month.getDay(calendarDate.getDay());
    }

    static {
        CurrentStorage.get().openEventsManager();
        if (_doc == null) {
            _root = new Element("eventslist");
            _doc = new Document(_root);
        } else {
            _root = _doc.getRootElement();
        }
    }

    static class Day {
        Element dEl = null;

        public Day(Element element) {
            this.dEl = element;
        }

        public int getValue() {
            return new Integer(this.dEl.getAttribute("day").getValue());
        }

        public Element getElement() {
            return this.dEl;
        }
    }

    static class Month {
        Element mElement = null;

        public Month(Element element) {
            this.mElement = element;
        }

        public int getValue() {
            return new Integer(this.mElement.getAttribute("month").getValue());
        }

        public Day getDay(int n) {
            if (this.mElement == null) {
                return null;
            }
            Elements elements = this.mElement.getChildElements("day");
            String string = new Integer(n).toString();
            for (int i = 0; i < elements.size(); ++i) {
                if (!elements.get(i).getAttribute("day").getValue().equals(string)) continue;
                return new Day(elements.get(i));
            }
            return null;
        }

        private Day createDay(int n) {
            Element element = new Element("day");
            element.addAttribute(new Attribute("day", new Integer(n).toString()));
            element.addAttribute(new Attribute("date", new CalendarDate(n, this.getValue(), new Integer(((Element)this.mElement.getParent()).getAttribute("year").getValue())).toString()));
            this.mElement.appendChild((Node)element);
            return new Day(element);
        }

        public Vector getDays() {
            if (this.mElement == null) {
                return null;
            }
            Vector<Day> vector = new Vector<Day>();
            Elements elements = this.mElement.getChildElements("day");
            for (int i = 0; i < elements.size(); ++i) {
                vector.add(new Day(elements.get(i)));
            }
            return vector;
        }

        public Element getElement() {
            return this.mElement;
        }
    }

    static class Year {
        Element yearElement = null;

        public Year(Element element) {
            this.yearElement = element;
        }

        public int getValue() {
            return new Integer(this.yearElement.getAttribute("year").getValue());
        }

        public Month getMonth(int n) {
            Elements elements = this.yearElement.getChildElements("month");
            String string = new Integer(n).toString();
            for (int i = 0; i < elements.size(); ++i) {
                if (!elements.get(i).getAttribute("month").getValue().equals(string)) continue;
                return new Month(elements.get(i));
            }
            return null;
        }

        private Month createMonth(int n) {
            Element element = new Element("month");
            element.addAttribute(new Attribute("month", new Integer(n).toString()));
            this.yearElement.appendChild((Node)element);
            return new Month(element);
        }

        public Vector getMonths() {
            Vector<Month> vector = new Vector<Month>();
            Elements elements = this.yearElement.getChildElements("month");
            for (int i = 0; i < elements.size(); ++i) {
                vector.add(new Month(elements.get(i)));
            }
            return vector;
        }

        public Element getElement() {
            return this.yearElement;
        }
    }
}

