/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.Calendar;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.UIManager;
import net.sf.memoranda.Event;
import net.sf.memoranda.EventNotificationListener;
import net.sf.memoranda.EventsScheduler;
import net.sf.memoranda.ui.AppFrame;
import net.sf.memoranda.ui.ExceptionDialog;
import net.sf.memoranda.util.Configuration;
import net.sf.memoranda.util.Local;
import snoozesoft.systray4j.SysTrayMenu;
import snoozesoft.systray4j.SysTrayMenuEvent;
import snoozesoft.systray4j.SysTrayMenuIcon;
import snoozesoft.systray4j.SysTrayMenuItem;
import snoozesoft.systray4j.SysTrayMenuListener;

public class App
implements SysTrayMenuListener {
    static AppFrame frame = null;
    static SysTrayMenu menu = null;
    static SysTrayMenuIcon icon = null;
    static SysTrayMenuIcon iconEv = null;
    static SysTrayMenuItem itemExit = null;
    static SysTrayMenuItem itemMinimize = null;
    static SysTrayMenuItem itemRestore = null;
    public static boolean sysTrayDisabled = true;
    public static final String GUIDE_URL = "http://memoranda.sourceforge.net/guide.html";
    public static final String BUGS_TRACKER_URL = "http://sourceforge.net/tracker/?group_id=90997&atid=595566";
    public static final String WEBSITE_URL = "http://memoranda.sourceforge.net";
    private JFrame splash = null;
    public static final String VERSION_INFO = "1.0-rc3.1";
    public static final String BUILD_INFO = "20070407.57";

    public static AppFrame getFrame() {
        return frame;
    }

    public void show() {
        if (frame.isVisible()) {
            frame.toFront();
            frame.requestFocus();
        } else {
            this.init();
        }
    }

    public App(boolean bl) {
        if (bl) {
            boolean bl2 = bl = !Configuration.get("START_MINIMIZED").equals("yes");
        }
        if (!bl) {
            System.out.println("Minimized mode");
        }
        if (!Configuration.get("SHOW_SPLASH").equals("no")) {
            this.showSplash();
        }
        System.out.println(VERSION_INFO);
        try {
            if (Configuration.get("LOOK_AND_FEEL").equals("system")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else if (Configuration.get("LOOK_AND_FEEL").equals("kunststoff")) {
                UIManager.setLookAndFeel("com.incors.plaf.kunststoff.KunststoffLookAndFeel");
            } else if (Configuration.get("LOOK_AND_FEEL").equals("default")) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            } else if (Configuration.get("LOOK_AND_FEEL").toString().length() > 0) {
                UIManager.setLookAndFeel(Configuration.get("LOOK_AND_FEEL").toString());
            }
        }
        catch (Exception exception) {
            new ExceptionDialog(exception, "Error when initializing a pluggable look-and-feel. Default LF will be used.", "Make sure that specified look-and-feel library classes are on the CLASSPATH.");
        }
        if (Configuration.get("FIRST_DAY_OF_WEEK").equals("")) {
            String string = Calendar.getInstance().getFirstDayOfWeek() == 2 ? "mon" : "sun";
            Configuration.put("FIRST_DAY_OF_WEEK", string);
            Configuration.saveConfig();
            System.out.println("[DEBUG] first day of week is set to " + string);
        }
        if (!sysTrayDisabled) {
            icon.addSysTrayMenuListener((SysTrayMenuListener)this);
            iconEv.addSysTrayMenuListener((SysTrayMenuListener)this);
            itemExit.addSysTrayMenuListener((SysTrayMenuListener)this);
            itemMinimize.addSysTrayMenuListener((SysTrayMenuListener)this);
            itemRestore.addSysTrayMenuListener((SysTrayMenuListener)this);
            menu.addItem(itemExit, 0);
            menu.addSeparator(1);
            menu.addItem(itemRestore, 2);
            EventsScheduler.addListener(new EventNotificationListener(){

                public void eventIsOccured(Event event) {
                }

                public void eventsChanged() {
                    if (EventsScheduler.isEventScheduled()) {
                        Event event = EventsScheduler.getFirstScheduledEvent();
                        menu.setToolTip(event.getTimeString() + " - " + event.getText());
                        menu.setIcon(iconEv);
                    } else {
                        menu.setToolTip("Memoranda");
                        menu.setIcon(icon);
                    }
                }
            });
        }
        EventsScheduler.init();
        frame = new AppFrame();
        if (bl) {
            this.init();
        }
        if (!Configuration.get("SHOW_SPLASH").equals("no")) {
            this.splash.dispose();
        }
    }

    void init() {
        if (!sysTrayDisabled) {
            menu.removeAll();
            menu.addItem(itemExit, 0);
            menu.addSeparator(1);
            menu.addItem(itemMinimize, 2);
        }
        double d = Double.valueOf(System.getProperty("java.version").substring(0, 3));
        frame.pack();
        if (d >= 1.4) {
            frame.setExtendedState(6);
        } else {
            frame.setExtendedState(0);
        }
        frame.setVisible(true);
        frame.toFront();
        frame.requestFocus();
    }

    public static void closeWindow() {
        if (frame == null) {
            return;
        }
        frame.dispose();
        if (!sysTrayDisabled) {
            menu.removeAll();
            menu.addItem(itemExit, 0);
            menu.addSeparator(1);
            menu.addItem(itemRestore, 2);
        } else {
            System.out.println("Memoranda is active in a 'daemon mode'. To restore the window, run the application again.");
        }
        System.gc();
    }

    public void menuItemSelected(SysTrayMenuEvent sysTrayMenuEvent) {
        if (sysTrayMenuEvent.getActionCommand().equals("restore")) {
            this.show();
        } else if (sysTrayMenuEvent.getActionCommand().equals("minimize")) {
            App.closeWindow();
        } else if (sysTrayMenuEvent.getActionCommand().equals("exit")) {
            if (frame != null) {
                frame.doExit();
            } else {
                System.exit(0);
            }
        }
    }

    public void iconLeftClicked(SysTrayMenuEvent sysTrayMenuEvent) {
        this.show();
    }

    public void iconLeftDoubleClicked(SysTrayMenuEvent sysTrayMenuEvent) {
        this.show();
    }

    private void showSplash() {
        this.splash = new JFrame();
        ImageIcon imageIcon = new ImageIcon(App.class.getResource("resources/splash.png"));
        JLabel jLabel = new JLabel();
        jLabel.setSize(400, 300);
        jLabel.setIcon(imageIcon);
        this.splash.getContentPane().add(jLabel);
        this.splash.setSize(400, 300);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.splash.setLocation((dimension.width - 400) / 2, (dimension.height - 300) / 2);
        this.splash.setUndecorated(true);
        this.splash.setVisible(true);
    }

    static {
        if (!Configuration.get("DISABLE_SYSTRAY").equals("yes")) {
            icon = new SysTrayMenuIcon(AppFrame.class.getResource("resources/icons/jnotes" + SysTrayMenuIcon.getExtension()));
            iconEv = new SysTrayMenuIcon(AppFrame.class.getResource("resources/icons/jnotes_ev" + SysTrayMenuIcon.getExtension()));
            itemExit = new SysTrayMenuItem(Local.getString("Exit"), "exit");
            itemMinimize = new SysTrayMenuItem(Local.getString("Minimize"), "minimize");
            itemRestore = new SysTrayMenuItem(Local.getString("Restore"), "restore");
            menu = new SysTrayMenu(icon, "Memoranda");
            sysTrayDisabled = false;
            if (!SysTrayMenu.isAvailable()) {
                System.out.println("[DEBUG] SysTray is now disabled.");
                Configuration.put("DISABLE_SYSTRAY", "yes");
                Configuration.put("ASK_ON_EXIT", "yes");
                Configuration.put("ON_CLOSE", "exit");
                Configuration.saveConfig();
                sysTrayDisabled = true;
            }
        } else {
            System.out.println("System tray icon is disabled");
        }
    }
}

