/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import net.sf.memoranda.CurrentProject;
import net.sf.memoranda.EventsManager;
import net.sf.memoranda.Task;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.ui.App;
import net.sf.memoranda.ui.AppFrame;

public class JNCalendarCellRenderer
extends DefaultTableCellRenderer {
    private CalendarDate d = null;
    boolean disabled = false;
    ImageIcon evIcon = new ImageIcon(AppFrame.class.getResource("resources/icons/en.png"));
    Task t = null;

    public void setTask(Task task) {
        this.t = task;
    }

    public Task getTask() {
        return this.t;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        String string = App.getFrame().workPanel.dailyItemsPanel.getCurrentPanel();
        if (this.d == null) {
            jLabel.setEnabled(false);
            jLabel.setIcon(null);
            jLabel.setBackground(new Color(224, 224, 224));
            return jLabel;
        }
        if (!bl) {
            CalendarDate calendarDate = CurrentProject.get().getStartDate();
            CalendarDate calendarDate2 = CurrentProject.get().getEndDate();
            if (!(this.d.after(calendarDate) && this.d.before(calendarDate2) || this.d.equals(calendarDate) || this.d.equals(calendarDate2))) {
                jLabel.setBackground(new Color(240, 240, 240));
                return jLabel;
            }
        }
        jLabel.setHorizontalTextPosition(2);
        jLabel.setEnabled(true);
        if (this.d.equals(CalendarDate.today())) {
            jLabel.setBorder(BorderFactory.createLineBorder(new Color(100, 100, 128)));
        }
        if (this.d.getCalendar().get(7) == 1) {
            jLabel.setForeground(new Color(255, 0, 0));
        } else {
            jLabel.setForeground(Color.BLACK);
        }
        if (string == null) {
            jLabel.setBackground(Color.WHITE);
        } else if (string.equals("TASKS") && this.t != null && this.d.inPeriod(this.t.getStartDate(), this.t.getEndDate())) {
            jLabel.setBackground(new Color(230, 255, 230));
        } else if (string.equals("NOTES") && CurrentProject.getNoteList().getNoteForDate(this.d) != null) {
            jLabel.setBackground(new Color(255, 245, 200));
        } else if (string.equals("EVENTS") && !EventsManager.getEventsForDate(this.d).isEmpty()) {
            jLabel.setBackground(new Color(255, 230, 230));
        } else if (!bl) {
            jLabel.setBackground(Color.WHITE);
        }
        if (EventsManager.isNREventsForDate(this.d)) {
            jLabel.setIcon(this.evIcon);
        } else {
            jLabel.setIcon(null);
        }
        return jLabel;
    }

    public void setDate(CalendarDate calendarDate) {
        this.d = calendarDate;
    }
}

