/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.sf.memoranda.CurrentProject;
import net.sf.memoranda.Project;
import net.sf.memoranda.ProjectManager;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.ui.ExceptionDialog;
import net.sf.memoranda.util.Local;

public class ProjectsTablePanel
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane scrollPane = new JScrollPane();
    public JTable projectsTable = new JTable(){

        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (((String)this.getModel().getValueAt(n, 100)).equals(CurrentProject.get().getID())) {
                return new DefaultTableCellRenderer(){

                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                        component.setFont(new Font("Dialog", 1, 11));
                        if (n % 2 > 0 && !bl) {
                            component.setBackground(new Color(230, 240, 255));
                        }
                        return component;
                    }
                };
            }
            if (n % 2 > 0) {
                return new DefaultTableCellRenderer(){

                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                        if (bl) {
                            return component;
                        }
                        component.setBackground(new Color(230, 240, 255));
                        return component;
                    }
                };
            }
            return super.getCellRenderer(n, n2);
        }
    };
    boolean activeOnly = false;
    static final int PROJECT = 101;
    static final int PROJECT_ID = 100;

    public void updateUI() {
        if (this.projectsTable != null) {
            this.projectsTable.updateUI();
        }
        super.updateUI();
    }

    public ProjectsTablePanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            new ExceptionDialog(exception);
        }
    }

    void jbInit() throws Exception {
        this.projectsTable.getTableHeader().setFont(new Font("Dialog", 1, 10));
        this.projectsTable.setFont(new Font("Dialog", 0, 11));
        this.projectsTable.setMinimumSize(new Dimension(200, 100));
        this.projectsTable.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.projectsTable.setGridColor(new Color(230, 230, 230));
        this.projectsTable.setShowHorizontalLines(false);
        this.scrollPane.getViewport().setBackground(Color.white);
        this.scrollPane.getViewport().add((Component)this.projectsTable, null);
        this.setLayout(this.borderLayout1);
        this.add((Component)this.scrollPane, "Center");
        this.initProjectsTable();
    }

    void initProjectsTable() {
        this.projectsTable.setModel(new PrjTableModel());
        for (int i = 0; i < 4; ++i) {
            TableColumn tableColumn = this.projectsTable.getColumnModel().getColumn(i);
            if (i == 0) {
                tableColumn.setPreferredWidth(Short.MAX_VALUE);
                continue;
            }
            tableColumn.setMinWidth(80);
            tableColumn.setPreferredWidth(80);
        }
    }

    public void setShowActiveOnly(boolean bl) {
        this.activeOnly = bl;
        this.projectsTable.updateUI();
    }

    public String getSelectedProjectID() {
        return (String)this.projectsTable.getModel().getValueAt(this.projectsTable.getSelectedRow(), 100);
    }

    public Project getSelectedProject() {
        return (Project)this.projectsTable.getModel().getValueAt(this.projectsTable.getSelectedRow(), 101);
    }

    String getStatusString(int n) {
        switch (n) {
            case 1: {
                return Local.getString("Active");
            }
            case 2: {
                return Local.getString("Completed");
            }
            case 5: {
                return Local.getString("Failed");
            }
            case 4: {
                return Local.getString("Frozen");
            }
            case 0: {
                return Local.getString("Scheduled");
            }
        }
        return "";
    }

    class PrjTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{Local.getString("Project title"), Local.getString("Start date"), Local.getString("End date"), Local.getString("Status")};

        PrjTableModel() {
        }

        public int getColumnCount() {
            return 4;
        }

        public Object getValueAt(int n, int n2) {
            if (n == -1) {
                return "";
            }
            Project project = ProjectsTablePanel.this.activeOnly ? (Project)ProjectManager.getActiveProjects().get(n) : (Project)ProjectManager.getAllProjects().get(n);
            switch (n2) {
                case 0: {
                    return project.getTitle();
                }
                case 1: {
                    return project.getStartDate().getShortDateString();
                }
                case 2: {
                    CalendarDate calendarDate = project.getEndDate();
                    if (calendarDate == null) {
                        return "-";
                    }
                    return calendarDate.getShortDateString();
                }
                case 3: {
                    return ProjectsTablePanel.this.getStatusString(project.getStatus());
                }
                case 100: {
                    return project.getID();
                }
                case 101: {
                    return project;
                }
            }
            return "";
        }

        public int getRowCount() {
            if (ProjectsTablePanel.this.activeOnly) {
                return ProjectManager.getActiveProjectsNumber();
            }
            return ProjectManager.getAllProjectsNumber();
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }
    }
}

