/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.memoranda.ui.App;
import net.sf.memoranda.ui.AppFrame;
import net.sf.memoranda.ui.EditTypeDialog;
import net.sf.memoranda.util.AppList;
import net.sf.memoranda.util.CurrentStorage;
import net.sf.memoranda.util.Local;
import net.sf.memoranda.util.MimeType;
import net.sf.memoranda.util.MimeTypesList;
import net.sf.memoranda.util.Util;

public class ResourceTypePanel
extends JPanel {
    Border border1;
    TitledBorder titledBorder1;
    Border border2;
    TitledBorder titledBorder2;
    public String ext = "";
    boolean CANCELLED = true;
    JPanel jPanel1 = new JPanel();
    JButton newTypeB = new JButton();
    JScrollPane jScrollPane1 = new JScrollPane();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel areaPanel = new JPanel();
    JPanel jPanel2 = new JPanel();
    JButton editB = new JButton();
    JButton deleteB = new JButton();
    BorderLayout borderLayout1 = new BorderLayout();
    public JList typesList = new JList();
    BorderLayout borderLayout3 = new BorderLayout();
    Border border3;

    public ResourceTypePanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.border1 = BorderFactory.createLineBorder(SystemColor.controlText, 2);
        this.titledBorder1 = new TitledBorder(BorderFactory.createEmptyBorder(), Local.getString("Registered types"));
        this.border2 = BorderFactory.createLineBorder(Color.gray, 1);
        this.titledBorder2 = new TitledBorder(BorderFactory.createLineBorder(Color.gray, 1), Local.getString("Details"));
        this.border3 = BorderFactory.createEmptyBorder(0, 10, 0, 0);
        this.jPanel1.setBorder(this.titledBorder1);
        this.jPanel1.setLayout(this.borderLayout1);
        this.newTypeB.setMaximumSize(new Dimension(110, 25));
        this.newTypeB.setPreferredSize(new Dimension(110, 25));
        this.newTypeB.setText(Local.getString("New"));
        this.newTypeB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourceTypePanel.this.newTypeB_actionPerformed(actionEvent);
            }
        });
        this.areaPanel.setLayout(this.borderLayout2);
        this.jPanel2.setMaximumSize(new Dimension(120, Short.MAX_VALUE));
        this.jPanel2.setMinimumSize(new Dimension(120, 36));
        this.jPanel2.setPreferredSize(new Dimension(120, 36));
        this.jPanel2.setBorder(this.border3);
        this.editB.setText(Local.getString("Edit"));
        this.editB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourceTypePanel.this.editB_actionPerformed(actionEvent);
            }
        });
        this.editB.setEnabled(false);
        this.editB.setMaximumSize(new Dimension(110, 25));
        this.editB.setPreferredSize(new Dimension(110, 25));
        this.deleteB.setEnabled(false);
        this.deleteB.setMaximumSize(new Dimension(110, 25));
        this.deleteB.setPreferredSize(new Dimension(110, 25));
        this.deleteB.setText(Local.getString("Delete"));
        this.deleteB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourceTypePanel.this.deleteB_actionPerformed(actionEvent);
            }
        });
        this.typesList.setCellRenderer(new TypesListRenderer());
        this.typesList.setSelectionMode(0);
        this.typesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ResourceTypePanel.this.typesList_valueChanged(listSelectionEvent);
            }
        });
        this.initTypesList();
        this.setLayout(this.borderLayout3);
        this.add((Component)this.areaPanel, "Center");
        this.areaPanel.add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.typesList, null);
        this.jPanel1.add((Component)this.jPanel2, "East");
        this.jPanel2.add((Component)this.newTypeB, null);
        this.jPanel2.add((Component)this.editB, null);
        this.jPanel2.add((Component)this.deleteB, null);
        this.typesList.setListData(MimeTypesList.getAllMimeTypes());
    }

    public void initTypesList() {
        this.typesList.setListData(MimeTypesList.getAllMimeTypes());
        this.typesList.updateUI();
    }

    void newTypeB_actionPerformed(ActionEvent actionEvent) {
        EditTypeDialog editTypeDialog = new EditTypeDialog((Frame)App.getFrame(), Local.getString("New resource type"));
        Dimension dimension = new Dimension(420, 420);
        editTypeDialog.setSize(dimension);
        Dimension dimension2 = App.getFrame().getSize();
        Point point = App.getFrame().getLocation();
        editTypeDialog.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        editTypeDialog.extField.setText(this.ext);
        editTypeDialog.descField.setText(this.ext);
        editTypeDialog.appPanel.argumentsField.setText("$1");
        editTypeDialog.iconLabel.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/mimetypes/default.png")));
        editTypeDialog.setVisible(true);
        if (editTypeDialog.CANCELLED) {
            return;
        }
        String string = Util.generateId();
        MimeType mimeType = MimeTypesList.addMimeType(string);
        String[] stringArray = editTypeDialog.extField.getText().trim().split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            mimeType.addExtension(stringArray[i]);
        }
        mimeType.setLabel(editTypeDialog.descField.getText());
        AppList appList = MimeTypesList.getAppList();
        if (editTypeDialog.appPanel.applicationField.getText().length() > 0) {
            File file = new File(editTypeDialog.appPanel.applicationField.getText());
            String string2 = Util.generateId();
            appList.addApp(string2, file.getParent().replace('\\', '/'), file.getName().replace('\\', '/'), editTypeDialog.appPanel.argumentsField.getText());
            mimeType.setApp(string2);
        }
        if (editTypeDialog.iconPath.length() > 0) {
            mimeType.setIconPath(editTypeDialog.iconPath);
        }
        CurrentStorage.get().storeMimeTypesList();
        this.initTypesList();
        this.typesList.setSelectedValue(mimeType, true);
    }

    void deleteB_actionPerformed(ActionEvent actionEvent) {
        MimeType mimeType = (MimeType)this.typesList.getSelectedValue();
        int n = JOptionPane.showConfirmDialog(App.getFrame(), Local.getString("Delete resource type") + "\n'" + mimeType.getLabel() + "'\n" + Local.getString("Are you sure?"), Local.getString("Delete resource type"), 0);
        if (n != 0) {
            return;
        }
        MimeTypesList.removeMimeType(mimeType.getMimeTypeId());
        CurrentStorage.get().storeMimeTypesList();
        this.initTypesList();
    }

    void editB_actionPerformed(ActionEvent actionEvent) {
        EditTypeDialog editTypeDialog = new EditTypeDialog((Frame)App.getFrame(), Local.getString("Edit resource type"));
        Dimension dimension = new Dimension(420, 450);
        editTypeDialog.setSize(dimension);
        Dimension dimension2 = App.getFrame().getSize();
        Point point = App.getFrame().getLocation();
        editTypeDialog.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        MimeType mimeType = (MimeType)this.typesList.getSelectedValue();
        String[] stringArray = mimeType.getExtensions();
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i] + " ";
        }
        editTypeDialog.extField.setText(string);
        editTypeDialog.descField.setText(mimeType.getLabel());
        editTypeDialog.iconLabel.setIcon(mimeType.getIcon());
        AppList appList = MimeTypesList.getAppList();
        editTypeDialog.appPanel.applicationField.setText(appList.getFindPath(mimeType.getAppId()) + "/" + appList.getExec(mimeType.getAppId()));
        editTypeDialog.appPanel.argumentsField.setText(appList.getCommandLinePattern(mimeType.getAppId()));
        editTypeDialog.setVisible(true);
        if (editTypeDialog.CANCELLED) {
            return;
        }
        String string2 = mimeType.getMimeTypeId();
        MimeTypesList.removeMimeType(string2);
        mimeType = MimeTypesList.addMimeType(string2);
        stringArray = editTypeDialog.extField.getText().trim().split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            mimeType.addExtension(stringArray[i]);
        }
        mimeType.setLabel(editTypeDialog.descField.getText());
        if (editTypeDialog.appPanel.applicationField.getText().length() > 0) {
            File file = new File(editTypeDialog.appPanel.applicationField.getText());
            String string3 = Util.generateId();
            appList.addApp(string3, file.getParent().replace('\\', '/'), file.getName().replace('\\', '/'), editTypeDialog.appPanel.argumentsField.getText());
            mimeType.setApp(string3);
        }
        if (editTypeDialog.iconPath.length() > 0) {
            mimeType.setIconPath(editTypeDialog.iconPath);
        }
        CurrentStorage.get().storeMimeTypesList();
        this.initTypesList();
        this.typesList.setSelectedValue(mimeType, true);
    }

    void typesList_valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl = this.typesList.getSelectedValue() != null;
        this.editB.setEnabled(bl);
        this.deleteB.setEnabled(bl);
    }

    class TypesListRenderer
    extends JLabel
    implements ListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            MimeType mimeType = (MimeType)object;
            String[] stringArray = mimeType.getExtensions();
            String string = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + "*." + stringArray[i];
                if (i == stringArray.length - 1) continue;
                string = string + ", ";
            }
            this.setOpaque(true);
            this.setText(mimeType.getLabel() + " (" + string + ")");
            this.setIcon(mimeType.getIcon());
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }
}

