/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.memoranda.CurrentProject;
import net.sf.memoranda.History;
import net.sf.memoranda.NoteList;
import net.sf.memoranda.Project;
import net.sf.memoranda.ProjectListener;
import net.sf.memoranda.ResourcesList;
import net.sf.memoranda.Task;
import net.sf.memoranda.TaskList;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.date.CurrentDate;
import net.sf.memoranda.date.DateListener;
import net.sf.memoranda.ui.App;
import net.sf.memoranda.ui.AppFrame;
import net.sf.memoranda.ui.DailyItemsPanel;
import net.sf.memoranda.ui.TaskCalcDialog;
import net.sf.memoranda.ui.TaskDialog;
import net.sf.memoranda.ui.TaskTable;
import net.sf.memoranda.util.Context;
import net.sf.memoranda.util.CurrentStorage;
import net.sf.memoranda.util.Local;
import net.sf.memoranda.util.Util;

public class TaskPanel
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    JButton historyBackB = new JButton();
    JToolBar tasksToolBar = new JToolBar();
    JButton historyForwardB = new JButton();
    JButton newTaskB = new JButton();
    JButton subTaskB = new JButton();
    JButton editTaskB = new JButton();
    JButton removeTaskB = new JButton();
    JButton completeTaskB = new JButton();
    JCheckBoxMenuItem ppShowActiveOnlyChB = new JCheckBoxMenuItem();
    JScrollPane scrollPane = new JScrollPane();
    TaskTable taskTable = new TaskTable();
    JMenuItem ppEditTask = new JMenuItem();
    JPopupMenu taskPPMenu = new JPopupMenu();
    JMenuItem ppRemoveTask = new JMenuItem();
    JMenuItem ppNewTask = new JMenuItem();
    JMenuItem ppCompleteTask = new JMenuItem();
    JMenuItem ppAddSubTask = new JMenuItem();
    JMenuItem ppCalcTask = new JMenuItem();
    DailyItemsPanel parentPanel = null;

    public TaskPanel(DailyItemsPanel dailyItemsPanel) {
        try {
            this.parentPanel = dailyItemsPanel;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.tasksToolBar.setFloatable(false);
        this.historyBackB.setAction(History.historyBackAction);
        this.historyBackB.setFocusable(false);
        this.historyBackB.setBorderPainted(false);
        this.historyBackB.setToolTipText(Local.getString("History back"));
        this.historyBackB.setRequestFocusEnabled(false);
        this.historyBackB.setPreferredSize(new Dimension(24, 24));
        this.historyBackB.setMinimumSize(new Dimension(24, 24));
        this.historyBackB.setMaximumSize(new Dimension(24, 24));
        this.historyBackB.setText("");
        this.historyForwardB.setAction(History.historyForwardAction);
        this.historyForwardB.setBorderPainted(false);
        this.historyForwardB.setFocusable(false);
        this.historyForwardB.setPreferredSize(new Dimension(24, 24));
        this.historyForwardB.setRequestFocusEnabled(false);
        this.historyForwardB.setToolTipText(Local.getString("History forward"));
        this.historyForwardB.setMinimumSize(new Dimension(24, 24));
        this.historyForwardB.setMaximumSize(new Dimension(24, 24));
        this.historyForwardB.setText("");
        this.newTaskB.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/todo_new.png")));
        this.newTaskB.setEnabled(true);
        this.newTaskB.setMaximumSize(new Dimension(24, 24));
        this.newTaskB.setMinimumSize(new Dimension(24, 24));
        this.newTaskB.setToolTipText(Local.getString("Create new task"));
        this.newTaskB.setRequestFocusEnabled(false);
        this.newTaskB.setPreferredSize(new Dimension(24, 24));
        this.newTaskB.setFocusable(false);
        this.newTaskB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TaskPanel.this.newTaskB_actionPerformed(actionEvent);
            }
        });
        this.newTaskB.setBorderPainted(false);
        this.subTaskB.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/todo_new_sub.png")));
        this.subTaskB.setEnabled(true);
        this.subTaskB.setMaximumSize(new Dimension(24, 24));
        this.subTaskB.setMinimumSize(new Dimension(24, 24));
        this.subTaskB.setToolTipText(Local.getString("Add subtask"));
        this.subTaskB.setRequestFocusEnabled(false);
        this.subTaskB.setPreferredSize(new Dimension(24, 24));
        this.subTaskB.setFocusable(false);
        this.subTaskB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TaskPanel.this.addSubTask_actionPerformed(actionEvent);
            }
        });
        this.subTaskB.setBorderPainted(false);
        this.editTaskB.setBorderPainted(false);
        this.editTaskB.setFocusable(false);
        this.editTaskB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TaskPanel.this.editTaskB_actionPerformed(actionEvent);
            }
        });
        this.editTaskB.setPreferredSize(new Dimension(24, 24));
        this.editTaskB.setRequestFocusEnabled(false);
        this.editTaskB.setToolTipText(Local.getString("Edit task"));
        this.editTaskB.setMinimumSize(new Dimension(24, 24));
        this.editTaskB.setMaximumSize(new Dimension(24, 24));
        this.editTaskB.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/todo_edit.png")));
        this.removeTaskB.setBorderPainted(false);
        this.removeTaskB.setFocusable(false);
        this.removeTaskB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TaskPanel.this.removeTaskB_actionPerformed(actionEvent);
            }
        });
        this.removeTaskB.setPreferredSize(new Dimension(24, 24));
        this.removeTaskB.setRequestFocusEnabled(false);
        this.removeTaskB.setToolTipText(Local.getString("Remove task"));
        this.removeTaskB.setMinimumSize(new Dimension(24, 24));
        this.removeTaskB.setMaximumSize(new Dimension(24, 24));
        this.removeTaskB.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/todo_remove.png")));
        this.completeTaskB.setBorderPainted(false);
        this.completeTaskB.setFocusable(false);
        this.completeTaskB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TaskPanel.this.ppCompleteTask_actionPerformed(actionEvent);
            }
        });
        this.completeTaskB.setPreferredSize(new Dimension(24, 24));
        this.completeTaskB.setRequestFocusEnabled(false);
        this.completeTaskB.setToolTipText(Local.getString("Complete task"));
        this.completeTaskB.setMinimumSize(new Dimension(24, 24));
        this.completeTaskB.setMaximumSize(new Dimension(24, 24));
        this.completeTaskB.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/todo_complete.png")));
        this.ppShowActiveOnlyChB.setFont(new Font("Dialog", 1, 11));
        this.ppShowActiveOnlyChB.setText(Local.getString("Show Active only"));
        this.ppShowActiveOnlyChB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TaskPanel.this.toggleShowActiveOnly_actionPerformed(actionEvent);
            }
        });
        boolean bl = Context.get("SHOW_ACTIVE_TASKS_ONLY") != null && Context.get("SHOW_ACTIVE_TASKS_ONLY").equals("true");
        this.ppShowActiveOnlyChB.setSelected(bl);
        this.toggleShowActiveOnly_actionPerformed(null);
        this.setLayout(this.borderLayout1);
        this.scrollPane.getViewport().setBackground(Color.white);
        this.ppEditTask.setFont(new Font("Dialog", 1, 11));
        this.ppEditTask.setText(Local.getString("Edit task") + "...");
        this.ppEditTask.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TaskPanel.this.ppEditTask_actionPerformed(actionEvent);
            }
        });
        this.ppEditTask.setEnabled(false);
        this.ppEditTask.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/todo_edit.png")));
        this.taskPPMenu.setFont(new Font("Dialog", 1, 10));
        this.ppRemoveTask.setFont(new Font("Dialog", 1, 11));
        this.ppRemoveTask.setText(Local.getString("Remove task"));
        this.ppRemoveTask.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TaskPanel.this.ppRemoveTask_actionPerformed(actionEvent);
            }
        });
        this.ppRemoveTask.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/todo_remove.png")));
        this.ppRemoveTask.setEnabled(false);
        this.ppNewTask.setFont(new Font("Dialog", 1, 11));
        this.ppNewTask.setText(Local.getString("New task") + "...");
        this.ppNewTask.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TaskPanel.this.ppNewTask_actionPerformed(actionEvent);
            }
        });
        this.ppNewTask.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/todo_new.png")));
        this.ppAddSubTask.setFont(new Font("Dialog", 1, 11));
        this.ppAddSubTask.setText(Local.getString("Add subtask"));
        this.ppAddSubTask.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TaskPanel.this.ppAddSubTask_actionPerformed(actionEvent);
            }
        });
        this.ppAddSubTask.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/todo_new_sub.png")));
        this.ppCompleteTask.setFont(new Font("Dialog", 1, 11));
        this.ppCompleteTask.setText(Local.getString("Complete task"));
        this.ppCompleteTask.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TaskPanel.this.ppCompleteTask_actionPerformed(actionEvent);
            }
        });
        this.ppCompleteTask.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/todo_complete.png")));
        this.ppCompleteTask.setEnabled(false);
        this.ppCalcTask.setFont(new Font("Dialog", 1, 11));
        this.ppCalcTask.setText(Local.getString("Calculate task data"));
        this.ppCalcTask.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TaskPanel.this.ppCalcTask_actionPerformed(actionEvent);
            }
        });
        this.ppCalcTask.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/todo_complete.png")));
        this.ppCalcTask.setEnabled(false);
        this.scrollPane.getViewport().add((Component)this.taskTable, null);
        this.add((Component)this.scrollPane, "Center");
        this.tasksToolBar.add((Component)this.historyBackB, null);
        this.tasksToolBar.add((Component)this.historyForwardB, null);
        this.tasksToolBar.addSeparator(new Dimension(8, 24));
        this.tasksToolBar.add((Component)this.newTaskB, null);
        this.tasksToolBar.add((Component)this.subTaskB, null);
        this.tasksToolBar.add((Component)this.removeTaskB, null);
        this.tasksToolBar.addSeparator(new Dimension(8, 24));
        this.tasksToolBar.add((Component)this.editTaskB, null);
        this.tasksToolBar.add((Component)this.completeTaskB, null);
        this.add((Component)this.tasksToolBar, "North");
        PopupListener popupListener = new PopupListener();
        this.scrollPane.addMouseListener(popupListener);
        this.taskTable.addMouseListener(popupListener);
        CurrentDate.addDateListener(new DateListener(){

            public void dateChange(CalendarDate calendarDate) {
                TaskPanel.this.newTaskB.setEnabled(calendarDate.inPeriod(CurrentProject.get().getStartDate(), CurrentProject.get().getEndDate()));
            }
        });
        CurrentProject.addProjectListener(new ProjectListener(){

            public void projectChange(Project project, NoteList noteList, TaskList taskList, ResourcesList resourcesList) {
                TaskPanel.this.newTaskB.setEnabled(CurrentDate.get().inPeriod(project.getStartDate(), project.getEndDate()));
            }

            public void projectWasChanged() {
            }
        });
        this.taskTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl = TaskPanel.this.taskTable.getRowCount() > 0 && TaskPanel.this.taskTable.getSelectedRow() > -1;
                TaskPanel.this.editTaskB.setEnabled(bl);
                TaskPanel.this.ppEditTask.setEnabled(bl);
                TaskPanel.this.removeTaskB.setEnabled(bl);
                TaskPanel.this.ppRemoveTask.setEnabled(bl);
                TaskPanel.this.ppCompleteTask.setEnabled(bl);
                TaskPanel.this.completeTaskB.setEnabled(bl);
                TaskPanel.this.ppAddSubTask.setEnabled(bl);
                TaskPanel.this.ppCalcTask.setEnabled(bl);
                if (bl) {
                    String string = TaskPanel.this.taskTable.getModel().getValueAt(TaskPanel.this.taskTable.getSelectedRow(), 100).toString();
                    boolean bl2 = CurrentProject.getTaskList().hasSubTasks(string);
                    TaskPanel.this.ppCalcTask.setEnabled(bl2);
                    Task task = CurrentProject.getTaskList().getTask(string);
                    TaskPanel.this.parentPanel.calendar.jnCalendar.renderer.setTask(task);
                    TaskPanel.this.parentPanel.calendar.jnCalendar.updateUI();
                } else {
                    TaskPanel.this.parentPanel.calendar.jnCalendar.renderer.setTask(null);
                    TaskPanel.this.parentPanel.calendar.jnCalendar.updateUI();
                }
            }
        });
        this.editTaskB.setEnabled(false);
        this.removeTaskB.setEnabled(false);
        this.completeTaskB.setEnabled(false);
        this.ppAddSubTask.setEnabled(false);
        this.taskPPMenu.add(this.ppEditTask);
        this.taskPPMenu.addSeparator();
        this.taskPPMenu.add(this.ppNewTask);
        this.taskPPMenu.add(this.ppAddSubTask);
        this.taskPPMenu.add(this.ppRemoveTask);
        this.taskPPMenu.addSeparator();
        this.taskPPMenu.add(this.ppCompleteTask);
        this.taskPPMenu.add(this.ppCalcTask);
        this.taskPPMenu.addSeparator();
        this.taskPPMenu.add(this.ppShowActiveOnlyChB);
        this.taskTable.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (TaskPanel.this.taskTable.getSelectedRows().length > 0 && keyEvent.getKeyCode() == 127) {
                    TaskPanel.this.ppRemoveTask_actionPerformed(null);
                } else if (keyEvent.getKeyCode() == 155) {
                    if (TaskPanel.this.taskTable.getSelectedRows().length > 0) {
                        TaskPanel.this.ppAddSubTask_actionPerformed(null);
                    } else {
                        TaskPanel.this.ppNewTask_actionPerformed(null);
                    }
                } else if (keyEvent.getKeyCode() == 32 && TaskPanel.this.taskTable.getSelectedRows().length > 0) {
                    TaskPanel.this.ppCompleteTask_actionPerformed(null);
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
    }

    void editTaskB_actionPerformed(ActionEvent actionEvent) {
        Task task = CurrentProject.getTaskList().getTask(this.taskTable.getModel().getValueAt(this.taskTable.getSelectedRow(), 100).toString());
        TaskDialog taskDialog = new TaskDialog((Frame)App.getFrame(), Local.getString("Edit task"));
        Dimension dimension = App.getFrame().getSize();
        Point point = App.getFrame().getLocation();
        taskDialog.setLocation((dimension.width - taskDialog.getSize().width) / 2 + point.x, (dimension.height - taskDialog.getSize().height) / 2 + point.y);
        taskDialog.todoField.setText(task.getText());
        taskDialog.descriptionField.setText(task.getDescription());
        taskDialog.startDate.getModel().setValue(task.getStartDate().getDate());
        taskDialog.endDate.getModel().setValue(task.getEndDate().getDate());
        taskDialog.priorityCB.setSelectedIndex(task.getPriority());
        taskDialog.effortField.setText(Util.getHoursFromMillis(task.getEffort()));
        if (task.getStartDate().getDate().after(task.getEndDate().getDate())) {
            taskDialog.chkEndDate.setSelected(false);
        } else {
            taskDialog.chkEndDate.setSelected(true);
        }
        taskDialog.progress.setValue(new Integer(task.getProgress()));
        taskDialog.chkEndDate_actionPerformed(null);
        taskDialog.setVisible(true);
        if (taskDialog.CANCELLED) {
            return;
        }
        CalendarDate calendarDate = new CalendarDate((Date)taskDialog.startDate.getModel().getValue());
        CalendarDate calendarDate2 = taskDialog.chkEndDate.isSelected() ? new CalendarDate((Date)taskDialog.endDate.getModel().getValue()) : null;
        task.setStartDate(calendarDate);
        task.setEndDate(calendarDate2);
        task.setText(taskDialog.todoField.getText());
        task.setDescription(taskDialog.descriptionField.getText());
        task.setPriority(taskDialog.priorityCB.getSelectedIndex());
        task.setEffort(Util.getMillisFromHours(taskDialog.effortField.getText()));
        task.setProgress((Integer)taskDialog.progress.getValue());
        CurrentStorage.get().storeTaskList(CurrentProject.getTaskList(), CurrentProject.get());
        this.taskTable.tableChanged();
        this.parentPanel.updateIndicators();
    }

    void newTaskB_actionPerformed(ActionEvent actionEvent) {
        TaskDialog taskDialog = new TaskDialog((Frame)App.getFrame(), Local.getString("New task"));
        Dimension dimension = App.getFrame().getSize();
        Point point = App.getFrame().getLocation();
        taskDialog.startDate.getModel().setValue(CurrentDate.get().getDate());
        taskDialog.endDate.getModel().setValue(CurrentDate.get().getDate());
        taskDialog.setLocation((dimension.width - taskDialog.getSize().width) / 2 + point.x, (dimension.height - taskDialog.getSize().height) / 2 + point.y);
        taskDialog.setVisible(true);
        if (taskDialog.CANCELLED) {
            return;
        }
        CalendarDate calendarDate = new CalendarDate((Date)taskDialog.startDate.getModel().getValue());
        CalendarDate calendarDate2 = taskDialog.chkEndDate.isSelected() ? new CalendarDate((Date)taskDialog.endDate.getModel().getValue()) : null;
        long l = Util.getMillisFromHours(taskDialog.effortField.getText());
        Task task = CurrentProject.getTaskList().createTask(calendarDate, calendarDate2, taskDialog.todoField.getText(), taskDialog.priorityCB.getSelectedIndex(), l, taskDialog.descriptionField.getText(), null);
        task.setProgress((Integer)taskDialog.progress.getValue());
        CurrentStorage.get().storeTaskList(CurrentProject.getTaskList(), CurrentProject.get());
        this.taskTable.tableChanged();
        this.parentPanel.updateIndicators();
    }

    void addSubTask_actionPerformed(ActionEvent actionEvent) {
        TaskDialog taskDialog = new TaskDialog((Frame)App.getFrame(), Local.getString("New Task"));
        String string = this.taskTable.getModel().getValueAt(this.taskTable.getSelectedRow(), 100).toString();
        Dimension dimension = App.getFrame().getSize();
        Point point = App.getFrame().getLocation();
        Task task = CurrentProject.getTaskList().getTask(string);
        CalendarDate calendarDate = CurrentDate.get();
        if (calendarDate.after(task.getStartDate())) {
            taskDialog.setStartDate(calendarDate);
        } else {
            taskDialog.setStartDate(task.getStartDate());
        }
        if (task.getEndDate() != null) {
            taskDialog.setEndDate(task.getEndDate());
        } else {
            taskDialog.setEndDate(CurrentProject.get().getEndDate());
        }
        taskDialog.setStartDateLimit(task.getStartDate(), task.getEndDate());
        taskDialog.setEndDateLimit(task.getStartDate(), task.getEndDate());
        taskDialog.setLocation((dimension.width - taskDialog.getSize().width) / 2 + point.x, (dimension.height - taskDialog.getSize().height) / 2 + point.y);
        taskDialog.setVisible(true);
        if (taskDialog.CANCELLED) {
            return;
        }
        CalendarDate calendarDate2 = new CalendarDate((Date)taskDialog.startDate.getModel().getValue());
        CalendarDate calendarDate3 = taskDialog.chkEndDate.isSelected() ? new CalendarDate((Date)taskDialog.endDate.getModel().getValue()) : null;
        long l = Util.getMillisFromHours(taskDialog.effortField.getText());
        Task task2 = CurrentProject.getTaskList().createTask(calendarDate2, calendarDate3, taskDialog.todoField.getText(), taskDialog.priorityCB.getSelectedIndex(), l, taskDialog.descriptionField.getText(), string);
        task2.setProgress((Integer)taskDialog.progress.getValue());
        CurrentStorage.get().storeTaskList(CurrentProject.getTaskList(), CurrentProject.get());
        this.taskTable.tableChanged();
        this.parentPanel.updateIndicators();
    }

    void calcTask_actionPerformed(ActionEvent actionEvent) {
        TaskCalcDialog taskCalcDialog = new TaskCalcDialog(App.getFrame());
        taskCalcDialog.pack();
        Task task = CurrentProject.getTaskList().getTask(this.taskTable.getModel().getValueAt(this.taskTable.getSelectedRow(), 100).toString());
        Dimension dimension = App.getFrame().getSize();
        Point point = App.getFrame().getLocation();
        taskCalcDialog.setLocation((dimension.width - taskCalcDialog.getSize().width) / 2 + point.x, (dimension.height - taskCalcDialog.getSize().height) / 2 + point.y);
        taskCalcDialog.setVisible(true);
        if (taskCalcDialog.CANCELLED) {
            return;
        }
        TaskList taskList = CurrentProject.getTaskList();
        if (taskCalcDialog.calcEffortChB.isSelected()) {
            task.setEffort(taskList.calculateTotalEffortFromSubTasks(task));
        }
        if (taskCalcDialog.compactDatesChB.isSelected()) {
            task.setStartDate(taskList.getEarliestStartDateFromSubTasks(task));
            task.setEndDate(taskList.getLatestEndDateFromSubTasks(task));
        }
        if (taskCalcDialog.calcCompletionChB.isSelected()) {
            long[] lArray = taskList.calculateCompletionFromSubTasks(task);
            int n = (int)Math.round((double)lArray[0] / (double)lArray[1] * 100.0);
            task.setProgress(n);
        }
        CurrentStorage.get().storeTaskList(CurrentProject.getTaskList(), CurrentProject.get());
        this.taskTable.tableChanged();
    }

    void listSubTasks_actionPerformed(ActionEvent actionEvent) {
        String string = this.taskTable.getModel().getValueAt(this.taskTable.getSelectedRow(), 100).toString();
        this.taskTable.tableChanged();
    }

    void parentTask_actionPerformed(ActionEvent actionEvent) {
    }

    void removeTaskB_actionPerformed(ActionEvent actionEvent) {
        int n;
        String string;
        String string2 = this.taskTable.getModel().getValueAt(this.taskTable.getSelectedRow(), 100).toString();
        if (this.taskTable.getSelectedRows().length > 1) {
            string = Local.getString("Remove") + " " + this.taskTable.getSelectedRows().length + " " + Local.getString("tasks") + "?" + "\n" + Local.getString("Are you sure?");
        } else {
            Task task = CurrentProject.getTaskList().getTask(string2);
            string = CurrentProject.getTaskList().hasSubTasks(string2) ? Local.getString("Remove task") + "\n'" + task.getText() + Local.getString("' and all subtasks") + "\n" + Local.getString("Are you sure?") : Local.getString("Remove task") + "\n'" + task.getText() + "'\n" + Local.getString("Are you sure?");
        }
        int n2 = JOptionPane.showConfirmDialog(App.getFrame(), string, Local.getString("Remove task"), 0);
        if (n2 != 0) {
            return;
        }
        Vector<Task> vector = new Vector<Task>();
        for (n = 0; n < this.taskTable.getSelectedRows().length; ++n) {
            Task task = CurrentProject.getTaskList().getTask(this.taskTable.getModel().getValueAt(this.taskTable.getSelectedRows()[n], 100).toString());
            if (task == null) continue;
            vector.add(task);
        }
        for (n = 0; n < vector.size(); ++n) {
            CurrentProject.getTaskList().removeTask((Task)vector.get(n));
        }
        this.taskTable.tableChanged();
        CurrentStorage.get().storeTaskList(CurrentProject.getTaskList(), CurrentProject.get());
        this.parentPanel.updateIndicators();
    }

    void ppCompleteTask_actionPerformed(ActionEvent actionEvent) {
        Task task;
        int n;
        Vector<Task> vector = new Vector<Task>();
        for (n = 0; n < this.taskTable.getSelectedRows().length; ++n) {
            task = CurrentProject.getTaskList().getTask(this.taskTable.getModel().getValueAt(this.taskTable.getSelectedRows()[n], 100).toString());
            if (task == null) continue;
            vector.add(task);
        }
        for (n = 0; n < vector.size(); ++n) {
            task = (Task)vector.get(n);
            task.setProgress(100);
        }
        this.taskTable.tableChanged();
        CurrentStorage.get().storeTaskList(CurrentProject.getTaskList(), CurrentProject.get());
        this.parentPanel.updateIndicators();
    }

    void toggleShowActiveOnly_actionPerformed(ActionEvent actionEvent) {
        Context.put("SHOW_ACTIVE_TASKS_ONLY", new Boolean(this.ppShowActiveOnlyChB.isSelected()));
        this.taskTable.tableChanged();
    }

    void ppEditTask_actionPerformed(ActionEvent actionEvent) {
        this.editTaskB_actionPerformed(actionEvent);
    }

    void ppRemoveTask_actionPerformed(ActionEvent actionEvent) {
        this.removeTaskB_actionPerformed(actionEvent);
    }

    void ppNewTask_actionPerformed(ActionEvent actionEvent) {
        this.newTaskB_actionPerformed(actionEvent);
    }

    void ppAddSubTask_actionPerformed(ActionEvent actionEvent) {
        this.addSubTask_actionPerformed(actionEvent);
    }

    void ppListSubTasks_actionPerformed(ActionEvent actionEvent) {
        this.listSubTasks_actionPerformed(actionEvent);
    }

    void ppParentTask_actionPerformed(ActionEvent actionEvent) {
        this.parentTask_actionPerformed(actionEvent);
    }

    void ppCalcTask_actionPerformed(ActionEvent actionEvent) {
        this.calcTask_actionPerformed(actionEvent);
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && TaskPanel.this.taskTable.getSelectedRow() > -1) {
                TaskPanel.this.editTaskB_actionPerformed(null);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                TaskPanel.this.taskPPMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

