/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui.htmleditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import net.sf.memoranda.ui.htmleditor.ImageDialog;
import net.sf.memoranda.ui.htmleditor.Util;
import net.sf.memoranda.ui.htmleditor.util.Local;

public class FontDialog
extends JDialog {
    JPanel areaPanel = new JPanel(new GridBagLayout());
    GridBagConstraints gbc;
    JPanel buttonsPanel = new JPanel(new FlowLayout(2, 10, 10));
    JButton cancelB = new JButton();
    JButton okB = new JButton();
    JPanel headerPanel = new JPanel(new FlowLayout(0));
    public JLabel header = new JLabel();
    public boolean CANCELLED = false;
    public JComboBox fontSizeCB = new JComboBox<Object>(new Object[]{"", "1", "2", "3", "4", "5", "6", "7"});
    public JComboBox fontFamilyCB;
    public JLabel sample = new JLabel();
    JPanel samplePanel = new JPanel(new FlowLayout(1));
    public JTextField colorField = new JTextField();
    JLabel lblTextColor = new JLabel();
    JButton colorB = new JButton();

    public FontDialog(Frame frame) {
        super(frame, Local.getString("Text properties"), true);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public FontDialog() {
        this((Frame)null);
    }

    void jbInit() throws Exception {
        this.setResizable(false);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        Vector<String> vector = new Vector<String>();
        vector.add("");
        vector.add("serif");
        vector.add("sans-serif");
        vector.add("monospaced");
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        this.fontFamilyCB = new JComboBox(vector);
        this.headerPanel.setBackground(Color.WHITE);
        this.header.setFont(new Font("Dialog", 0, 20));
        this.header.setForeground(new Color(0, 0, 124));
        this.header.setText(Local.getString("Text properties"));
        this.header.setIcon(new ImageIcon(ImageDialog.class.getResource("resources/icons/fontbig.png")));
        this.headerPanel.add(this.header);
        this.getContentPane().add((Component)this.headerPanel, "North");
        this.areaPanel.setBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)));
        this.fontFamilyCB.setMaximumRowCount(9);
        this.fontFamilyCB.setBorder(new TitledBorder(BorderFactory.createEmptyBorder(), Local.getString("Font family")));
        this.fontFamilyCB.setPreferredSize(new Dimension(200, 50));
        this.fontFamilyCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontDialog.this.fontChanged(actionEvent);
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 2;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(10, 10, 5, 5);
        this.areaPanel.add((Component)this.fontFamilyCB, this.gbc);
        this.fontSizeCB.setEditable(true);
        this.fontSizeCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontDialog.this.fontChanged(actionEvent);
            }
        });
        this.fontSizeCB.setBorder(new TitledBorder(BorderFactory.createEmptyBorder(), Local.getString("Font size")));
        this.fontSizeCB.setPreferredSize(new Dimension(60, 50));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 2;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(10, 5, 5, 10);
        this.areaPanel.add((Component)this.fontSizeCB, this.gbc);
        this.lblTextColor.setText(Local.getString("Font color"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.anchor = 10;
        this.gbc.insets = new Insets(5, 20, 5, 5);
        this.areaPanel.add((Component)this.lblTextColor, this.gbc);
        this.colorField.setPreferredSize(new Dimension(60, 25));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 1;
        this.gbc.anchor = 13;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.areaPanel.add((Component)this.colorField, this.gbc);
        this.colorB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontDialog.this.colorB_actionPerformed(actionEvent);
            }
        });
        this.colorB.setIcon(new ImageIcon(FontDialog.class.getResource("resources/icons/color.png")));
        this.colorB.setPreferredSize(new Dimension(25, 25));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 2;
        this.gbc.gridy = 1;
        this.gbc.anchor = 10;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.areaPanel.add((Component)this.colorB, this.gbc);
        this.samplePanel.setBackground(Color.white);
        this.samplePanel.setBorder(BorderFactory.createTitledBorder(Local.getString("Sample")));
        this.sample.setText(Local.getString("AaBbCcDd"));
        this.sample.setHorizontalAlignment(0);
        this.sample.setVerticalAlignment(0);
        this.sample.setPreferredSize(new Dimension(250, 50));
        this.samplePanel.add(this.sample);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.gridwidth = 3;
        this.gbc.gridheight = 2;
        this.gbc.fill = 1;
        this.gbc.insets = new Insets(5, 10, 10, 10);
        this.areaPanel.add((Component)this.samplePanel, this.gbc);
        this.getContentPane().add((Component)this.areaPanel, "Center");
        this.cancelB.setMaximumSize(new Dimension(100, 26));
        this.cancelB.setMinimumSize(new Dimension(100, 26));
        this.cancelB.setPreferredSize(new Dimension(100, 26));
        this.cancelB.setText(Local.getString("Cancel"));
        this.cancelB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontDialog.this.cancelB_actionPerformed(actionEvent);
            }
        });
        this.okB.setMaximumSize(new Dimension(100, 26));
        this.okB.setMinimumSize(new Dimension(100, 26));
        this.okB.setPreferredSize(new Dimension(100, 26));
        this.okB.setText(Local.getString("Ok"));
        this.okB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontDialog.this.okB_actionPerformed(actionEvent);
            }
        });
        this.getRootPane().setDefaultButton(this.okB);
        this.buttonsPanel.add((Component)this.okB, null);
        this.buttonsPanel.add((Component)this.cancelB, null);
        this.getContentPane().add((Component)this.buttonsPanel, "South");
    }

    void okB_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    void cancelB_actionPerformed(ActionEvent actionEvent) {
        this.CANCELLED = true;
        this.dispose();
    }

    void fontChanged(ActionEvent actionEvent) {
        int[] nArray = new int[]{8, 10, 13, 16, 18, 24, 32};
        int n = 16;
        Font font = this.sample.getFont();
        if (this.fontSizeCB.getSelectedIndex() > 0) {
            n = nArray[this.fontSizeCB.getSelectedIndex() - 1];
        }
        String string = this.fontFamilyCB.getSelectedIndex() > 0 ? (String)this.fontFamilyCB.getSelectedItem() : font.getName();
        this.sample.setFont(new Font(string, 0, n));
    }

    void colorB_actionPerformed(ActionEvent actionEvent) {
        UIManager.put("ColorChooser.swatchesNameText", Local.getString("Swatches"));
        UIManager.put("ColorChooser.hsbNameText", Local.getString("HSB"));
        UIManager.put("ColorChooser.rgbNameText", Local.getString("RGB"));
        UIManager.put("ColorChooser.swatchesRecentText", Local.getString("Recent:"));
        UIManager.put("ColorChooser.previewText", Local.getString("Preview"));
        UIManager.put("ColorChooser.sampleText", Local.getString("Sample Text") + " " + Local.getString("Sample Text"));
        UIManager.put("ColorChooser.okText", Local.getString("OK"));
        UIManager.put("ColorChooser.cancelText", Local.getString("Cancel"));
        UIManager.put("ColorChooser.resetText", Local.getString("Reset"));
        UIManager.put("ColorChooser.hsbHueText", Local.getString("H"));
        UIManager.put("ColorChooser.hsbSaturationText", Local.getString("S"));
        UIManager.put("ColorChooser.hsbBrightnessText", Local.getString("B"));
        UIManager.put("ColorChooser.hsbRedText", Local.getString("R"));
        UIManager.put("ColorChooser.hsbGreenText", Local.getString("G"));
        UIManager.put("ColorChooser.hsbBlueText", Local.getString("B2"));
        UIManager.put("ColorChooser.rgbRedText", Local.getString("Red"));
        UIManager.put("ColorChooser.rgbGreenText", Local.getString("Green"));
        UIManager.put("ColorChooser.rgbBlueText", Local.getString("Blue"));
        Color color = JColorChooser.showDialog(this, Local.getString("Font color"), Util.decodeColor(this.colorField.getText()));
        if (color == null) {
            return;
        }
        this.colorField.setText(Util.encodeColor(color));
        Util.setColorField(this.colorField);
        this.sample.setForeground(color);
    }
}

