/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.util;

import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import net.sf.memoranda.CurrentProject;
import net.sf.memoranda.Event;
import net.sf.memoranda.EventsManager;
import net.sf.memoranda.EventsScheduler;
import net.sf.memoranda.Project;
import net.sf.memoranda.ProjectManager;
import net.sf.memoranda.Task;
import net.sf.memoranda.TaskList;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.ui.AppFrame;
import net.sf.memoranda.util.CurrentStorage;
import net.sf.memoranda.util.Local;
import net.sf.memoranda.util.Util;

public class AgendaGenerator {
    static String HEADER = "<html><head><title></title>\n<style>\n    body, td {font: 12pt sans-serif}\n    h1 {font:20pt sans-serif; background-color:#E0E0E0; margin-top:0}\n    h2 {font:16pt sans-serif; margin-bottom:0}\n    li {margin-bottom:5px}\n a {color:black; text-decoration:none}\n</style></head>\n<body><table width=\"100%\" height=\"100%\" border=\"0\" cellpadding=\"4\" cellspacing=\"4\">\n<tr>\n";
    static String FOOTER = "</td></tr></table></body></html>";

    static String generateTasksInfo(Project project, CalendarDate calendarDate, Collection collection) {
        TaskList taskList = project.getID().equals(CurrentProject.get().getID()) ? CurrentProject.getTaskList() : CurrentStorage.get().openTaskList(project);
        String string = "";
        int n = AgendaGenerator.getProgress(taskList);
        if (n > -1) {
            string = string + "<br>" + Local.getString("Total progress") + ": " + n + "%";
        }
        string = string + "</td></tr></table>\n";
        Vector vector = (Vector)taskList.getActiveSubTasks(null, calendarDate);
        if (vector.size() == 0) {
            string = string + "<p>" + Local.getString("No actual tasks") + ".</p>\n";
        } else {
            string = string + Local.getString("Actual tasks") + ":<br>\n<ul>\n";
            System.out.println(calendarDate.getDate());
            Collections.sort(vector);
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                Task task = (Task)iterator.next();
                if (taskList.hasParentTask(task.getID())) continue;
                string = string + AgendaGenerator.renderTask(project, calendarDate, taskList, task, 0, collection);
                if (!collection.contains(task.getID())) continue;
                string = string + AgendaGenerator.expandRecursively(project, calendarDate, taskList, task, collection, 1);
            }
            string = string + "\n</ul>\n";
        }
        return string;
    }

    private static String expandRecursively(Project project, CalendarDate calendarDate, TaskList taskList, Task task, Collection collection, int n) {
        Util.debug("Expanding task " + task.getText() + " level " + n);
        Collection collection2 = taskList.getActiveSubTasks(task.getID(), calendarDate);
        Util.debug("number of subtasks " + collection2.size());
        String string = "\n<ul>\n";
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            Task task2 = (Task)iterator.next();
            string = string + AgendaGenerator.renderTask(project, calendarDate, taskList, task2, n, collection);
            if (!collection.contains(task2.getID())) continue;
            string = string + AgendaGenerator.expandRecursively(project, calendarDate, taskList, task2, collection, n + 1);
        }
        string = string + "\n</ul>\n";
        return string;
    }

    private static String renderTask(Project project, CalendarDate calendarDate, TaskList taskList, Task task, int n, Collection collection) {
        String string = "";
        int n2 = task.getProgress();
        String string2 = "";
        string2 = n2 == 100 ? "<font color=\"green\">" + Local.getString("Completed") + "</font>" : n2 + Local.getString("% done");
        String string3 = "";
        if (taskList.hasSubTasks(task.getID())) {
            string3 = collection.contains(task.getID()) ? "<a href=\"memoranda:closesubtasks#" + task.getID() + "\">(-)</a>" : "<a href=\"memoranda:expandsubtasks#" + task.getID() + "\">(+)</a>";
        }
        string = string + "<a name=\"" + task.getID() + "\"><li><p>" + string3 + "<a href=\"memoranda:tasks#" + project.getID() + "\"><b>" + task.getText() + "</b></a> : " + string2 + "</p>" + "<p>" + Local.getString("Priority") + ": " + AgendaGenerator.getPriorityString(task.getPriority()) + "</p>";
        if (task.getEndDate().equals(calendarDate)) {
            string = string + "<p><font color=\"#FF9900\"><b>" + Local.getString("Should be done today") + ".</b></font></p>";
        } else {
            Calendar calendar = task.getEndDate().getCalendar();
            Calendar calendar2 = calendarDate.getCalendar();
            int n3 = calendar.get(1) * 365 + calendar.get(6) - (calendar2.get(1) * 365 + calendar2.get(6));
            String string4 = "";
            if (n3 > 0) {
                string4 = n3 > 1 ? Local.getString("in") + " " + n3 + " " + Local.getString("day(s)") : Local.getString("tomorrow");
                string = string + "<p>" + Local.getString("Deadline") + ": <i>" + task.getEndDate().getMediumDateString() + "</i> (" + string4 + ")</p>";
            } else if (n3 < 0 && n3 > -10000) {
                String string5 = String.valueOf(-1 * n3);
                string = string + "<p><font color=\"#FF9900\"><b>" + string5 + " " + Local.getString("days overdue") + ".</b></font></p>";
            } else {
                string = string + "<p>" + Local.getString("No Deadline") + "</p>";
            }
        }
        string = string + "</li>\n";
        return string;
    }

    static int getProgress(TaskList taskList) {
        Vector vector = (Vector)taskList.getAllSubTasks(null);
        if (vector.size() == 0) {
            return -1;
        }
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Task task = (Task)enumeration.nextElement();
            n += task.getProgress();
        }
        return n * 100 / (vector.size() * 100);
    }

    static String getPriorityString(int n) {
        switch (n) {
            case 2: {
                return "<font color=\"green\">" + Local.getString("Normal") + "</font>";
            }
            case 1: {
                return "<font color=\"#3333CC\">" + Local.getString("Low") + "</font>";
            }
            case 0: {
                return "<font color=\"#666699\">" + Local.getString("Lowest") + "</font>";
            }
            case 3: {
                return "<font color=\"#FF9900\">" + Local.getString("High") + "</font>";
            }
            case 4: {
                return "<font color=\"red\">" + Local.getString("Highest") + "</font>";
            }
        }
        return "";
    }

    static String generateProjectInfo(Project project, CalendarDate calendarDate, Collection collection) {
        String string = "<h2><a href=\"memoranda:project#" + project.getID() + "\">" + project.getTitle() + "</a></h2>\n" + "<table border=\"0\" width=\"100%\" cellpadding=\"2\" bgcolor=\"#EFEFEF\"><tr><td>" + Local.getString("Start date") + ": <i>" + project.getStartDate().getMediumDateString() + "</i>\n";
        if (project.getEndDate() != null) {
            string = string + "<br>" + Local.getString("End date") + ": <i>" + project.getEndDate().getMediumDateString() + "</i>\n";
        }
        return string + AgendaGenerator.generateTasksInfo(project, calendarDate, collection);
    }

    static String generateAllProjectsInfo(CalendarDate calendarDate, Collection collection) {
        String string = "<td width=\"66%\" valign=\"top\"><h1>" + Local.getString("Projects and tasks") + "</h1>\n";
        string = string + AgendaGenerator.generateProjectInfo(CurrentProject.get(), calendarDate, collection);
        Iterator iterator = ProjectManager.getActiveProjects().iterator();
        while (iterator.hasNext()) {
            Project project = (Project)iterator.next();
            if (project.getID().equals(CurrentProject.get().getID())) continue;
            string = string + AgendaGenerator.generateProjectInfo(project, calendarDate, collection);
        }
        return string + "</td>";
    }

    static String generateEventsInfo(CalendarDate calendarDate) {
        String string = "<td width=\"34%\" valign=\"top\"><a href=\"memoranda:events\"><h1>" + Local.getString("Events") + "</h1></a>\n" + "<table width=\"100%\" valign=\"top\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" bgcolor=\"#FFFFF6\">\n";
        Vector vector = (Vector)EventsManager.getEventsForDate(calendarDate);
        boolean bl = false;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Event event = (Event)iterator.next();
            String string2 = event.getText();
            String string3 = (class$net$sf$memoranda$ui$AppFrame == null ? AgendaGenerator.class$("net.sf.memoranda.ui.AppFrame") : class$net$sf$memoranda$ui$AppFrame).getResource("resources/agenda/spacer.gif").toExternalForm();
            if (calendarDate.equals(CalendarDate.today())) {
                if (event.getTime().after(new Date())) {
                    string2 = "<b>" + string2 + "</b>";
                }
                if (EventsScheduler.isEventScheduled() && EventsScheduler.getFirstScheduledEvent().getTime().equals(event.getTime())) {
                    string3 = (class$net$sf$memoranda$ui$AppFrame == null ? AgendaGenerator.class$("net.sf.memoranda.ui.AppFrame") : class$net$sf$memoranda$ui$AppFrame).getResource("resources/agenda/arrow.gif").toExternalForm();
                }
            }
            String string4 = "<img align=\"right\" width=\"16\" height=\"16\" src=\"" + string3 + "\" border=\"0\"  hspace=\"0\" vspace=\"0\" alt=\"\">";
            string = string + "<tr>\n<td>" + string4 + "</td>" + "<td nowrap class=\"eventtime\">" + event.getTimeString() + "</td>" + "<td width=\"100%\" class=\"eventtext\">&nbsp;&nbsp;" + string2 + "</td>\n" + "</tr>";
        }
        return string + "</table>";
    }

    static String generateStickers(CalendarDate calendarDate) {
        String string = AppFrame.class.getResource("resources/agenda/addsticker.gif").toExternalForm();
        String string2 = AppFrame.class.getResource("resources/agenda/removesticker.gif").toExternalForm();
        String string3 = "<hr><table border=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td><a href=\"memoranda:addsticker\"><img align=\"left\" width=\"22\" height=\"22\" src=\"" + string + "\" border=\"0\"  hspace=\"0\" vspace=\"0\" alt=\"New sticker\"></a></td><td width=\"100%\"><a href=\"memoranda:addsticker\"><b>&nbsp;" + Local.getString("Add sticker") + "</b></a></td></tr></table>";
        Map map = EventsManager.getStickers();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            String string5 = (String)map.get(string4);
            string3 = string3 + "\n<table border=\"0\" cellpadding=\"0\" width=\"100%\"><tr bgcolor=\"#E0E0E0\"><td align=\"right\">&nbsp;<a href=\"memoranda:removesticker#" + string4 + "\"><img align=\"left\" width=\"14\" height=\"14\" src=\"" + string2 + "\" border=\"0\"  hspace=\"0\" vspace=\"0\" alt=\"Remove sticker\"></a></td></tr><tr><td>" + string5 + "</td></tr></table>";
        }
        string3 = string3 + "<hr>";
        return string3;
    }

    public static String getAgenda(CalendarDate calendarDate, Collection collection) {
        String string = HEADER;
        string = string + AgendaGenerator.generateAllProjectsInfo(calendarDate, collection);
        string = string + AgendaGenerator.generateEventsInfo(calendarDate);
        string = string + AgendaGenerator.generateStickers(calendarDate);
        return string + FOOTER;
    }
}

