/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.util;

import java.util.Vector;
import net.sf.memoranda.util.AppList;
import net.sf.memoranda.util.CurrentStorage;
import net.sf.memoranda.util.MimeType;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;

public class MimeTypesList {
    public static Document _doc = null;
    static Element _root = null;

    public static Vector getAllMimeTypes() {
        Vector<MimeType> vector = new Vector<MimeType>();
        Elements elements = _root.getChildElements("mime-type");
        for (int i = 0; i < elements.size(); ++i) {
            vector.add(new MimeType(elements.get(i)));
        }
        return vector;
    }

    public static MimeType getMimeTypeForFile(String string) {
        return MimeTypesList.getMimeTypeByExt(MimeTypesList.getExtension(string));
    }

    public static MimeType getMimeType(String string) {
        Elements elements = _root.getChildElements("mime-type");
        for (int i = 0; i < elements.size(); ++i) {
            if (!elements.get(i).getAttribute("id").getValue().equals(string)) continue;
            return new MimeType(elements.get(i));
        }
        return new MimeType();
    }

    public static MimeType getMimeTypeByExt(String string) {
        Elements elements = _root.getChildElements("mime-type");
        for (int i = 0; i < elements.size(); ++i) {
            Element element = elements.get(i);
            Elements elements2 = element.getChildElements("ext");
            for (int j = 0; j < elements2.size(); ++j) {
                if (!elements2.get(j).getValue().toLowerCase().equals(string.toLowerCase())) continue;
                return new MimeType(element);
            }
        }
        return new MimeType();
    }

    public static MimeType addMimeType(String string) {
        Element element = new Element("mime-type");
        element.addAttribute(new Attribute("id", string));
        _root.appendChild((Node)element);
        return new MimeType(element);
    }

    public static void removeMimeType(String string) {
        Elements elements = _root.getChildElements("mime-type");
        for (int i = 0; i < elements.size(); ++i) {
            if (!elements.get(i).getAttribute("id").getValue().equals(string)) continue;
            _root.removeChild((Node)elements.get(i));
            return;
        }
    }

    public static AppList getAppList() {
        return new AppList(_root.getChildElements("applications").get(0));
    }

    public static String getExtension(String string) {
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n > 0 && n < string.length() - 1) {
            string2 = string.substring(n + 1).toLowerCase();
        }
        return string2;
    }

    static {
        CurrentStorage.get().openMimeTypesList();
        _root = _doc.getRootElement();
    }
}

