/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpd;

import java.util.Date;
import java.util.Map;
import net.sf.mpxj.Duration;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.mpd.Row;
import net.sf.mpxj.utility.BooleanUtility;
import net.sf.mpxj.utility.NumberUtility;

class MapRow
implements Row {
    protected Map m_map;

    public MapRow(Map map) {
        this.m_map = map;
    }

    public final String getString(String name) {
        Object value = this.getObject(name);
        String result = value instanceof byte[] ? new String((byte[])value) : (String)value;
        return result;
    }

    public final Integer getInteger(String name) {
        Object result = this.getObject(name);
        if (result != null && !(result instanceof Integer)) {
            result = new Integer(((Number)result).intValue());
        }
        return (Integer)result;
    }

    public final Double getDouble(String name) {
        Object result = this.getObject(name);
        if (result != null && !(result instanceof Double)) {
            result = new Double(((Number)result).doubleValue());
        }
        return (Double)result;
    }

    public final Double getCurrency(String name) {
        Double value = this.getDouble(name);
        if (value != null) {
            value = new Double(value / 100.0);
        }
        return value;
    }

    public final boolean getBoolean(String name) {
        return BooleanUtility.getBoolean((Boolean)this.getObject(name));
    }

    public final int getInt(String name) {
        return NumberUtility.getInt((Number)this.getObject(name));
    }

    public final Date getDate(String name) {
        return (Date)this.getObject(name);
    }

    public final Duration getDuration(String name) {
        return Duration.getInstance(NumberUtility.getDouble(this.getDouble(name)) / 60000.0, TimeUnit.HOURS);
    }

    private final Object getObject(String name) {
        if (!this.m_map.containsKey(name)) {
            throw new IllegalArgumentException("Invalid column name " + name);
        }
        Object result = this.m_map.get(name);
        return result;
    }
}

