/*
 * Decompiled with CFR 0.152.
 */
package com.projity.dialog;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.projity.dialog.AbstractDialog;
import com.projity.main.Main;
import com.projity.pm.graphic.IconManager;
import com.projity.strings.Messages;
import com.projity.util.BrowserControl;
import com.projity.util.Environment;
import com.projity.util.VersionUtils;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;

public final class AboutDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;

    public static AboutDialog getInstance(Frame frame) {
        return new AboutDialog(frame);
    }

    private AboutDialog(Frame frame) {
        super(frame, Messages.getString("AboutDialog.About") + " " + Messages.getContextString("Text.ApplicationTitle"), true);
    }

    public JComponent createContentPanel() {
        FormLayout formLayout = new FormLayout("default", "p, 3dlu,p, 3dlu, p, 3dlu, p, 10dlu,p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        JLabel jLabel = new JLabel(IconManager.getIcon("icon.projity"));
        jLabel.setCursor(Cursor.getPredefinedCursor(12));
        jLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                BrowserControl.displayURL("http://www.projity.com");
            }
        });
        defaultFormBuilder.append(jLabel);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(Messages.getContextString("Text.ShortTitle"));
        defaultFormBuilder.nextLine(2);
        String string = VersionUtils.getVersion();
        defaultFormBuilder.append("Version " + (string == null ? "Unknown" : string));
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(Messages.getString("AboutDialog.copyright"));
        if (Environment.isOpenProj()) {
            defaultFormBuilder.nextLine(2);
            defaultFormBuilder.append(Main.getRunSinceMessage());
        }
        return defaultFormBuilder.getPanel();
    }

    protected boolean hasCloseButton() {
        return true;
    }

    protected boolean hasOkAndCancelButtons() {
        return false;
    }
}

