/*
 * Decompiled with CFR 0.152.
 */
package com.projity.dialog;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.projity.dialog.AbstractDialog;
import com.projity.dialog.ButtonPanel;
import com.projity.strings.Messages;
import com.projity.util.Alert;
import com.projity.util.BrowserControl;
import com.projity.util.Environment;
import java.awt.Dimension;
import java.awt.Frame;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Random;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public final class LicenseDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    JEditorPane license = null;
    JEditorPane thirdParty = null;
    private boolean init = false;
    private static boolean validated = Preferences.userNodeForPackage(LicenseDialog.class).getBoolean("validatedLicense", false);
    private static boolean resetData;

    public static boolean showDialog(Frame frame, boolean bl) {
        boolean bl2 = resetData = !bl;
        if (!Environment.isOpenProj() && !bl) {
            return false;
        }
        if (!validated || bl) {
            LicenseDialog licenseDialog = new LicenseDialog(frame);
            if (!validated) {
                licenseDialog.setDefaultCloseOperation(0);
            }
            licenseDialog.doModal();
            return true;
        }
        if (Environment.isOpenProj()) {
            System.setProperty("openproj.validation", Preferences.userNodeForPackage(LicenseDialog.class).get("licenseValidationDate", "0"));
        }
        return false;
    }

    private LicenseDialog(Frame frame) {
        super(frame, Messages.getContextString("Text.ApplicationTitle") + " License", true);
        if (!Environment.isOpenProj()) {
            validated = true;
        }
    }

    private JEditorPane createEditorPane(URL uRL, final int n2) {
        JEditorPane jEditorPane = null;
        try {
            jEditorPane = new JEditorPane(uRL){

                public Dimension getPreferredSize() {
                    return new Dimension(600, n2);
                }
            };
        }
        catch (Exception exception) {
            if (!validated) {
                Alert.error(Messages.getString("LicenseDialog.CouldNotLoadExiting"));
                System.exit(-1);
            }
            Alert.error(Messages.getString("LicenseDialog.CouldNotLoadLater"));
            return null;
        }
        jEditorPane.setEditable(false);
        jEditorPane.setAutoscrolls(true);
        jEditorPane.setBounds(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        jEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    BrowserControl.displayURL(hyperlinkEvent.getURL().toExternalForm());
                }
            }
        });
        return jEditorPane;
    }

    protected void initComponents() {
        if (this.init) {
            return;
        }
        this.init = true;
        if (Environment.isOpenProj()) {
            this.license = this.createEditorPane(this.getClass().getClassLoader().getResource("license/index.html"), 7500);
            this.thirdParty = this.createEditorPane(this.getClass().getClassLoader().getResource("license/third-party/index.html"), 1200);
        } else {
            try {
                this.thirdParty = this.createEditorPane(new URL("http://projity.com/license/third-party/index.html"), 1200);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
        super.initComponents();
    }

    public JComponent createContentPanel() {
        JComponent jComponent;
        FormLayout formLayout = new FormLayout("600px", "600px");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        if (!Environment.isOpenProj()) {
            defaultFormBuilder.append(new JScrollPane(this.thirdParty));
        } else {
            jComponent = new JTabbedPane();
            ((JTabbedPane)jComponent).addTab(Messages.getString("LicenseDialog.License"), new JScrollPane(this.license));
            ((JTabbedPane)jComponent).addTab(Messages.getString("LicenseDialog.ThirdParty"), new JScrollPane(this.thirdParty));
            defaultFormBuilder.append(jComponent);
        }
        jComponent = defaultFormBuilder.getPanel();
        return jComponent;
    }

    public ButtonPanel createButtonPanel() {
        ButtonPanel buttonPanel = super.createButtonPanel();
        if (!validated) {
            this.ok.setText(Messages.getString("ButtonText.IAccept"));
        }
        return buttonPanel;
    }

    protected boolean hasCloseButton() {
        return validated;
    }

    protected void onCancel() {
        if (!validated) {
            System.exit(-1);
        }
        super.onCancel();
    }

    public void onOk() {
        validated = true;
        if (resetData) {
            Preferences.userNodeForPackage(LicenseDialog.class).put("licenseValidationDate", System.currentTimeMillis() + "." + new Random().nextInt(1000));
            Preferences.userNodeForPackage(LicenseDialog.class).putBoolean("validatedLicense", validated);
            System.setProperty("openproj.validation", Preferences.userNodeForPackage(LicenseDialog.class).get("licenseValidationDate", "0"));
        }
        super.onOk();
    }
}

