/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.assignment;

import com.projity.configuration.CircularDependencyException;
import com.projity.datatype.Duration;
import com.projity.datatype.Rate;
import com.projity.document.Document;
import com.projity.functor.IntervalConsumer;
import com.projity.options.CalendarOption;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.assignment.HasTimeDistributedData;
import com.projity.pm.assignment.contour.AbstractContour;
import com.projity.pm.assignment.contour.AbstractContourBucket;
import com.projity.pm.assignment.contour.ContourTypes;
import com.projity.pm.assignment.contour.PersonalContour;
import com.projity.pm.assignment.contour.StandardContour;
import com.projity.pm.calendar.CalendarService;
import com.projity.pm.calendar.HasCalendar;
import com.projity.pm.calendar.InvalidCalendarIntersectionException;
import com.projity.pm.calendar.WorkCalendar;
import com.projity.pm.calendar.WorkingCalendar;
import com.projity.pm.criticalpath.TaskSchedule;
import com.projity.pm.resource.Resource;
import com.projity.pm.scheduling.Delayable;
import com.projity.pm.scheduling.DelayableImpl;
import com.projity.pm.scheduling.Schedule;
import com.projity.pm.scheduling.ScheduleInterval;
import com.projity.pm.scheduling.ScheduleUtil;
import com.projity.pm.task.NormalTask;
import com.projity.pm.task.Task;
import com.projity.pm.time.MutableInterval;
import com.projity.strings.Messages;
import com.projity.util.Alert;
import com.projity.util.DateTime;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;

public final class AssignmentDetail
implements Schedule,
HasCalendar,
Cloneable,
Serializable,
ContourTypes {
    static final long serialVersionUID = 867792734923243L;
    transient Rate rate = new Rate(1.0, 6);
    double percentComplete = 0.0;
    long duration = 0L;
    private int workContourType;
    private int costContourType;
    private transient AbstractContour workContour = StandardContour.FLAT_CONTOUR;
    private transient AbstractContour costContour = StandardContour.FLAT_CONTOUR;
    private WorkingCalendar actualExceptionsCalendar = null;
    private transient WorkingCalendar intersectionCalendar = null;
    private transient TaskSchedule taskSchedule = null;
    private transient Resource resource;
    private transient Task task;
    private transient Delayable delayable;
    private int requestDemandType = 0;
    private int costRateIndex = 0;
    private long overtimeWork = 0L;
    private WorkingCalendar baselineCalendar = null;
    private static short DEFAULT_VERSION = 1;
    private short version = DEFAULT_VERSION;

    public double getPercentComplete() {
        return this.percentComplete;
    }

    public void setPercentComplete(double d2) {
        this.percentComplete = d2;
        if (this.getTask() != null) {
            ((NormalTask)this.getTask()).adjustActualStartFromAssignments();
        }
    }

    public long getDuration() {
        return this.duration;
    }

    void recalculateDuration() {
        this.duration = this.workContour.calcTotalBucketDuration(0L);
    }

    void setTaskSchedule(TaskSchedule taskSchedule) {
        this.taskSchedule = taskSchedule;
    }

    void replaceResourceAndUnits(double d2, Resource resource) {
        this.resource = resource;
        this.setUnits(d2);
    }

    AssignmentDetail(Task task, Resource resource, double d2, int n2, long l2) {
        this.task = task;
        this.resource = resource;
        this.setUnits(d2);
        this.requestDemandType = n2;
        this.delayable = new DelayableImpl(l2, 0L);
    }

    private AssignmentDetail() {
    }

    double getUnits() {
        return this.rate.getValue();
    }

    void setUnits(double d2) {
        this.rate.setValue(d2);
    }

    double calcOvertimeUnits() {
        long l2 = this.calcWorkingDuration();
        if (l2 == 0L) {
            return 0.0;
        }
        return (double)this.overtimeWork / (double)l2;
    }

    void setOvertimeWork(long l2) {
        this.overtimeWork = l2;
    }

    long calcWork() {
        return (long)(this.getUnits() * (double)this.calcWorkingDuration());
    }

    public String toString() {
        return super.toString();
    }

    AbstractContour getWorkContour() {
        return this.workContour;
    }

    public void debugSetWorkContour(AbstractContour abstractContour) {
        this.workContour = abstractContour;
    }

    public long getDelay() {
        return this.delayable.getDelay();
    }

    void setDelay(long l2) {
        this.delayable = new DelayableImpl(l2, this.delayable.getLevelingDelay());
    }

    public long getLevelingDelay() {
        return this.delayable.getLevelingDelay();
    }

    void setLevelingDelay(long l2) {
        this.delayable = new DelayableImpl(this.delayable.getDelay(), l2);
    }

    public long calcTotalDelay() {
        return this.delayable.calcTotalDelay();
    }

    void setContour(Object object, Collection collection) {
        AbstractContourBucket[] abstractContourBucketArray = new AbstractContourBucket[collection.size()];
        collection.toArray(abstractContourBucketArray);
        this.setContour(object, abstractContourBucketArray);
    }

    void setContour(Object object, AbstractContourBucket[] abstractContourBucketArray) {
        if (object == HasTimeDistributedData.WORK) {
            this.workContour = PersonalContour.getInstance(abstractContourBucketArray);
        } else if (object == HasTimeDistributedData.COST) {
            this.costContour = PersonalContour.getInstance(abstractContourBucketArray);
        }
    }

    public int getRequestDemandType() {
        return this.requestDemandType;
    }

    void setRequestDemandType(int n2) {
        this.requestDemandType = n2;
    }

    void setWorkContour(AbstractContour abstractContour) {
        this.workContour = abstractContour;
    }

    void adjustRemainingDuration(long l2) {
        if (l2 < 0L) {
            l2 = 0L;
        }
        if (this.getUnits() == 0.0) {
            l2 = 0L;
        }
        long l3 = this.getActualDuration();
        long l4 = l2 + l3;
        if (l3 > 0L && !this.workContour.isPersonal()) {
            this.workContour = PersonalContour.makePersonal(this.workContour, this.getDuration());
        }
        this.workContour = this.workContour.adjustDuration(l4, l3);
        l4 = this.workContour.calcTotalBucketDuration(l4);
        this.setDuration(l4);
    }

    void adjustRemainingUnits(double d2) {
        this.workContour = this.workContour.adjustUnits(d2 / this.getUnits(), this.getActualDuration());
        this.setUnits(d2);
    }

    void adjustRemainingWork(double d2) {
        long l2;
        AbstractContour abstractContour = this.workContour.contourAdjustWork(d2, this.getActualDuration());
        if (this.workContour != abstractContour) {
            this.workContour = abstractContour;
            l2 = this.workContour.calcTotalBucketDuration(this.getDuration());
        } else {
            l2 = (long)((double)this.getActualDuration() + (double)this.getRemainingDuration() * d2);
        }
        this.setDuration(l2);
        this.setUnits(this.getUnits() / d2);
    }

    long calcWorkingDuration() {
        return this.workContour.calcWorkingBucketDuration(this.getDuration());
    }

    void adjustWorkingDuration(long l2) {
        this.adjustRemainingDuration(this.getDuration() + (l2 - this.calcWorkingDuration()));
    }

    TaskSchedule getTaskSchedule() {
        if (this.taskSchedule == null) {
            return this.getTask().getCurrentSchedule();
        }
        return this.taskSchedule;
    }

    TaskSchedule getTaskScheduleOfAssignment() {
        return this.taskSchedule;
    }

    void convertToBaselineAssignment(boolean bl) {
        try {
            this.baselineCalendar = bl ? CalendarService.getInstance().getDefaultInstance() : (WorkingCalendar)this.getEffectiveWorkCalendar().clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
    }

    boolean isBaseline() {
        return this.baselineCalendar != null;
    }

    public WorkCalendar getEffectiveWorkCalendar() {
        if (this.actualExceptionsCalendar != null) {
            return this.actualExceptionsCalendar;
        }
        if (this.baselineCalendar != null) {
            return this.baselineCalendar;
        }
        Resource resource = this.getResource();
        Task task = this.getTask();
        if (((NormalTask)task).isIgnoreResourceCalendar() || this.isInvalidIntersectionCalendar() || resource.getEffectiveWorkCalendar() == null) {
            return task.getEffectiveWorkCalendar();
        }
        if (task.getWorkCalendar() == null) {
            return resource.getEffectiveWorkCalendar();
        }
        if (this.intersectionCalendar == null) {
            try {
                this.intersectionCalendar = ((WorkingCalendar)task.getEffectiveWorkCalendar()).intersectWith((WorkingCalendar)resource.getEffectiveWorkCalendar());
            }
            catch (InvalidCalendarIntersectionException invalidCalendarIntersectionException) {
                this.intersectionCalendar = WorkingCalendar.INVALID_INTERSECTION_CALENDAR;
                Alert.error(Messages.getString("Message.invalidIntersection"));
                return task.getEffectiveWorkCalendar();
            }
        }
        return this.intersectionCalendar;
    }

    public boolean isInvalidIntersectionCalendar() {
        return this.intersectionCalendar == WorkingCalendar.INVALID_INTERSECTION_CALENDAR;
    }

    Task getTask() {
        return this.task;
    }

    public long getStart() {
        long l2;
        long l3 = this.calcTotalDelay();
        TaskSchedule taskSchedule = this.getTaskSchedule();
        long l4 = taskSchedule.getStart();
        if (this.percentComplete == 0.0 && (l2 = taskSchedule.getDependencyDate()) > l4 && !this.task.startsBeforeProject()) {
            l4 = l2;
        }
        if (l3 > 0L) {
            l4 = this.getEffectiveWorkCalendar().add(l4, l3, false);
        }
        return l4;
    }

    public void setStart(long l2) {
        if (l2 > this.getTaskStart()) {
            long l3 = this.getEffectiveWorkCalendar().compare(l2, this.getTaskStart(), false);
            this.setLevelingDelay(0L);
            this.setDelay(l3);
        }
    }

    long getSplitDuration() {
        long l2 = this.getDependencyStart();
        if (l2 == 0L || this.getDependencyStart() == this.getTaskStart()) {
            return 0L;
        }
        long l3 = Math.max(this.getTaskStart(), this.getStop());
        return Math.max(0L, this.getEffectiveWorkCalendar().compare(this.getDependencyStart(), l3, false));
    }

    long getFinish() {
        return this.getEnd();
    }

    Resource getResource() {
        return this.resource;
    }

    AbstractContourBucket[] getContour(Object object) {
        return (object == HasTimeDistributedData.COST ? this.costContour : this.workContour).getContourBuckets();
    }

    AbstractContour getCostContour() {
        return this.costContour;
    }

    int getCostRateIndex() {
        return this.costRateIndex;
    }

    void setCostRateIndex(int n2) {
        this.costRateIndex = n2;
    }

    Assignment getBaselineAssignment() {
        if (this.task == null) {
            return null;
        }
        return this.task.getBaselineAssignment(this.resource);
    }

    Assignment getBaselineAssignment(Object object, boolean bl) {
        if (this.task == null) {
            return null;
        }
        return this.task.getBaselineAssignment(this.resource, object, bl);
    }

    long effectiveBaselineStart() {
        Assignment assignment = this.getBaselineAssignment();
        if (assignment == null) {
            return this.getStart();
        }
        return assignment.getStart();
    }

    long effectiveBaselineStart(Object object) {
        Assignment assignment = this.getBaselineAssignment(object, false);
        if (assignment == null) {
            return this.getStart();
        }
        return assignment.getStart();
    }

    long effectiveBaselineFinish(Object object) {
        Assignment assignment = this.getBaselineAssignment(object, false);
        if (assignment == null) {
            return this.getFinish();
        }
        return assignment.getFinish();
    }

    long getResourceAvailability() {
        WorkCalendar workCalendar = this.resource.getEffectiveWorkCalendar();
        if (workCalendar == null) {
            workCalendar = this.task.getOwningProject().getEffectiveWorkCalendar();
        }
        return (long)this.resource.getMaximumUnits() * workCalendar.compare(this.getFinish(), this.getStart(), false);
    }

    void shift(long l2, long l3, long l4) {
        PersonalContour personalContour = PersonalContour.makePersonal(this.workContour, this.getDuration());
        personalContour = personalContour.shift(l2, l3, l4);
        this.workContour = personalContour;
        if (this.workContour.isPersonal()) {
            this.duration = this.workContour.calcTotalBucketDuration(this.duration);
        }
        this.checkForNegativeDuration();
    }

    private void checkForNegativeDuration() {
        if (this.duration < 0L) {
            if (this.getDelay() > 0L) {
                this.setDelay(0L);
            }
            this.duration = 0L;
        }
    }

    void extend(long l2, long l3) {
        this.workContour = this.workContour.extend(l2, l3);
        this.duration = this.workContour.isPersonal() ? this.workContour.calcTotalBucketDuration(this.duration) : (this.duration += l3);
        this.checkForNegativeDuration();
    }

    public void extendBefore(long l2, long l3) {
        this.workContour = this.workContour.extendBefore(l2, l3);
        this.duration = this.workContour.isPersonal() ? this.workContour.calcTotalBucketDuration(this.duration) : (this.duration -= l3);
        this.checkForNegativeDuration();
    }

    public void split(Object object, long l2, long l3) {
        System.out.println("split should not be called for AssignmentDetail");
    }

    public void removeEmptyBucketAtDuration(long l2) {
        if (this.workContour.isPersonal()) {
            this.workContour = ((PersonalContour)this.workContour).removeEmptyBucketAtDuration(l2);
        }
    }

    MutableInterval getRangeThatIntervalCanBeMoved(long l2, long l3) {
        return this.workContour.getRangeThatIntervalCanBeMoved(l2, l3);
    }

    public void setWorkCalendar(WorkCalendar workCalendar) {
    }

    public WorkCalendar getWorkCalendar() {
        return this.getEffectiveWorkCalendar();
    }

    public long getDependencyStart() {
        return this.getTaskSchedule().getRemainingDependencyDate();
    }

    long getTaskStart() {
        return this.getTaskSchedule().getStart();
    }

    public void setDuration(long l2) {
        long l3 = this.getStop();
        if (Duration.millis(l2) < 0L) {
            l2 = 0L;
        }
        this.duration = l2;
        this.setStop(l3);
    }

    public long getActualFinish() {
        if (this.getPercentComplete() < 1.0) {
            return 0L;
        }
        return this.getEnd();
    }

    public void setActualFinish(long l2) {
        this.setEnd(l2);
        this.setPercentComplete(1.0);
    }

    public long getEnd() {
        long l2;
        WorkCalendar workCalendar = this.getEffectiveWorkCalendar();
        long l3 = workCalendar.add(this.getStart(), this.getDuration(), true);
        if (this.getPercentComplete() > 0.0 && this.getPercentComplete() < 1.0 && (l2 = this.getDependencyStart()) > this.getTaskStart()) {
            long l4 = workCalendar.compare(l2, this.getTaskStart(), false);
            l3 = workCalendar.add(l3, l4, true);
        }
        return l3;
    }

    public void setEnd(long l2) {
        long l3;
        long l4;
        long l5 = this.getRemainingDuration();
        long l6 = this.getEnd();
        if (l6 == l2) {
            return;
        }
        long l7 = this.getStop();
        if (l7 > l2) {
            l2 = l7;
        }
        if ((l4 = l5 + (l3 = this.getEffectiveWorkCalendar().compare(l2, l6, false))) < 0L) {
            l4 = 0L;
        }
        this.adjustRemainingDuration(l4);
        this.setStop(l7);
    }

    public long getActualStart() {
        if (this.percentComplete == 0.0) {
            return 0L;
        }
        return this.getStart();
    }

    public void setActualStart(long l2) {
        this.setStart(l2);
        if (this.percentComplete == 0.0) {
            this.setPercentComplete(1.0E-30);
        }
    }

    public long getActualDuration() {
        return DateTime.closestDate((double)this.getDuration() * this.getPercentComplete());
    }

    public void setActualDuration(long l2) {
        if (this.getDuration() > 0L) {
            this.setPercentComplete((double)l2 / (double)this.getDuration());
        }
    }

    public void clearDuration() {
        this.setDuration(0L);
    }

    public void moveInterval(Object object, long l2, long l3, ScheduleInterval scheduleInterval, boolean bl) {
        throw new RuntimeException("cannot call moveInterval for an AssignmentDetail");
    }

    public void moveRemainingToDate(long l2) {
        throw new RuntimeException("cannot call moveRemainingToDate for an AssignmentDetail");
    }

    public void consumeIntervals(IntervalConsumer intervalConsumer) {
        throw new RuntimeException("cannot call consumeIntervals for an AssignmentDetail");
    }

    public long getElapsedDuration() {
        return Math.round((double)this.getEffectiveWorkCalendar().compare(this.getEnd(), this.getStart(), true) * CalendarOption.getInstance().getFractionOfDayThatIsWorking());
    }

    public long getRemainingDuration() {
        return DateTime.closestDate((double)this.getDuration() * (1.0 - this.percentComplete));
    }

    public void setRemainingDuration(long l2) {
        this.setPercentComplete(1.0 - (double)l2 / (double)this.getDuration());
    }

    public long getStop() {
        long l2 = 0L;
        if (this.percentComplete > 0.0 && this.percentComplete != 1.0E-30) {
            l2 = this.getEffectiveWorkCalendar().add(this.getStart(), this.getActualDuration(), true);
        }
        return l2;
    }

    public void setDependencyStart(long l2) {
        throw new RuntimeException("cannot call setDependencyStart for an AssignmentDetail");
    }

    void removeFillerAfter(long l2) {
        long l3 = this.getEffectiveWorkCalendar().compare(l2, this.getStart(), false);
        this.workContour = this.workContour.removeFillerAfter(l3);
    }

    public void setStop(long l2) {
        if (l2 < this.getStart()) {
            return;
        }
        if (this.percentComplete == 1.0 && l2 >= this.getActualFinish()) {
            return;
        }
        if (l2 <= this.getStart()) {
            this.setPercentComplete(0.0);
        } else {
            long l3 = this.getEffectiveWorkCalendar().compare(l2, this.getStart(), false);
            long l4 = this.getDuration();
            if (l4 != 0L) {
                this.setPercentComplete((double)l3 / (double)l4);
            }
        }
    }

    public long getResume() {
        long l2 = 0L;
        if (this.percentComplete > 0.0) {
            l2 = this.getEffectiveWorkCalendar().add(this.getStart(), this.getActualDuration(), false);
        }
        l2 = Math.max(l2, this.getDependencyStart());
        if (this.workContour.isPersonal()) {
            // empty if block
        }
        return l2;
    }

    public void setResume(long l2) {
        long l3 = this.getResume();
        long l4 = this.getEffectiveWorkCalendar().compare(l2, l3, false);
        if (l4 == 0L) {
            return;
        }
        if (l2 > l3) {
            // empty if block
        }
    }

    long extractDelay() {
        return this.workContour.extractDelay();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.workContourType = this.workContour.getType();
        this.costContourType = this.costContour.getType();
        objectOutputStream.defaultWriteObject();
        this.rate.serialize(objectOutputStream);
        objectOutputStream.writeLong(this.delayable.getDelay());
        objectOutputStream.writeLong(this.delayable.getLevelingDelay());
        if (this.workContourType == 8) {
            objectOutputStream.writeObject(this.workContour.getContourBuckets());
        }
        if (this.costContourType == 8) {
            objectOutputStream.writeObject(this.costContour.getContourBuckets());
        }
        if (this.version >= 1) {
            objectOutputStream.writeBoolean(this.taskSchedule == null);
            if (this.taskSchedule != null) {
                this.taskSchedule.serialize(objectOutputStream);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl;
        objectInputStream.defaultReadObject();
        this.rate = Rate.deserialize(objectInputStream);
        this.delayable = new DelayableImpl(objectInputStream.readLong(), objectInputStream.readLong());
        this.workContour = this.workContourType == 8 ? PersonalContour.getInstance((AbstractContourBucket[])objectInputStream.readObject()) : StandardContour.getStandardContour(this.workContourType);
        this.costContour = this.costContourType == 8 ? PersonalContour.getInstance((AbstractContourBucket[])objectInputStream.readObject()) : StandardContour.getStandardContour(this.costContourType);
        if (this.version >= 1 && !(bl = objectInputStream.readBoolean())) {
            this.taskSchedule = TaskSchedule.deserialize(objectInputStream);
            this.taskSchedule.setTask(this.task);
        }
        this.version = DEFAULT_VERSION;
    }

    public Object clone() {
        AssignmentDetail assignmentDetail = new AssignmentDetail();
        assignmentDetail.rate = (Rate)this.rate.clone();
        assignmentDetail.percentComplete = this.percentComplete;
        assignmentDetail.duration = this.duration;
        assignmentDetail.workContour = (AbstractContour)this.workContour.clone();
        assignmentDetail.costContour = this.costContour;
        assignmentDetail.actualExceptionsCalendar = this.actualExceptionsCalendar;
        assignmentDetail.intersectionCalendar = this.intersectionCalendar;
        assignmentDetail.taskSchedule = this.taskSchedule;
        assignmentDetail.resource = this.resource;
        assignmentDetail.task = this.task;
        assignmentDetail.delayable = (Delayable)((DelayableImpl)this.delayable).clone();
        assignmentDetail.requestDemandType = this.requestDemandType;
        assignmentDetail.costRateIndex = this.costRateIndex;
        assignmentDetail.overtimeWork = this.overtimeWork;
        assignmentDetail.baselineCalendar = this.baselineCalendar;
        return assignmentDetail;
    }

    public long getOvertimeWork() {
        return this.overtimeWork;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    boolean hasDuration() {
        return this.duration != 0L;
    }

    public final boolean isTemporal() {
        return this.rate.getTimeUnit() != -2;
    }

    void setRateUnit(int n2) {
        this.rate.setTimeUnit(n2);
    }

    public final Rate getRate() {
        return this.rate;
    }

    public final void setRate(Rate rate) {
        this.rate = rate;
    }

    public void invalidateAssignmentCalendar() {
        if (this.intersectionCalendar != null) {
            this.intersectionCalendar = null;
        }
        if (this.actualExceptionsCalendar != null) {
            this.actualExceptionsCalendar.invalidate();
        }
    }

    public Document invalidateCalendar() {
        return this.task.getOwningProject();
    }

    public boolean isJustModified() {
        Task task = this.getTask();
        if (task == null) {
            return false;
        }
        return task.isJustModified();
    }

    public void addCalendarTime(long l2, long l3) {
        if (this.actualExceptionsCalendar == null) {
            WorkCalendar workCalendar = this.getEffectiveWorkCalendar();
            this.actualExceptionsCalendar = CalendarService.getInstance().getStandardBasedInstance();
            try {
                this.actualExceptionsCalendar.setBaseCalendar(workCalendar);
            }
            catch (CircularDependencyException circularDependencyException) {
                circularDependencyException.printStackTrace();
            }
        }
        this.actualExceptionsCalendar.addCalendarTime(l2, l3);
    }

    public void setComplete(boolean bl) {
        ScheduleUtil.setComplete(this, bl);
    }

    public boolean isComplete() {
        return this.getPercentComplete() == 1.0;
    }

    public final long getEarliestStop() {
        return this.getStop();
    }

    public final long getCompletedThrough() {
        return this.getStop();
    }

    public void setCompletedThrough(long l2) {
        this.setStop(l2);
    }

    public Object backupDetail() {
        return this.clone();
    }

    public void restoreDetail(Object object, Object object2, boolean bl) {
    }
}

