/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.calendar;

import com.projity.pm.calendar.WorkRangeException;
import com.projity.pm.time.ImmutableInterval;
import com.projity.strings.Messages;
import com.projity.util.DateTime;
import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;

public class WorkRange
extends ImmutableInterval
implements Cloneable,
Serializable {
    static final long serialVersionUID = 9997878787333L;
    private boolean overtime = false;

    public WorkRange(long l2, long l3) throws WorkRangeException {
        this(l2, l3, false);
    }

    public WorkRange(long l2, long l3, boolean bl) throws WorkRangeException {
        super(l2, l3);
        if (l3 == 0L) {
            this.end = DateTime.hour24();
        }
        if (l3 <= l2) {
            throw new WorkRangeException(Messages.getString("WorkRangeException.EndMustBeAfterStart"));
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    public long calcWorkingHours() {
        return this.getElapsedDuration();
    }

    public boolean isOvertime() {
        return this.overtime;
    }

    public void setOvertime(boolean bl) {
        this.overtime = bl;
    }

    boolean overlaps(WorkRange workRange) {
        if (workRange == null) {
            return false;
        }
        return (this.start <= workRange.start || this.end <= workRange.end) && (workRange.start <= this.start || workRange.end <= this.end);
    }

    boolean isBefore(WorkRange workRange) {
        if (workRange == null) {
            return true;
        }
        return this.start < workRange.start && this.end < workRange.end;
    }

    public String toString() {
        GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
        gregorianCalendar.setTimeInMillis(this.start);
        GregorianCalendar gregorianCalendar2 = DateTime.calendarInstance();
        gregorianCalendar2.setTimeInMillis(this.end);
        return gregorianCalendar.get(11) + ":" + gregorianCalendar.get(12) + "-" + gregorianCalendar2.get(11) + ":" + gregorianCalendar2.get(12);
    }

    public static Date getNormalized(long l2) {
        GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
        gregorianCalendar.setTimeInMillis(l2);
        return gregorianCalendar.getTime();
    }

    public Date getNormalizedStartTime() {
        return WorkRange.getNormalized(this.start);
    }

    public Date getNormalizedEndTime() {
        return WorkRange.getNormalized(this.end);
    }
}

