/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.gantt;

import com.projity.pm.graphic.gantt.Gantt;
import com.projity.pm.graphic.gantt.GanttInteractor;
import com.projity.pm.graphic.gantt.GanttParams;
import com.projity.pm.graphic.gantt.GanttRenderer;
import com.projity.pm.graphic.graph.GraphUI;
import com.projity.pm.graphic.graph.GraphZone;
import com.projity.pm.graphic.model.cache.GraphicNode;
import com.projity.pm.graphic.timescale.CoordinatesConverter;

public class GanttUI
extends GraphUI {
    public static final int PROGRESS_BAR_ZONE_ID = 1;

    public GanttUI(Gantt gantt) {
        super(gantt, new GanttRenderer(gantt));
        this.interactor = new GanttInteractor(this);
    }

    public double getBarY(int n2) {
        return n2 * ((Gantt)this.graph).getRowHeight() + this.config.getGanttBarYOffset();
    }

    public GraphZone getNodeAt(double d2, double d3) {
        double d4;
        double d5 = ((Gantt)this.graph).getRowHeight();
        int n2 = (int)Math.floor(d3 / d5);
        if (n2 < 0 || n2 >= this.graph.getModel().getCache().getSize()) {
            return null;
        }
        GraphicNode graphicNode = (GraphicNode)this.graph.getModel().getCache().getElementAt(n2);
        double d6 = this.getBarY(n2) + graphicNode.getGanttShapeOffset();
        double d7 = graphicNode.getGanttShapeHeight();
        double d8 = this.config.getSelectionSquare();
        if (d3 < d6 || d3 > d6 + d7) {
            return null;
        }
        CoordinatesConverter coordinatesConverter = this.getCoord();
        double d9 = coordinatesConverter.toTime(d2);
        if (graphicNode.contains(d9, d4 = coordinatesConverter.toDuration(d8), d4, coordinatesConverter) == null) {
            return null;
        }
        double d10 = this.config.getGanttProgressBarHeight();
        GraphZone graphZone = new GraphZone();
        graphZone.setObject(graphicNode);
        if (d3 >= d6 + d7 / 2.0 - d10 / 2.0 && d3 < d6 + d7 / 2.0 + d10 / 2.0) {
            graphZone.setZoneId(1);
        }
        return graphZone;
    }

    public CoordinatesConverter getCoord() {
        return ((GanttParams)this.graphRenderer.getGraphInfo()).getCoord();
    }
}

