/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.network.rendering;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.projity.configuration.Configuration;
import com.projity.field.Field;
import com.projity.field.FieldConverter;
import com.projity.graphic.configuration.BarFormat;
import com.projity.graphic.configuration.FormBox;
import com.projity.graphic.configuration.FormBoxLayout;
import com.projity.graphic.configuration.FormFormat;
import com.projity.grouping.core.Node;
import com.projity.grouping.core.model.NodeModel;
import com.projity.pm.graphic.ChangeAwareComponent;
import com.projity.pm.graphic.ChangeAwareTextField;
import com.projity.pm.graphic.network.rendering.FieldChange;
import com.projity.strings.Messages;
import com.projity.util.Alert;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FormComponent
extends JPanel {
    protected int maxRows = 3;
    protected int maxCols = 2;
    protected Map fieldComponents = new HashMap();
    protected List selectedFormats;
    protected boolean editor;
    protected int zoom;
    protected boolean texture = true;

    public FormComponent(List list, int n2, boolean bl, boolean bl2) {
        this.selectedFormats = list;
        this.editor = bl;
        this.zoom = n2;
        this.texture = bl2;
        BarFormat barFormat = list == null || list.size() == 0 ? null : (BarFormat)list.get(0);
        this.init(barFormat);
        this.setOpaque(false);
        this.setForeground(Color.BLACK);
        this.setBackground(Color.WHITE);
    }

    public boolean isEditor() {
        return this.editor;
    }

    public void setEditor(boolean bl) {
        this.editor = bl;
    }

    public void init(BarFormat barFormat) {
        if (barFormat == null) {
            return;
        }
        FormFormat formFormat = barFormat.getForm();
        if (formFormat == null) {
            return;
        }
        List list = formFormat.getBoxes();
        if (list == null || list.size() == 0) {
            return;
        }
        FormBoxLayout formBoxLayout = formFormat.getLayout(this.zoom);
        FormLayout formLayout = new FormLayout(formBoxLayout.getColumnGrid(), formBoxLayout.getRowGrid());
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(this, formLayout);
        if (formBoxLayout.getBorder() == null) {
            defaultFormBuilder.setDefaultDialogBorder();
        } else {
            defaultFormBuilder.setBorder(Borders.createEmptyBorder(formBoxLayout.getBorder()));
        }
        CellConstraints cellConstraints = new CellConstraints();
        for (FormBox formBox : list) {
            JComponent jComponent;
            if (this.zoom < formBox.getMinZoom()) {
                return;
            }
            if (formBox.getFieldId() == null) {
                jComponent = new JLabel(Messages.getString(formBox.getTextId()));
            } else {
                if (this.editor && !formBox.getField().isReadOnly()) {
                    jComponent = new ChangeAwareTextField();
                    jComponent.setBorder(null);
                } else {
                    jComponent = new JLabel();
                }
                this.fieldComponents.put(formBox.getFieldId(), jComponent);
            }
            Font font = formBoxLayout.getFont(formBox.getFont());
            if (font != null) {
                jComponent.setFont(font);
            }
            defaultFormBuilder.add((Component)jComponent, formBox.getAlignment() == null ? cellConstraints.xywh(formBox.getColumn(), formBox.getRow(), formBox.getColumnSpan(), formBox.getRowSpan()) : cellConstraints.xywh(formBox.getColumn(), formBox.getRow(), formBox.getColumnSpan(), formBox.getRowSpan(), formBox.getAlignment()));
        }
    }

    public Component getComponent(String string) {
        return (Component)this.fieldComponents.get(string);
    }

    public void setFields(Node node, NodeModel nodeModel) {
        for (String string : this.fieldComponents.keySet()) {
            Object v2;
            Field field = Configuration.getFieldFromId(string);
            Object object = field.getValue(node, nodeModel, null);
            String string2 = "";
            if (object != null) {
                string2 = FieldConverter.toString(object);
            }
            if ((v2 = this.fieldComponents.get(string)) instanceof JLabel) {
                ((JLabel)v2).setText(string2);
                continue;
            }
            ((ChangeAwareTextField)v2).setText(string2);
            ((ChangeAwareComponent)v2).resetChange();
        }
    }

    public List getChange() {
        ArrayList<FieldChange> arrayList = new ArrayList<FieldChange>();
        for (String string : this.fieldComponents.keySet()) {
            Object v2 = this.fieldComponents.get(string);
            if (!(v2 instanceof ChangeAwareComponent) || !((ChangeAwareComponent)v2).hasChanged() || !(v2 instanceof JTextField)) continue;
            String string2 = ((JTextField)v2).getText();
            Field field = Configuration.getFieldFromId(string);
            try {
                Object object = FieldConverter.fromString(string2, field.getDisplayType());
                arrayList.add(new FieldChange(field, object));
            }
            catch (Exception exception) {
                Alert.error(exception.getMessage());
            }
        }
        return arrayList;
    }

    void paintSelectedBars(Graphics2D graphics2D, double d2, double d3) {
        for (BarFormat barFormat : this.selectedFormats) {
            if (barFormat.getMiddle() != null) {
                barFormat.getMiddle().draw(graphics2D, d2, d3, 0.0, d3 / 2.0, this.texture);
            }
            if (barFormat.getStart() != null) {
                barFormat.getStart().draw(graphics2D, d2, d3, 0.0, d3 / 2.0, this.texture);
            }
            if (barFormat.getEnd() == null) continue;
            barFormat.getEnd().draw(graphics2D, d2, d3, 0.0, d3 / 2.0, this.texture);
        }
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        double d2 = dimension.getWidth();
        double d3 = dimension.getHeight();
        this.paintSelectedBars(graphics2D, d2 - 1.0, d3 - 1.0);
        try {
            super.paint(graphics);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string == "text") {
            super.firePropertyChange(string, object, object2);
        }
    }

    public void firePropertyChange(String string, byte by, byte by2) {
    }

    public void firePropertyChange(String string, char c2, char c3) {
    }

    public void firePropertyChange(String string, short s, short s2) {
    }

    public void firePropertyChange(String string, int n2, int n3) {
    }

    public void firePropertyChange(String string, long l2, long l3) {
    }

    public void firePropertyChange(String string, float f2, float f3) {
    }

    public void firePropertyChange(String string, double d2, double d3) {
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }
}

