/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet;

import com.projity.field.Field;
import com.projity.pm.graphic.Renderer;
import com.projity.pm.graphic.graph.GraphParams;
import com.projity.pm.graphic.model.cache.GraphicNode;
import com.projity.pm.graphic.spreadsheet.SpreadSheetParams;
import com.projity.pm.graphic.spreadsheet.SpreadSheetParamsImpl;
import com.projity.pm.graphic.spreadsheet.SpreadSheetUtils;
import com.projity.pm.graphic.spreadsheet.renderer.OfflineRenderer;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.table.TableColumn;

public class SpreadSheetRenderer
extends Renderer {
    protected SpreadSheetParams params;
    private int idColMargin = 2;
    private int colMargin = 2;
    private int idColumnIndex = 0;

    public SpreadSheetRenderer(GraphParams graphParams) {
        super(graphParams);
        this.params = (SpreadSheetParams)graphParams;
    }

    public SpreadSheetRenderer() {
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, -1, -1);
    }

    public void paint(Graphics graphics, int n2, int n3) {
        Object object;
        Object object2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n4 = this.params.getSpreadSheetBounds().y;
        int n5 = this.params.getRowHeight();
        int n6 = 0;
        int n7 = Integer.MAX_VALUE;
        int n8 = 0;
        int n9 = Integer.MAX_VALUE;
        Rectangle rectangle = this.params.getSpreadSheetBounds();
        if (n2 != -1) {
            SpreadSheetParamsImpl.PageInfo pageInfo = this.params.getColPageInfo(n3);
            object2 = this.params.getRowPageInfo(n2);
            n8 = pageInfo.getStart();
            n9 = pageInfo.getEnd();
            n6 = ((SpreadSheetParamsImpl.PageInfo)object2).getStart();
            n7 = ((SpreadSheetParamsImpl.PageInfo)object2).getEnd();
            object = ((SpreadSheetParamsImpl)this.params).getSpreadsheetPrintBounds(n2, n3, false);
            rectangle = new Rectangle(rectangle.x, rectangle.y, ((Rectangle)object).width, ((Rectangle)object).height);
        }
        object2 = this.graphInfo.getCache().getIterator(n6);
        for (int i2 = n6; object2.hasNext() && i2 <= n7; ++i2) {
            object = (GraphicNode)object2.next();
            this.paintRow(graphics2D, i2, n6, n4, n8, n9, (GraphicNode)object, rectangle);
            n4 += n5;
        }
        this.paintColumnHeader(graphics2D, n8, n9, rectangle);
    }

    protected int getColMargin(int n2) {
        return this.idColumnIndex == n2 ? this.idColMargin : this.colMargin;
    }

    protected void paintColumnHeader(Graphics2D graphics2D, int n2, int n3, Rectangle rectangle) {
        int n4 = rectangle.x;
        int n5 = rectangle.y - this.params.getConfiguration().getColumnHeaderHeight();
        Iterator iterator = this.params.getColumnIterator();
        for (int i2 = 0; iterator.hasNext() && i2 <= n3; ++i2) {
            TableColumn tableColumn = (TableColumn)iterator.next();
            if (i2 < n2) continue;
            int n6 = tableColumn.getPreferredWidth() + 2 * this.getColMargin(i2);
            OfflineRenderer offlineRenderer = (OfflineRenderer)tableColumn.getHeaderRenderer();
            if (offlineRenderer != null) {
                JComponent jComponent = (JComponent)offlineRenderer.getComponent(((Field)this.params.getFieldArray().get(i2)).getName(), null, (Field)this.params.getFieldArray().get(i2), this.params);
                boolean bl = jComponent.isOpaque();
                jComponent.setOpaque(false);
                jComponent.setSize(n6, this.params.getConfiguration().getColumnHeaderHeight());
                graphics2D.translate(n4, n5);
                jComponent.doLayout();
                jComponent.print(graphics2D);
                graphics2D.translate(-n4, -n5);
                jComponent.setOpaque(bl);
            }
            graphics2D.draw(new Line2D.Double(n4 += n6, n5, n4, rectangle.getMaxY()));
        }
    }

    protected void paintRow(Graphics2D graphics2D, int n2, int n3, int n4, int n5, int n6, GraphicNode graphicNode, Rectangle rectangle) {
        int n7 = rectangle.x;
        Iterator iterator = this.params.getColumnIterator();
        for (int i2 = 0; iterator.hasNext() && i2 <= n6; ++i2) {
            TableColumn tableColumn = (TableColumn)iterator.next();
            if (i2 < n5) continue;
            Object object = SpreadSheetUtils.getValueAt(graphicNode.getNode(), i2, this.params.getCache(), this.params.getColumnModel(), this.params.getFieldContext());
            Field field = (Field)this.params.getFieldArray().get(i2);
            int n8 = tableColumn.getPreferredWidth();
            int n9 = n8 + 2 * this.getColMargin(i2);
            OfflineRenderer offlineRenderer = (OfflineRenderer)tableColumn.getCellRenderer();
            JComponent jComponent = (JComponent)offlineRenderer.getComponent(object, graphicNode, field, this.params);
            boolean bl = jComponent.isOpaque();
            jComponent.setOpaque(false);
            jComponent.setSize(n8, this.params.getRowHeight());
            graphics2D.translate(n7 + this.getColMargin(i2), n4);
            jComponent.doLayout();
            jComponent.print(graphics2D);
            graphics2D.translate(-n7 - this.getColMargin(i2), -n4);
            jComponent.setOpaque(bl);
            n7 += n9;
        }
        if (n2 != n3) {
            graphics2D.draw(new Line2D.Double(0.0, n4, n7, n4));
        }
    }
}

