/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.task;

import com.projity.association.AssociationFormatParameters;
import com.projity.association.AssociationList;
import com.projity.association.AssociationListFormat;
import com.projity.configuration.CircularDependencyException;
import com.projity.configuration.Configuration;
import com.projity.configuration.Settings;
import com.projity.datatype.Duration;
import com.projity.document.Document;
import com.projity.field.CustomFields;
import com.projity.field.CustomFieldsImpl;
import com.projity.field.Field;
import com.projity.field.FieldContext;
import com.projity.field.FieldParseException;
import com.projity.functor.CollectionVisitor;
import com.projity.functor.ObjectVisitor;
import com.projity.grouping.core.Node;
import com.projity.grouping.core.NodeList;
import com.projity.grouping.core.hierarchy.BelongsToHierarchy;
import com.projity.grouping.core.model.NodeModel;
import com.projity.grouping.core.summaries.DivisionSummaryVisitor;
import com.projity.grouping.core.summaries.LeafWalker;
import com.projity.options.CalculationOption;
import com.projity.options.CalendarOption;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.assignment.HasTimeDistributedData;
import com.projity.pm.assignment.timesheet.UpdatesFromTimesheet;
import com.projity.pm.calendar.HasCalendar;
import com.projity.pm.calendar.WorkCalendar;
import com.projity.pm.costing.HasExpenseType;
import com.projity.pm.criticalpath.CriticalPath;
import com.projity.pm.criticalpath.PredecessorTaskList;
import com.projity.pm.criticalpath.ScheduleWindow;
import com.projity.pm.criticalpath.TaskSchedule;
import com.projity.pm.dependency.Dependency;
import com.projity.pm.dependency.DependencyFormat;
import com.projity.pm.dependency.DependencyService;
import com.projity.pm.dependency.HasDependencies;
import com.projity.pm.dependency.HasDependenciesImpl;
import com.projity.pm.key.HasKey;
import com.projity.pm.key.HasKeyImpl;
import com.projity.pm.resource.Resource;
import com.projity.pm.scheduling.CanBeLeveled;
import com.projity.pm.scheduling.Schedule;
import com.projity.pm.scheduling.ScheduleUtil;
import com.projity.pm.snapshot.Snapshottable;
import com.projity.pm.snapshot.SnapshottableImpl;
import com.projity.pm.task.BelongsToDocument;
import com.projity.pm.task.HasNotes;
import com.projity.pm.task.HasPriority;
import com.projity.pm.task.NormalTask;
import com.projity.pm.task.Project;
import com.projity.pm.task.SubProj;
import com.projity.pm.task.TaskLinkReference;
import com.projity.pm.task.TaskSnapshot;
import com.projity.server.access.ErrorLogger;
import com.projity.server.data.DataObject;
import com.projity.strings.Messages;
import com.projity.util.Alert;
import com.projity.util.DateTime;
import com.projity.util.Environment;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.TruePredicate;

public abstract class Task
implements HasKey,
HasNotes,
HasCalendar,
HasDependencies,
Schedule,
ScheduleWindow,
Snapshottable,
HasTimeDistributedData,
HasPriority,
CustomFields,
BelongsToDocument,
BelongsToHierarchy,
DataObject,
CanBeLeveled,
UpdatesFromTimesheet,
HasExpenseType,
TaskLinkReference {
    static final long serialVersionUID = 786665335611L;
    protected static final double COMPLETE_THRESHOLD = 0.9999;
    transient Project project;
    transient Project owningProject;
    transient TaskSchedule currentSchedule = null;
    protected transient int debugDependencyOrder = -1;
    protected transient TaskSchedule earlySchedule;
    protected transient TaskSchedule lateSchedule;
    protected transient Snapshottable snapshots;
    protected transient HasDependencies dependencies;
    protected String notes = "";
    protected String wbs = "";
    protected boolean markTaskAsMilestone = false;
    protected transient CustomFieldsImpl customFields = new CustomFieldsImpl();
    protected transient HasKeyImpl hasKey;
    protected transient boolean external = false;
    protected transient long projectId = 0L;
    double physicalPercentComplete = 0.0;
    protected long windowEarlyStart = 0L;
    protected long windowEarlyFinish = 0L;
    protected long windowLateStart = 0L;
    protected long windowLateFinish = 0L;
    protected long actualStart = 0L;
    protected long levelingDelay = 0L;
    protected transient int calculationStateCount = 0;
    protected transient boolean markerStatus = false;
    protected int earnedValueMethod = 0;
    protected static Field startFieldInstance = null;
    protected int constraintType = 0;
    protected long deadline = 0L;
    protected int expenseType = 0;
    protected transient boolean inSubproject = false;
    protected transient long lastSavedStart = 0L;
    protected transient long lastSavedFinish = 0L;
    protected transient boolean dirty;
    protected transient long lastSavedParentId = -1L;
    protected transient long lastSavedPosistion = 0L;
    private static Field endFieldInstance = null;
    transient Collection wbsChildrenNodes = null;
    transient Task wbsParentTask = null;
    transient Resource delegatedTo = null;
    private static long millisInWeek = 604800000L;

    public static Field getStartField() {
        if (startFieldInstance == null) {
            startFieldInstance = Configuration.getFieldFromId("Field.start");
        }
        return startFieldInstance;
    }

    public TaskSchedule getCurrentSchedule() {
        return this.currentSchedule;
    }

    public static Field getEndField() {
        if (endFieldInstance == null) {
            endFieldInstance = Configuration.getFieldFromId("Field.finish");
        }
        return endFieldInstance;
    }

    public Task() {
        this(true);
    }

    public Task(boolean bl) {
        this.hasKey = new HasKeyImpl(bl, this);
        this.currentSchedule = new TaskSchedule();
        this.initializeTransientTaskObjects();
    }

    public boolean isReadOnly() {
        return this.isExternal() || this.isSubproject() || this.getOwningProject() != null && this.getOwningProject().isReadOnly();
    }

    protected void initializeTransientTaskObjects() {
        this.currentSchedule.initSerialized(this, 0);
        this.earlySchedule = new TaskSchedule(this, -1);
        this.lateSchedule = new TaskSchedule(this, 1);
        this.snapshots = new SnapshottableImpl(Settings.numBaselines());
        this.dependencies = new HasDependenciesImpl(this);
        this.createSnapshot(CURRENT);
        ((TaskSnapshot)this.getCurrentSnapshot()).setCurrentSchedule(this.currentSchedule);
        this.setLastSavedStart(this.currentSchedule.getStart());
        this.setLastSavedFinish(this.currentSchedule.getFinish());
    }

    protected void initializeTransientTaskObjectsAfterDeserialization() {
        this.earlySchedule = new TaskSchedule(this, -1);
        this.lateSchedule = new TaskSchedule(this, 1);
        this.dependencies = new HasDependenciesImpl(this);
        this.currentSchedule = ((TaskSnapshot)this.getCurrentSnapshot()).getCurrentSchedule();
        this.currentSchedule.initSerialized(this, 0);
        this.setLastSavedStart(this.currentSchedule.getStart());
        this.setLastSavedFinish(this.currentSchedule.getFinish());
    }

    public TaskSnapshot getBaselineSnapshot() {
        return (TaskSnapshot)this.getSnapshot(CalculationOption.getInstance().getEarnedValueBaselineId());
    }

    private TaskSnapshot createSnapshot(Object object) {
        TaskSnapshot taskSnapshot = new TaskSnapshot();
        this.setSnapshot(object, taskSnapshot);
        return taskSnapshot;
    }

    public HasCalendar getHasCalendar() {
        return this;
    }

    public Assignment getBaselineAssignment(Resource resource) {
        TaskSnapshot taskSnapshot = this.getBaselineSnapshot();
        if (taskSnapshot == null) {
            return null;
        }
        return this.getBaselineSnapshot().findAssignment(resource);
    }

    public Assignment getBaselineAssignment(Resource resource, Object object, boolean bl) {
        Assignment assignment;
        TaskSnapshot taskSnapshot = (TaskSnapshot)this.getSnapshot(object);
        if (taskSnapshot == null) {
            if (bl) {
                taskSnapshot = this.createSnapshot(object);
            } else {
                return null;
            }
        }
        if ((assignment = taskSnapshot.findAssignment(resource)) == null && bl) {
            assignment = Assignment.getInstance(this, resource, 1.0, 0);
            taskSnapshot.addAssignment(assignment);
            TaskSchedule taskSchedule = new TaskSchedule(this, 0);
            taskSnapshot.setCurrentSchedule(taskSchedule);
            assignment.setTaskSchedule(taskSchedule);
            assignment.convertToBaselineAssignment(true);
        }
        return assignment;
    }

    public Project getProject() {
        return this.project;
    }

    public Document getDocument() {
        return this.getProject();
    }

    public WorkCalendar getProjectCalendar() {
        return this.project.getWorkCalendar();
    }

    public void connectToProject() {
        this.project.connectTask(this);
    }

    protected boolean isInitialized() {
        return this.getProject() != null && this.getProject().isInitialized();
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public static Closure forProject(Closure closure) {
        return new ObjectVisitor(closure){

            protected final Object getObject(Object object) {
                return ((Task)object).getProject();
            }
        };
    }

    public static Closure forParent(Closure closure) {
        return new ObjectVisitor(closure){

            protected final Object getObject(Object object) {
                return ((Task)object).getProject().getTaskOutline().getHierarchy().getParent((Node)object);
            }
        };
    }

    public static Closure forAllChildren(Closure closure, Predicate predicate) {
        return new CollectionVisitor(closure, predicate){

            protected Collection getCollection(Object object) {
                return ((Task)object).getProject().getTaskOutline().getHierarchy().getChildren((Node)object);
            }
        };
    }

    public static Closure forAllChildren(Closure closure) {
        return Task.forAllChildren(closure, TruePredicate.INSTANCE);
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String string) {
        this.notes = string;
    }

    public double getCustomCost(int n2) {
        return this.customFields.getCustomCost(n2);
    }

    public long getCustomDate(int n2) {
        return this.customFields.getCustomDate(n2);
    }

    public long getCustomDuration(int n2) {
        return this.customFields.getCustomDuration(n2);
    }

    public long getCustomFinish(int n2) {
        return this.customFields.getCustomFinish(n2);
    }

    public boolean getCustomFlag(int n2) {
        return this.customFields.getCustomFlag(n2);
    }

    public double getCustomNumber(int n2) {
        return this.customFields.getCustomNumber(n2);
    }

    public long getCustomStart(int n2) {
        return this.customFields.getCustomStart(n2);
    }

    public String getCustomText(int n2) {
        return this.customFields.getCustomText(n2);
    }

    public void setCustomCost(int n2, double d2) {
        this.customFields.setCustomCost(n2, d2);
    }

    public void setCustomDate(int n2, long l2) {
        this.customFields.setCustomDate(n2, l2);
    }

    public void setCustomDuration(int n2, long l2) {
        this.customFields.setCustomDuration(n2, l2);
    }

    public void setCustomFinish(int n2, long l2) {
        this.customFields.setCustomFinish(n2, l2);
    }

    public void setCustomFlag(int n2, boolean bl) {
        this.customFields.setCustomFlag(n2, bl);
    }

    public void setCustomNumber(int n2, double d2) {
        this.customFields.setCustomNumber(n2, d2);
    }

    public void setCustomStart(int n2, long l2) {
        this.customFields.setCustomStart(n2, l2);
    }

    public void setCustomText(int n2, String string) {
        this.customFields.setCustomText(n2, string);
    }

    public long getStart() {
        return this.currentSchedule.getStart();
    }

    public void setStart(long l2, FieldContext fieldContext) {
        if (this.getActualStart() != 0L) {
            return;
        }
        l2 = CalendarOption.getInstance().makeValidStart(l2, false);
        if (l2 != this.getStart() && !Environment.isImporting()) {
            long l3 = this.getProject().getStart();
            if (l3 > l2) {
                if (!Alert.okCancel(Messages.getString("Message.allowTaskStartBeforeProjectStart"))) {
                    return;
                }
                this.setScheduleConstraint(5, l2);
            } else {
                this.setScheduleConstraint(4, l2);
            }
        }
    }

    public void setStart(long l2) {
        this.setStart(l2, null);
    }

    public long getEnd() {
        return this.currentSchedule.getFinish();
    }

    public void setEnd(long l2) {
        this.setEnd(l2, null);
    }

    public void setEnd(long l2, FieldContext fieldContext) {
        if (l2 != this.getEnd()) {
            this.getCurrentSchedule().setEnd(l2);
        }
    }

    public long getDependencyStart() {
        return this.currentSchedule.getRemainingDependencyDate();
    }

    public void setDependencyStart(long l2) {
        this.currentSchedule.setRemainingDependencyDate(l2);
    }

    public abstract void setRawDuration(long var1);

    public long getRawDuration() {
        return this.currentSchedule.getRawDuration();
    }

    public void clearDuration() {
        this.setRawDuration(0L);
    }

    public WorkCalendar getEffectiveWorkCalendar() {
        return null;
    }

    public boolean isMilestone() {
        return false;
    }

    public boolean isSubproject() {
        return false;
    }

    public Collection getWbsChildrenNodes() {
        return this.wbsChildrenNodes;
    }

    public void setWbsChildrenNodes(Collection collection) {
        this.wbsChildrenNodes = collection;
    }

    public List getWbsChildrenTasks() {
        List list = (List)this.getWbsChildrenNodes();
        return NodeList.nodeListToImplList(list);
    }

    public Task getWbsParentTask() {
        return this.wbsParentTask;
    }

    public void setWbsParent(Task task) {
        this.wbsParentTask = task;
    }

    public boolean wbsDescendentOf(Task task) {
        if (this == task) {
            return true;
        }
        Task task2 = this.getWbsParentTask();
        if (task2 == null) {
            return false;
        }
        return task2.wbsDescendentOf(task);
    }

    public boolean isParent() {
        return this.isWbsParent();
    }

    public boolean isWbsParent() {
        if (this.wbsChildrenNodes == null || this.wbsChildrenNodes.size() == 0) {
            return false;
        }
        Iterator iterator = this.wbsChildrenNodes.iterator();
        while (iterator.hasNext()) {
            Object object = ((Node)iterator.next()).getImpl();
            if (!(object instanceof Task)) continue;
            return true;
        }
        return false;
    }

    public String getWbsParentName() {
        if (this.wbsParentTask == null) {
            return "";
        }
        return this.wbsParentTask.getName();
    }

    public void arrangeTask(Collection collection, boolean bl, int n2) {
        if (this.markerStatus == bl) {
            return;
        }
        if (Environment.isImporting() && n2 >= 1000) {
            throw new RuntimeException(CircularDependencyException.RUNTIME_EXCEPTION_TEXT);
        }
        Iterator iterator = this.getPredecessorList().iterator();
        Task task = this.getWbsParentTask();
        if (task != null) {
            task.arrangeTask(collection, bl, n2 + 1);
        }
        this.markerStatus = bl;
        while (iterator.hasNext()) {
            Dependency dependency = (Dependency)iterator.next();
            if (dependency.isDisabled()) continue;
            Task task2 = (Task)dependency.getPredecessor();
            task2.arrangeTask(collection, bl, n2 + 1);
            task2.arrangeChildren(collection, bl, n2);
        }
        PredecessorTaskList.TaskReference taskReference = new PredecessorTaskList.TaskReference(this);
        collection.add(taskReference);
        if (this.isWbsParent()) {
            taskReference.setParentBegin();
            this.arrangeChildren(collection, bl, n2);
            taskReference = new PredecessorTaskList.TaskReference(this);
            taskReference.setParentEnd();
            collection.add(taskReference);
        }
    }

    private void arrangeChildren(Collection collection, boolean bl, int n2) {
        Collection collection2 = this.getWbsChildrenNodes();
        if (collection2 != null) {
            Iterator iterator = collection2.iterator();
            while (iterator.hasNext()) {
                Object object = ((Node)iterator.next()).getImpl();
                if (!(object instanceof Task)) continue;
                Task task = (Task)object;
                task.arrangeTask(collection, bl, n2 + 1);
            }
        }
    }

    private boolean dependsOn(Task task, Task task2, HashSet hashSet, String string) {
        Task task3;
        if (hashSet.contains(this)) {
            return false;
        }
        hashSet.add(this);
        if (this == task) {
            if (string != null) {
                System.out.println("Circular: \n" + string);
            }
            return true;
        }
        if (string != null) {
            string = string + this.getId() + ": " + this.getName() + '\n';
        }
        for (Dependency dependency : this.getPredecessorList()) {
            if (dependency.isDisabled() || !(task3 = (Task)dependency.getPredecessor()).dependsOn(task, task2, hashSet, string == null ? null : string + "Pred-")) continue;
            return true;
        }
        Task task4 = this.getWbsParentTask();
        if (task.getWbsParentTask() != task4 && task4 != null && task4.dependsOn(task, task2, hashSet, string == null ? null : string + "Parent- ")) {
            return true;
        }
        Collection collection = this.getWbsChildrenNodes();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object object = ((Node)iterator.next()).getImpl();
                if (!(object instanceof Task)) continue;
                Task task5 = (Task)object;
                for (Dependency dependency : task5.getPredecessorList()) {
                    if (dependency.isDisabled() || (task3 = (Task)dependency.getPredecessor()).wbsDescendentOf(this) || !task3.dependsOn(task, task2, hashSet, string == null ? null : string + "pred-child " + task5.getId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isAncestorOrDescendent(Task task) {
        return this.wbsDescendentOf(task) || task.wbsDescendentOf(this);
    }

    public boolean dependsOn(HasDependencies hasDependencies) {
        Task task = (Task)hasDependencies;
        if (this.isAncestorOrDescendent(task)) {
            return true;
        }
        HashSet hashSet = new HashSet();
        return this.dependsOn((Task)hasDependencies, this, hashSet, "");
    }

    public Date getCreated() {
        return this.hasKey.getCreated();
    }

    public long getId() {
        return this.hasKey.getId();
    }

    public void setId(long l2) {
        this.hasKey.setId(l2);
    }

    public void setCreated(Date date) {
        this.hasKey.setCreated(date);
    }

    public String getPredecessors() {
        return AssociationListFormat.getInstance(DependencyFormat.getInstance(AssociationFormatParameters.getInstance(this, true, Configuration.getFieldFromId("Field.id"), false, true))).format(this.getPredecessorList());
    }

    public String getSuccessors() {
        return AssociationListFormat.getInstance(DependencyFormat.getInstance(AssociationFormatParameters.getInstance(this, false, Configuration.getFieldFromId("Field.id"), false, true))).format(this.getSuccessorList());
    }

    public String getUniqueIdPredecessors() {
        return AssociationListFormat.getInstance(DependencyFormat.getInstance(AssociationFormatParameters.getInstance(this, true, Configuration.getFieldFromId("Field.uniqueId"), false, true))).format(this.getPredecessorList());
    }

    public String getUniqueIdSuccessors() {
        return AssociationListFormat.getInstance(DependencyFormat.getInstance(AssociationFormatParameters.getInstance(this, false, Configuration.getFieldFromId("Field.uniqueId"), false, true))).format(this.getSuccessorList());
    }

    public String getWbsPredecessors() {
        return AssociationListFormat.getInstance(DependencyFormat.getInstance(AssociationFormatParameters.getInstance(this, true, Configuration.getFieldFromId("Field.wbs"), true, true))).format(this.getPredecessorList());
    }

    public String getWbsSuccessors() {
        return AssociationListFormat.getInstance(DependencyFormat.getInstance(AssociationFormatParameters.getInstance(this, false, Configuration.getFieldFromId("Field.wbs"), true, true))).format(this.getSuccessorList());
    }

    public void setPredecessors(String string) throws FieldParseException {
        this.getPredecessorList().setAssociations(string, DependencyFormat.getInstance(AssociationFormatParameters.getInstance(this, true, Configuration.getFieldFromId("Field.id"), false, true)));
    }

    public void setSuccessors(String string) throws FieldParseException {
        this.getSuccessorList().setAssociations(string, DependencyFormat.getInstance(AssociationFormatParameters.getInstance(this, false, Configuration.getFieldFromId("Field.id"), false, true)));
    }

    public void setUniqueIdPredecessors(String string) throws FieldParseException {
        this.getPredecessorList().setAssociations(string, DependencyFormat.getInstance(AssociationFormatParameters.getInstance(this, true, Configuration.getFieldFromId("Field.uniqueId"), false, true)));
    }

    public void setUniqueIdSuccessors(String string) throws FieldParseException {
        this.getSuccessorList().setAssociations(string, DependencyFormat.getInstance(AssociationFormatParameters.getInstance(this, false, Configuration.getFieldFromId("Field.uniqueId"), false, true)));
    }

    public String getWbs() {
        return this.wbs;
    }

    public void setWbs(String string) {
        this.wbs = string;
    }

    public long getUniqueId() {
        return this.hasKey.getUniqueId();
    }

    public void setUniqueId(long l2) {
        this.hasKey.setUniqueId(l2);
    }

    public String getName() {
        return this.hasKey.getName();
    }

    public void setName(String string) {
        this.hasKey.setName(string);
    }

    public String toString() {
        if (this.getName() == null) {
            return "<null name>";
        }
        return this.getName();
    }

    public String getName(FieldContext fieldContext) {
        return this.hasKey.getName(fieldContext);
    }

    public boolean isNormal() {
        return false;
    }

    public boolean isCritical() {
        return false;
    }

    public boolean isOrWasCritical() {
        if (this.isCritical()) {
            return true;
        }
        if (this.currentSchedule.isForward()) {
            return this.getEnd() >= this.getLateFinish();
        }
        return this.getStart() <= this.getEarlyStart();
    }

    public boolean isSummary() {
        return this.isWbsParent();
    }

    public boolean isAssignment() {
        return false;
    }

    public double getPhysicalPercentComplete() {
        return this.physicalPercentComplete;
    }

    public void setPhysicalPercentComplete(double d2) {
        this.physicalPercentComplete = d2;
    }

    public void markTaskAsNeedingRecalculation() {
        int n2 = this.project.getCalculationStateCount() + 1;
        this.setCalculationStateCount(n2);
    }

    void markAllDependentTasksAsNeedingRecalculation(boolean bl) {
        Task task;
        Iterator iterator;
        if (bl) {
            this.markTaskAsNeedingRecalculation();
        }
        if (!(iterator = this.getSuccessorList().iterator()).hasNext()) {
            this.getProject().getSchedulingAlgorithm().markBoundsAsDirty();
        } else {
            while (iterator.hasNext()) {
                task = (Task)((Dependency)iterator.next()).getSuccessor();
                task.markTaskAsNeedingRecalculation();
            }
        }
        for (task = this.getWbsParentTask(); task != null; task = task.getWbsParentTask()) {
            task.markTaskAsNeedingRecalculation();
        }
        Collection collection = this.getWbsChildrenNodes();
        if (collection != null) {
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                Object object = ((Node)iterator2.next()).getImpl();
                if (!(object instanceof Task)) continue;
                ((Task)object).markTaskAsNeedingRecalculation();
            }
        }
    }

    void cleanUp(Object object, boolean bl, boolean bl2, boolean bl3) {
        this.markAllDependentTasksAsNeedingRecalculation(false);
        this.project.removeStartSentinelDependency(this);
        this.project.removeEndSentinelDependency(this);
        LinkedList linkedList = new LinkedList();
        DependencyService.getInstance().remove((Collection)this.getPredecessorList(), linkedList);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            DependencyService.getInstance().remove((Dependency)iterator.next(), object, bl2);
        }
        linkedList.clear();
        DependencyService.getInstance().remove((Collection)this.getSuccessorList(), linkedList);
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            DependencyService.getInstance().remove((Dependency)iterator.next(), object, bl2);
        }
    }

    public void recalculate(Object object) {
        ((Project)this.getDocument()).updateScheduling(object, this, 0, Task.getEndField());
    }

    public void recalculateLater(final Object object) {
        this.markTaskAsNeedingRecalculation();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Task.this.recalculate(object);
            }
        });
    }

    public long getActualStart() {
        return this.actualStart;
    }

    public abstract void setActualStart(long var1);

    public long getActualFinish() {
        if (this.getPercentComplete() == 1.0) {
            return this.getEnd();
        }
        return 0L;
    }

    public void setActualFinish(long l2) {
        long l3 = this.getActualFinish();
        if (l2 == l3) {
            return;
        }
        this.setEnd(l2);
        this.setPercentComplete(1.0);
    }

    public boolean isZeroDuration() {
        return Duration.millis(this.getRawDuration()) == 0L;
    }

    public double getPercentComplete() {
        boolean bl = this.isWbsParent();
        DivisionSummaryVisitor divisionSummaryVisitor = ScheduleUtil.percentCompleteClosureInstance(bl);
        Document document = this.getMasterDocument() == null ? this.getProject() : this.getMasterDocument();
        NodeModel nodeModel = ((Project)document).getTaskOutline();
        if (this.isWbsParent()) {
            try {
                LeafWalker.recursivelyTreatBranch(nodeModel, this, (Closure)divisionSummaryVisitor);
            }
            catch (NullPointerException nullPointerException) {
                ErrorLogger.logOnce("getPercentComplete", "getPercentComplete() Task: " + this + " Project " + this.project, nullPointerException);
                return 0.0;
            }
        } else {
            CollectionUtils.forAllDo(((NormalTask)this).getAssignments(), divisionSummaryVisitor);
        }
        double d2 = divisionSummaryVisitor.getValue();
        if (d2 >= 0.9999) {
            d2 = 1.0;
        }
        return d2;
    }

    public boolean inProgress() {
        double d2 = this.getPercentComplete();
        return d2 > 0.0 && d2 < 1.0;
    }

    private long calcTimeToStartFromNow() {
        return this.getStart() - System.currentTimeMillis();
    }

    public boolean isStartingWithinOneWeek() {
        if (this.getPercentComplete() > 0.0) {
            return false;
        }
        long l2 = this.calcTimeToStartFromNow();
        return l2 > 0L && l2 < millisInWeek;
    }

    public boolean isStartingWithinTwoWeeks() {
        if (this.getPercentComplete() > 0.0) {
            return false;
        }
        long l2 = this.calcTimeToStartFromNow();
        return l2 > 0L && l2 < 2L * millisInWeek;
    }

    public boolean isLateStarting() {
        if (this.getPercentComplete() > 0.0) {
            return false;
        }
        long l2 = this.calcTimeToStartFromNow();
        return l2 < 0L;
    }

    public boolean isComplete() {
        return this.getPercentComplete() >= 1.0;
    }

    public boolean isUnstarted() {
        return this.getPercentComplete() == 0.0;
    }

    public long getDurationMillis() {
        return Duration.millis(this.getDuration());
    }

    public long getActualDuration() {
        long l2 = this.getDuration();
        long l3 = Math.round(this.getPercentComplete() * (double)Duration.millis(l2));
        return Duration.useTimeUnitOfInNone(l3, l2);
    }

    public void setActualDuration(long l2) {
        if ((l2 = DateTime.closestDate(Duration.millis(l2))) == Duration.millis(this.getActualDuration())) {
            return;
        }
        long l3 = this.getEffectiveWorkCalendar().add(this.getStart(), l2, true);
        this.setStop(l3);
    }

    public long getRemainingDuration() {
        long l2 = this.getActualDuration();
        long l3 = this.getDurationMillis() - Duration.millis(l2);
        return Duration.useTimeUnitOfInNone(l3, l2);
    }

    public void setRemainingDuration(long l2) {
        l2 = DateTime.closestDate(Duration.millis(l2));
        this.setActualDuration(this.getDurationMillis() - l2);
    }

    public Object clone() {
        try {
            Task task = (Task)super.clone();
            this._cloneTo(task);
            return task;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void cleanClone() {
        this.owningProject = null;
        this.project = null;
    }

    private void _cloneTo(Task task) {
        task.hasKey = new HasKeyImpl(this.isLocal() && Environment.getStandAlone(), task);
        task.setName(new String(this.getName()));
        task.setRawDuration(this.getRawDuration());
        task.earlySchedule = (TaskSchedule)this.earlySchedule.cloneWithTask(task);
        task.lateSchedule = (TaskSchedule)this.lateSchedule.cloneWithTask(task);
        task.customFields = (CustomFieldsImpl)this.customFields.clone();
        task.snapshots = (Snapshottable)((SnapshottableImpl)this.snapshots).cloneWithTask(task);
        task.currentSchedule = ((TaskSnapshot)task.getCurrentSnapshot()).getCurrentSchedule();
        task.notes = new String(this.notes);
        task.wbs = new String(this.wbs);
        task.wbsChildrenNodes = null;
        task.wbsParentTask = null;
        task.dependencies = new HasDependenciesImpl(task);
        task.currentSchedule.copyDatesAfterClone(this.currentSchedule);
        task.setDirty(true);
    }

    public void cloneTo(Task task) {
        task.project = this.project;
        task.owningProject = this.owningProject;
        task.debugDependencyOrder = this.debugDependencyOrder;
        task.markTaskAsMilestone = this.markTaskAsMilestone;
        task.external = this.external;
        task.projectId = this.projectId;
        task.physicalPercentComplete = this.physicalPercentComplete;
        task.windowEarlyStart = this.windowEarlyStart;
        task.windowEarlyFinish = this.windowEarlyFinish;
        task.windowLateStart = this.windowLateStart;
        task.windowLateFinish = this.windowLateFinish;
        task.actualStart = this.actualStart;
        task.levelingDelay = this.levelingDelay;
        task.calculationStateCount = this.calculationStateCount;
        task.markerStatus = this.markerStatus;
        task.earnedValueMethod = this.earnedValueMethod;
        task.constraintType = this.constraintType;
        task.deadline = this.deadline;
        task.expenseType = this.expenseType;
        task.inSubproject = this.inSubproject;
        task.lastSavedStart = this.lastSavedStart;
        task.lastSavedFinish = this.lastSavedFinish;
        task.dirty = this.dirty;
        task.delegatedTo = this.delegatedTo;
        this._cloneTo(task);
    }

    public long getSplitDuration() {
        long l2 = this.getResume();
        if (l2 == 0L) {
            return 0L;
        }
        return this.getEffectiveWorkCalendar().compare(l2, this.getStop(), false);
    }

    public int getConstraintType() {
        return this.constraintType;
    }

    public void setConstraintType(int n2) throws FieldParseException {
        int n3 = this.makeValidConstraintType(n2);
        if (n3 != n2) {
            throw new FieldParseException(Messages.getString("Message.parentConstraintType"));
        }
        this.setRawConstraintType(n2);
        long l2 = this.getConstraintDate();
        if (!this.isDatelessConstraintType() && l2 < 432000000L) {
            this.setConstraintDate(this.getEffectiveWorkCalendar().adjustInsideCalendar(DateTime.midnightToday(), false));
        }
    }

    public void setRawConstraintType(int n2) {
        long l2 = this.getConstraintDate();
        this.clearDateConstraints();
        this.setScheduleConstraint(n2, l2);
    }

    public long getWindowEarlyStart() {
        return this.windowEarlyStart;
    }

    public void setWindowEarlyStart(long l2) {
        this.windowEarlyStart = l2;
    }

    public long getWindowEarlyFinish() {
        return this.windowEarlyFinish;
    }

    public void setWindowEarlyFinish(long l2) {
        this.windowEarlyFinish = l2;
    }

    public long getWindowLateFinish() {
        return this.windowLateFinish;
    }

    public void setWindowLateFinish(long l2) {
        this.windowLateFinish = l2;
    }

    public long getWindowLateStart() {
        return this.windowLateStart;
    }

    public void setWindowLateStart(long l2) {
        this.windowLateStart = l2;
    }

    public void setMustStartOn(long l2) {
        this.setWindowEarlyStart(l2);
        this.setWindowLateStart(l2);
    }

    public void setMustFinishOn(long l2) {
        this.setWindowEarlyFinish(l2);
        this.setWindowLateFinish(l2);
    }

    public void setFinishNoEarlierThan(long l2) {
        this.setWindowEarlyFinish(l2);
    }

    public void setFinishNoLaterThan(long l2) {
        this.setWindowLateFinish(l2);
        this.setWindowEarlyFinish(0L);
    }

    public void setStartNoEarlierThan(long l2) {
        this.setWindowEarlyStart(l2);
        this.setWindowLateStart(0L);
    }

    public void setStartNoLaterThan(long l2) {
        this.setWindowLateStart(l2);
        this.setWindowEarlyStart(0L);
    }

    public long getEarlyFinish() {
        return this.earlySchedule.getFinish();
    }

    public long getEarlyStart() {
        return this.earlySchedule.getStart();
    }

    public long getLateFinish() {
        return this.lateSchedule.getFinish();
    }

    public long getLateStart() {
        return this.lateSchedule.getStart();
    }

    public final boolean isReverseScheduled() {
        if (this.project.isForward()) {
            return this.constraintType == 1;
        }
        return this.constraintType == 0;
    }

    protected final boolean isDatelessConstraintType() {
        return this.constraintType == 1 || this.constraintType == 0;
    }

    private void clearDateConstraints() {
        this.setWindowEarlyStart(0L);
        this.setWindowLateStart(0L);
        this.setWindowEarlyFinish(0L);
        this.setWindowLateFinish(0L);
    }

    boolean validateConstraints() {
        long l2 = 864000000L;
        if (!this.isDatelessConstraintType() && this.windowEarlyStart < l2 && this.windowEarlyFinish < l2 && this.windowLateStart < l2 && this.windowLateFinish < l2) {
            this.setConstraintDate(0L);
            ErrorLogger.log("Repairing invalid constraints " + this.getId() + " " + this.getName());
            this.setDirty(true);
            return true;
        }
        return false;
    }

    public void setScheduleConstraint(int n2, long l2) {
        this.constraintType = n2;
        if (n2 == 6) {
            this.setFinishNoEarlierThan(l2);
        } else if (n2 == 7) {
            this.setFinishNoLaterThan(l2);
        } else if (n2 == 4) {
            this.setStartNoEarlierThan(l2);
        } else if (n2 == 5) {
            this.setStartNoLaterThan(l2);
        } else if (n2 == 2) {
            this.setMustStartOn(l2);
        } else if (n2 == 3) {
            this.setMustFinishOn(l2);
        } else {
            this.clearDateConstraints();
        }
    }

    public void setScheduleConstraintAndUpdate(int n2, long l2) {
        this.setScheduleConstraint(n2, l2);
        this.getDocument().getObjectEventManager().fireUpdateEvent((Object)this, (Object)this, Configuration.getFieldFromId("Field.constraintType"));
    }

    public void setConstraintDate(long l2) {
        if (l2 == 0L) {
            this.clearDateConstraints();
            this.constraintType = this.getProject() == null ? 0 : this.getProject().getDefaultConstraintType();
        } else {
            l2 = this.getEffectiveWorkCalendar().adjustInsideCalendar(l2, false);
        }
        this.setScheduleConstraint(this.constraintType, l2);
    }

    public long getConstraintDate() {
        if (this.constraintType == 6) {
            return this.getWindowEarlyFinish();
        }
        if (this.constraintType == 7) {
            return this.getWindowLateFinish();
        }
        if (this.constraintType == 4) {
            return this.getWindowEarlyStart();
        }
        if (this.constraintType == 5) {
            return this.getWindowLateStart();
        }
        if (this.constraintType == 2) {
            return this.getWindowEarlyStart();
        }
        if (this.constraintType == 3) {
            return this.getWindowEarlyFinish();
        }
        return 0L;
    }

    public boolean isReadOnlyConstraintDate(FieldContext fieldContext) {
        return this.getConstraintType() == 1 || this.getConstraintType() == 0;
    }

    public final long getTotalSlack() {
        return this.getEffectiveWorkCalendar().compare(this.getLateFinish(), this.getEarlyFinish(), false);
    }

    public final long getStartSlack() {
        return this.getEffectiveWorkCalendar().compare(this.getLateStart(), this.getEarlyStart(), false);
    }

    public final long getFinishSlack() {
        return this.getEffectiveWorkCalendar().compare(this.getLateFinish(), this.getEarlyFinish(), false);
    }

    private static long calcFreeSlack(Dependency dependency) {
        ScheduleWindow scheduleWindow = (ScheduleWindow)((Object)dependency.getPredecessor());
        ScheduleWindow scheduleWindow2 = (ScheduleWindow)((Object)dependency.getSuccessor());
        long l2 = 0L;
        WorkCalendar workCalendar = dependency.getEffectiveWorkCalendar();
        if (dependency.getDependencyType() == 1) {
            l2 = workCalendar.compare(workCalendar.add(scheduleWindow2.getEarlyStart(), -dependency.getLeadValue(), true), scheduleWindow.getEarlyFinish(), false);
        } else if (dependency.getDependencyType() == 0) {
            l2 = workCalendar.compare(workCalendar.add(scheduleWindow2.getEarlyFinish(), -dependency.getLeadValue(), true), scheduleWindow.getEarlyFinish(), false);
        } else if (dependency.getDependencyType() == 3) {
            l2 = workCalendar.compare(workCalendar.add(scheduleWindow2.getEarlyStart(), -dependency.getLeadValue(), true), scheduleWindow.getEarlyStart(), false);
        } else if (dependency.getDependencyType() == 2) {
            l2 = workCalendar.compare(workCalendar.add(scheduleWindow2.getEarlyFinish(), -dependency.getLeadValue(), true), scheduleWindow.getEarlyStart(), false);
        }
        return l2;
    }

    public long getFreeSlack() {
        long l2 = this.getTotalSlack();
        for (Dependency dependency : this.getSuccessorList()) {
            l2 = Math.min(l2, Task.calcFreeSlack(dependency));
        }
        return l2;
    }

    public AssociationList getPredecessorList() {
        return this.dependencies.getPredecessorList();
    }

    public AssociationList getSuccessorList() {
        return this.dependencies.getSuccessorList();
    }

    public AssociationList getDependencyList(boolean bl) {
        return this.dependencies.getDependencyList(bl);
    }

    public long calcOffsetFrom(long l2, long l3, boolean bl, boolean bl2, boolean bl3) {
        throw new RuntimeException("calcOffsetFrom should not be called in ScheduleWindow");
    }

    public long getElapsedDuration() {
        return Math.round((double)this.getEffectiveWorkCalendar().compare(this.getEnd(), this.getStart(), true) * CalendarOption.getInstance().getFractionOfDayThatIsWorking());
    }

    public long getDeadline() {
        return this.deadline;
    }

    public void setDeadline(long l2) {
        if (l2 != 0L) {
            l2 = CalendarOption.getInstance().makeValidEnd(l2, false);
        }
        this.deadline = l2;
    }

    public boolean isMarkTaskAsMilestone() {
        return this.markTaskAsMilestone;
    }

    public void setMarkTaskAsMilestone(boolean bl) {
        this.markTaskAsMilestone = bl;
    }

    public int getEarnedValueMethod() {
        return this.earnedValueMethod;
    }

    public void setEarnedValueMethod(int n2) {
        this.earnedValueMethod = n2;
    }

    public boolean updateProjectTask(long l2, boolean bl, boolean bl2) {
        long l3 = this.getStart();
        long l4 = this.getEnd();
        long l5 = this.getStop();
        boolean bl3 = false;
        if (bl) {
            if (bl2) {
                if (l5 != l4) {
                    this.setStop(l2);
                    bl3 = true;
                }
            } else if (l2 >= l4) {
                this.setPercentComplete(1.0);
                bl3 = true;
            }
        } else if (l2 > l3) {
            this.moveRemainingToDate(l2);
            bl3 = true;
        }
        if (bl3) {
            this.recalculate(this);
            this.setDirty(true);
        }
        return bl3;
    }

    public final int getCalculationStateCount() {
        return this.calculationStateCount;
    }

    public final void setCalculationStateCount(int n2) {
        this.calculationStateCount = n2;
    }

    public void updateEndSentinel() {
        if (this.getSuccessorList().isEmpty()) {
            this.project.addEndSentinelDependency(this);
        } else {
            this.project.removeEndSentinelDependency(this);
        }
    }

    public void updateStartSentinel() {
        if (this.getPredecessorList().isEmpty()) {
            this.project.addStartSentinelDependency(this);
        } else {
            this.project.removeStartSentinelDependency(this);
        }
    }

    public final TaskSchedule getEarlySchedule() {
        return this.earlySchedule;
    }

    public final TaskSchedule getLateSchedule() {
        return this.lateSchedule;
    }

    public final TaskSchedule getSchedule(int n2) {
        if (n2 == 0) {
            return this.currentSchedule;
        }
        if (n2 == -1) {
            return this.earlySchedule;
        }
        return this.lateSchedule;
    }

    public boolean isJustModified() {
        if (this.project.getSchedulingAlgorithm() == null) {
            return false;
        }
        return this.calculationStateCount + 3 >= this.project.getSchedulingAlgorithm().getCalculationStateCount();
    }

    public abstract boolean hasDuration();

    public final void setMarkerStatus(boolean bl) {
        this.markerStatus = bl;
    }

    public void setForward(boolean bl) {
        this.getCurrentSchedule().setForward(bl);
        this.restrictToValidConstraintType();
    }

    void restrictToValidConstraintType() {
        this.setRawConstraintType(this.makeValidConstraintType(this.getConstraintType()));
    }

    protected int makeValidConstraintType(int n2) {
        if (this.isWbsParent()) {
            if (n2 == 7 || n2 == 4) {
                return n2;
            }
            return this.project.getDefaultConstraintType();
        }
        return n2;
    }

    public static Predicate instanceofPredicate() {
        return new Predicate(){

            public boolean evaluate(Object object) {
                return object instanceof Task;
            }
        };
    }

    public void invalidateSchedules() {
        this.earlySchedule.invalidate();
        this.lateSchedule.invalidate();
    }

    public Document getMasterDocument() {
        if (this.getProject().getSchedulingAlgorithm() == null) {
            return null;
        }
        return this.getProject().getSchedulingAlgorithm().getMasterDocument();
    }

    public String getTaskAndProjectName() {
        Project project = this.getOwningProject();
        if (project == null) {
            project = this.getProject();
        }
        return this.getName() + " (" + project.getName() + ")";
    }

    public String getSubprojectFile() {
        return null;
    }

    public boolean fieldHideSubprojectFile(FieldContext fieldContext) {
        return true;
    }

    public void setSubprojectFile(String string) {
    }

    public boolean isSubprojectReadOnly() {
        return false;
    }

    public boolean fieldHideSubprojectReadOnly(FieldContext fieldContext) {
        return true;
    }

    public long getParentId(int n2) {
        NodeModel nodeModel = this.project.getTaskOutline(n2);
        if (nodeModel == null) {
            return 0L;
        }
        Node node = nodeModel.getParent(nodeModel.search(this));
        Object object = node.getImpl();
        if (object != null && object instanceof HasKey) {
            return ((HasKey)object).getId();
        }
        return 0L;
    }

    public int getOutlineLevel(int n2) {
        NodeModel nodeModel = this.project.getTaskOutline(n2);
        if (nodeModel == null) {
            return 0;
        }
        Node node = nodeModel.getParent(nodeModel.search(this));
        return nodeModel.getHierarchy().getLevel(node);
    }

    public int getOutlineLevel() {
        return this.getOutlineLevel(0);
    }

    public final int getDebugDependencyOrder() {
        return this.debugDependencyOrder;
    }

    public final void setDebugDependencyOrder(int n2) {
        this.debugDependencyOrder = n2;
    }

    public final long getLevelingDelay() {
        return this.levelingDelay;
    }

    public final void setLevelingDelay(long l2) {
        this.levelingDelay = l2;
    }

    public CustomFields getCustomFields() {
        return this.customFields;
    }

    public void updateCachedDuration() {
        this.setRawDuration(this.getDuration());
    }

    public boolean isDirty() {
        return this.dirty || this.getStart() != this.getLastSavedStart() || this.getEnd() != this.getLastSavedFinish();
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
        if (!bl) {
            this.setLastSavedStart(this.currentSchedule.getStart());
            this.setLastSavedFinish(this.currentSchedule.getFinish());
        }
        if (bl && this.project != null) {
            this.project.setGroupDirty(true);
        }
    }

    public boolean isMissedDeadline() {
        if (this.deadline == 0L) {
            return false;
        }
        return this.deadline < this.getEnd();
    }

    public final boolean isExternal() {
        return this.external;
    }

    public final void setExternal(boolean bl) {
        this.external = bl;
    }

    public final long getProjectId() {
        return this.projectId;
    }

    public final void setProjectId(long l2) {
        this.projectId = l2;
    }

    public Project getRootProject() {
        Task task = this.getWbsParentTask();
        if (task == null) {
            return this.getProject();
        }
        return task.getRootProject();
    }

    public Project getEnclosingProject() {
        if (this.isSubproject()) {
            return ((SubProj)((Object)this)).getSubproject();
        }
        Task task = this.getWbsParentTask();
        if (task == null) {
            return this.getProject();
        }
        return task.getEnclosingProject();
    }

    public SubProj getEnclosingSubproject() {
        Task task = this.getWbsParentTask();
        if (task == null) {
            return null;
        }
        if (task.isSubproject()) {
            return (SubProj)((Object)task);
        }
        return task.getEnclosingSubproject();
    }

    public Node getEnclosingSubprojectNode() {
        SubProj subProj = this.getEnclosingSubproject();
        if (subProj == null) {
            return null;
        }
        return ((Task)((Object)subProj)).getProject().getTaskOutline().search(subProj);
    }

    public boolean liesInSubproject() {
        Task task = this.getWbsParentTask();
        if (task == null) {
            return false;
        }
        if (task.isSubproject()) {
            return true;
        }
        return task.liesInSubproject();
    }

    public final boolean isInSubproject() {
        return this.inSubproject;
    }

    public final void setInSubproject(boolean bl) {
        this.inSubproject = bl;
    }

    public final Project getOwningProject() {
        return this.owningProject;
    }

    public final void setOwningProject(Project project) {
        this.owningProject = project;
    }

    public void copyScheduleTo(Task task) {
        task.getCurrentSchedule().setStart(this.getCurrentSchedule().getStart());
        task.getCurrentSchedule().setFinish(this.getCurrentSchedule().getFinish());
        task.setRawDuration(this.getDuration());
    }

    protected void setAllSchedules(long l2, long l3) {
        this.getCurrentSchedule().setStart(l2);
        this.getCurrentSchedule().setFinish(l3);
        this.getEarlySchedule().setStart(l2);
        this.getEarlySchedule().setFinish(l3);
        this.getLateSchedule().setStart(l2);
        this.getLateSchedule().setFinish(l3);
    }

    public void setAllSchedulesToCurrentDates() {
        long l2 = this.getCurrentSchedule().getStart();
        long l3 = this.getCurrentSchedule().getFinish();
        this.setAllSchedules(l2, l3);
    }

    public boolean isAssignable() {
        return !this.isReadOnly();
    }

    public final long getLastSavedFinish() {
        return this.lastSavedFinish;
    }

    public final void setLastSavedFinish(long l2) {
        this.lastSavedFinish = l2;
    }

    public final long getLastSavedStart() {
        return this.lastSavedStart;
    }

    public final void setLastSavedStart(long l2) {
        this.lastSavedStart = l2;
    }

    public final long getLastSavedParentId() {
        return this.lastSavedParentId;
    }

    public final void setLastSavedParentId(long l2) {
        this.lastSavedParentId = l2;
    }

    public final long getLastSavedPosistion() {
        return this.lastSavedPosistion;
    }

    public final void setLastSavedPosistion(long l2) {
        this.lastSavedPosistion = l2;
    }

    public int getExpenseType() {
        return this.expenseType;
    }

    public void setExpenseType(int n2) {
        this.expenseType = n2;
    }

    public int getEffectiveExpenseType() {
        Task task;
        int n2 = this.expenseType;
        if (n2 == 0 && (task = this.getWbsParentTask()) != null) {
            n2 = task.getEffectiveExpenseType();
        }
        if (n2 == 0) {
            n2 = this.getOwningProject().getEffectiveExpenseType();
        }
        return n2;
    }

    public boolean startsBeforeProject() {
        return this.getConstraintType() == 5 && this.getPredecessorList().isEmpty() && this.getConstraintDate() < this.getOwningProject().getStart();
    }

    public Resource getDelegatedTo() {
        Task task;
        if (this.delegatedTo == null && (task = this.getWbsParentTask()) != null) {
            return task.getDelegatedTo();
        }
        return this.delegatedTo;
    }

    public void setDelegatedTo(Resource resource) {
        Resource resource2 = this.delegatedTo;
        this.delegatedTo = resource;
    }

    public boolean isDelegatedToUser() {
        Resource resource = this.getDelegatedTo();
        return resource != null && Environment.getLogin().equals(resource.getUserAccount());
    }

    public String getDelegatedToName() {
        Resource resource = this.getDelegatedTo();
        return resource == null ? "" : resource.getName();
    }

    public void forSnapshotsAssignments(Closure closure, boolean bl) {
        if (bl) {
            this.forSnapshotsAssignments(closure, -1);
        } else {
            for (int i2 = 0; i2 < Settings.numBaselines(); ++i2) {
                this.forSnapshotsAssignments(closure, i2);
            }
        }
    }

    public void forSnapshotsAssignments(Closure closure, int n2) {
        TaskSnapshot taskSnapshot = n2 == -1 ? (TaskSnapshot)this.getCurrentSnapshot() : (TaskSnapshot)this.getSnapshot(new Integer(n2));
        if (taskSnapshot == null) {
            return;
        }
        AssociationList associationList = taskSnapshot.getHasAssignments().getAssignments();
        if (associationList.size() > 0) {
            for (Assignment assignment : associationList) {
                closure.execute(assignment);
            }
        }
    }

    public void forSnapshots(Closure closure) {
    }

    public void forSnapshots(Closure closure, int n2) {
    }

    public String getPredecessorOrder() {
        int[] nArray = ((CriticalPath)this.project.getSchedulingAlgorithm()).findTaskPosition(this);
        String string = "" + nArray[0];
        if (nArray.length == 2) {
            string = string + ", " + nArray[1];
        }
        return string;
    }
}

