/*
 * Decompiled with CFR 0.152.
 */
package com.projity.algorithm;

import com.projity.algorithm.IntervalGenerator;
import com.projity.algorithm.RangeIntervalGenerator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class IntervalGeneratorSet
implements IntervalGenerator {
    private IntervalGenerator currentIntervalGenerator = null;
    private LinkedList generators = null;
    private boolean sameEarliestEnding = true;

    public Collection getGenerators() {
        return this.generators;
    }

    public static IntervalGenerator extractUnshared(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            IntervalGenerator intervalGenerator = (IntervalGenerator)iterator.next();
            if (intervalGenerator.canBeShared()) continue;
            iterator.remove();
            if (collection.isEmpty()) {
                collection.add(RangeIntervalGenerator.continuous());
            }
            return intervalGenerator;
        }
        return null;
    }

    public static IntervalGeneratorSet getInstance(LinkedList linkedList) {
        return new IntervalGeneratorSet(linkedList);
    }

    public static IntervalGeneratorSet getInstance(IntervalGenerator intervalGenerator) {
        return new IntervalGeneratorSet(intervalGenerator);
    }

    public static IntervalGeneratorSet getInstance(IntervalGenerator intervalGenerator, IntervalGenerator intervalGenerator2) {
        return new IntervalGeneratorSet(intervalGenerator, intervalGenerator2);
    }

    protected IntervalGenerator earliestEndingGenerator() {
        long l = Long.MAX_VALUE;
        IntervalGenerator intervalGenerator = null;
        if (this.generators != null) {
            for (IntervalGenerator intervalGenerator2 : this.generators) {
                long l2 = intervalGenerator2.currentEnd();
                if (l2 == l) {
                    this.sameEarliestEnding = true;
                }
                if (l2 >= l) continue;
                l = l2;
                intervalGenerator = intervalGenerator2;
            }
        }
        return intervalGenerator;
    }

    private IntervalGeneratorSet(LinkedList linkedList) {
        this.generators = linkedList;
        this.initialize();
    }

    private IntervalGeneratorSet(IntervalGenerator intervalGenerator) {
        if (this.generators == null) {
            this.generators = new LinkedList();
        }
        this.generators.add(intervalGenerator);
        this.initialize();
    }

    private IntervalGeneratorSet(IntervalGenerator intervalGenerator, IntervalGenerator intervalGenerator2) {
        if (this.generators == null) {
            this.generators = new LinkedList();
        }
        this.generators.add(intervalGenerator);
        this.generators.add(intervalGenerator2);
        this.initialize();
    }

    public void remove(IntervalGenerator intervalGenerator) {
        this.generators.remove(intervalGenerator);
    }

    public boolean isEmpty() {
        return this.generators.isEmpty();
    }

    private void initialize() {
        this.currentIntervalGenerator = this.earliestEndingGenerator();
        if (this.currentIntervalGenerator == null) {
            System.out.println("0 intialize" + this.currentIntervalGenerator);
        }
    }

    @Override
    public Object current() {
        return this.currentIntervalGenerator.current();
    }

    @Override
    public long currentEnd() {
        return this.currentIntervalGenerator.currentEnd();
    }

    @Override
    public long currentStart() {
        return this.currentIntervalGenerator.currentStart();
    }

    @Override
    public boolean isCurrentActive() {
        return this.currentIntervalGenerator.isCurrentActive();
    }

    @Override
    public boolean hasNext() {
        return this.currentIntervalGenerator != null;
    }

    @Override
    public boolean canBeShared() {
        return false;
    }

    @Override
    public boolean evaluate(Object object) {
        boolean bl = true;
        this.currentIntervalGenerator = this.earliestEndingGenerator();
        if (this.currentIntervalGenerator == null) {
            return false;
        }
        if (this.sameEarliestEnding) {
            long l = this.currentIntervalGenerator.currentEnd();
            for (IntervalGenerator intervalGenerator : this.generators) {
                if (intervalGenerator.currentEnd() != l || intervalGenerator.evaluate(object)) continue;
                bl = false;
            }
        } else {
            bl = this.currentIntervalGenerator.evaluate(object);
        }
        return bl;
    }
}

