/*
 * Decompiled with CFR 0.152.
 */
package com.projity.dialog.assignment;

import com.projity.configuration.Dictionary;
import com.projity.datatype.Rate;
import com.projity.dialog.assignment.AssignmentDialog;
import com.projity.dialog.assignment.CommonAssignmentDialog;
import com.projity.dialog.assignment.ReplaceAssignmentDialog;
import com.projity.dialog.assignment.ResourceAssigner;
import com.projity.field.Field;
import com.projity.graphic.configuration.GraphicConfiguration;
import com.projity.graphic.configuration.SpreadSheetFieldArray;
import com.projity.graphic.configuration.shape.Colors;
import com.projity.grouping.core.Node;
import com.projity.grouping.core.NodeList;
import com.projity.grouping.core.event.HierarchyEvent;
import com.projity.grouping.core.event.HierarchyListener;
import com.projity.grouping.core.model.NodeModel;
import com.projity.grouping.core.model.NodeModelFactory;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.assignment.AssignmentEntry;
import com.projity.pm.assignment.HasAssignments;
import com.projity.pm.graphic.model.cache.NodeModelCache;
import com.projity.pm.graphic.model.cache.NodeModelCacheFactory;
import com.projity.pm.graphic.spreadsheet.SpreadSheet;
import com.projity.pm.graphic.spreadsheet.SpreadSheetModel;
import com.projity.pm.graphic.spreadsheet.editor.RateEditor;
import com.projity.pm.graphic.spreadsheet.renderer.RateRenderer;
import com.projity.pm.resource.Resource;
import com.projity.pm.resource.ResourcePool;
import com.projity.pm.task.Project;
import com.projity.strings.Messages;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Transformer;

public class AssignmentEntryPane
extends JScrollPane
implements HierarchyListener {
    private static final long serialVersionUID = 1L;
    CommonAssignmentDialog dialog;
    AssignmentSpreadSheet spreadSheet;
    NodeModel assignmentModel;
    Project project;
    ResourceAssigner resourceAssigner;
    List taskList = new ArrayList();
    public static final String spreadsheetCategory = "assignmentEntrySpreadsheet";
    protected NodeModelCache cache;
    private boolean replace;
    private static final int REQUEST_DEMAND_TYPE_COLUMN = 0;
    private static final int UNITS_COLUMN = 1;
    protected Closure transformerClosure;

    public AssignmentEntryPane(CommonAssignmentDialog commonAssignmentDialog, Project project, ResourceAssigner resourceAssigner, boolean bl, Closure closure) {
        this.replace = bl;
        this.resourceAssigner = resourceAssigner;
        this.dialog = commonAssignmentDialog;
        this.transformerClosure = closure;
    }

    private SpreadSheetFieldArray getFields() {
        return (SpreadSheetFieldArray)Dictionary.get(spreadsheetCategory, Messages.getString(this.replace ? "Spreadsheet.AssignmentEntry.replaceResources" : "Spreadsheet.AssignmentEntry.assignResources"));
    }

    public void init() {
        if (this.project == null) {
            return;
        }
        ResourcePool resourcePool = this.project.getResourcePool();
        resourcePool.getResourceOutline().getHierarchy().removeHierarchyListener(this);
        resourcePool.getResourceOutline().getHierarchy().addHierarchyListener(this);
        this.assignmentModel = NodeModelFactory.getInstance().replicate(resourcePool.getResourceOutline(), new NodeFactoryTransformer());
        this.assignmentModel.getHierarchy().setNbEndVoidNodes(0);
        if (this.spreadSheet == null) {
            this.spreadSheet = new AssignmentSpreadSheet(this.resourceAssigner);
            this.spreadSheet.setSpreadSheetCategory(spreadsheetCategory);
            this.spreadSheet.setActions(new String[0]);
        }
        this.cache = NodeModelCacheFactory.getInstance().createDefaultCache(this.assignmentModel, resourcePool, 1, "AssignmentEntry", this.transformerClosure);
        SpreadSheetFieldArray spreadSheetFieldArray = this.getFields();
        this.spreadSheet.setCache(this.cache, spreadSheetFieldArray, spreadSheetFieldArray.getCellStyle(), spreadSheetFieldArray.getActionList());
        if (!this.replace) {
            this.spreadSheet.getColumnModel().getColumn(1).setPreferredWidth(50);
        }
        JViewport jViewport = this.createViewport();
        jViewport.setView(this.spreadSheet);
        this.setViewport(jViewport);
        this.setHorizontalScrollBarPolicy(31);
        Dimension dimension = this.spreadSheet.getPreferredSize();
        Dimension dimension2 = new Dimension();
        GraphicConfiguration graphicConfiguration = GraphicConfiguration.getInstance();
        int n = graphicConfiguration.getRowHeaderWidth() + this.spreadSheet.getRowMargin() * 2;
        dimension2.setSize(dimension.getWidth(), dimension.getHeight());
        jViewport.setPreferredSize(dimension2);
        this.updateTable();
    }

    public void setProject(Project project) {
        this.project = project;
        this.init();
    }

    void setSelectedTasks(List list) {
        this.taskList = list;
        this.updateTable();
        boolean bl = !list.isEmpty();
        this.spreadSheet.setEnabled(bl);
        this.spreadSheet.getRowHeader().setEnabled(bl);
    }

    List getSelectedResources(boolean bl) {
        return this.spreadSheet.getSelectedResources(bl);
    }

    int getSelectedCount() {
        return this.spreadSheet.getSelectedCount();
    }

    void updateTable() {
        this.assignmentModel.getHierarchy().visitAll(new AssignmentEntrySetter(this.taskList));
        ((SpreadSheetModel)this.spreadSheet.getModel()).getCache().update();
        ((SpreadSheetModel)this.spreadSheet.getModel()).fireTableDataChanged();
    }

    public AssignmentSpreadSheet getSpreadSheet() {
        return this.spreadSheet;
    }

    @Override
    public void nodesChanged(HierarchyEvent hierarchyEvent) {
    }

    @Override
    public void nodesInserted(HierarchyEvent hierarchyEvent) {
        this.init();
    }

    @Override
    public void nodesRemoved(HierarchyEvent hierarchyEvent) {
        this.init();
    }

    @Override
    public void structureChanged(HierarchyEvent hierarchyEvent) {
    }

    private class AssignmentEntrySetter
    implements Closure {
        List taskList;

        AssignmentEntrySetter(List list) {
            this.taskList = list;
        }

        @Override
        public void execute(Object object) {
            AssignmentEntry assignmentEntry = (AssignmentEntry)((Node)object).getImpl();
            assignmentEntry.setAssignmentsFromTaskList(this.taskList);
        }
    }

    public class NodeFactoryTransformer
    implements Transformer {
        @Override
        public Object transform(Object object) {
            if (object instanceof HasAssignments) {
                HasAssignments hasAssignments = (HasAssignments)object;
                return new AssignmentEntry(hasAssignments, null, AssignmentEntryPane.this.project);
            }
            return null;
        }
    }

    class AssignmentSpreadSheet
    extends SpreadSheet {
        private static final long serialVersionUID = 1L;
        ResourceAssigner resourceAssigner;

        public AssignmentSpreadSheet(ResourceAssigner resourceAssigner) {
            this.resourceAssigner = resourceAssigner;
            this.setCanModifyColumns(false);
            this.setCanSelectFieldArray(false);
        }

        private AssignmentEntry getEntryInRow(int n) {
            Node node = ((SpreadSheetModel)this.getModel()).getNode(n).getNode();
            if (node != null && !node.isVirtual()) {
                return (AssignmentEntry)node.getImpl();
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            AssignmentEntry assignmentEntry = this.getEntryInRow(n);
            if (assignmentEntry == null) {
                return;
            }
            if (!assignmentEntry.isAssigned() && this.resourceAssigner != null) {
                Field field = ((SpreadSheetModel)this.getModel()).getFieldInColumn(n2 + 1);
                double d = 1.0;
                if (field == AssignmentEntry.getRateField()) {
                    d = ((Rate)object).getValue();
                }
                this.resourceAssigner.assign((Resource)assignmentEntry.getResource(), d);
            }
            super.setValueAt(object, n, n2);
        }

        List getSelectedResources(boolean bl) {
            List list = NodeList.nodeListToImplList(this.getSelectedNodes());
            ArrayList<HasAssignments> arrayList = new ArrayList<HasAssignments>();
            for (AssignmentEntry assignmentEntry : list) {
                if (bl && !assignmentEntry.isAssigned()) continue;
                arrayList.add(assignmentEntry.getResource());
            }
            return arrayList;
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            Field field;
            TableCellEditor tableCellEditor = null;
            AssignmentEntry assignmentEntry = this.getEntryInRow(n);
            if (assignmentEntry != null && (field = ((SpreadSheetModel)this.getModel()).getFieldInColumn(n2 + 1)) == AssignmentEntry.getRateField() && assignmentEntry.getTimeUnitLabel() != null) {
                boolean bl = assignmentEntry.getResource().isLabor();
                tableCellEditor = new RateEditor(assignmentEntry.getTimeUnitLabel(), field.isMoney(), bl && field.isPercent(), bl);
            }
            if (tableCellEditor == null) {
                tableCellEditor = super.getCellEditor(n, n2);
            }
            return tableCellEditor;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            Field field;
            TableCellRenderer tableCellRenderer = null;
            AssignmentEntry assignmentEntry = this.getEntryInRow(n);
            if (assignmentEntry != null && (field = ((SpreadSheetModel)this.getModel()).getFieldInColumn(n2 + 1)) == AssignmentEntry.getRateField() && assignmentEntry.getTimeUnitLabel() != null) {
                tableCellRenderer = new RateRenderer();
            }
            if (tableCellRenderer == null) {
                tableCellRenderer = super.getCellRenderer(n, n2);
            }
            return tableCellRenderer;
        }

        int getSelectedCount() {
            return NodeList.nodeListToImplList(this.getSelectedNodes()).size();
        }

        @Override
        public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
            Component component = super.prepareRenderer(tableCellRenderer, n, n2);
            AssignmentEntry assignmentEntry = this.getEntryInRow(n);
            component.setForeground(Colors.BLACK);
            if (assignmentEntry != null && assignmentEntry.isAssigned()) {
                if (AssignmentEntryPane.this.taskList.size() == assignmentEntry.getAssignmentCount()) {
                    component.setBackground(Colors.PALE_GREEN);
                } else {
                    Field field;
                    component.setBackground(Colors.PALE_YELLOW);
                    if (n2 != 0 && ((field = ((SpreadSheetModel)this.getModel()).getFieldInColumn(n2)) == Assignment.getRequestDemandTypeField() || field == AssignmentEntry.getRateField())) {
                        ((JLabel)component).setText(Field.MULTIPLE_VALUES);
                    }
                }
            }
            return component;
        }

        @Override
        public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
            AssignmentEntryPane.this.dialog.setEditorButtonsVisible(true);
            return super.prepareEditor(tableCellEditor, n, n2);
        }

        @Override
        public void editingCanceled(ChangeEvent changeEvent) {
            AssignmentEntryPane.this.dialog.setEditorButtonsVisible(false);
            super.editingCanceled(changeEvent);
        }

        @Override
        public void editingStopped(ChangeEvent changeEvent) {
            AssignmentEntryPane.this.dialog.setEditorButtonsVisible(false);
            super.editingStopped(changeEvent);
        }

        @Override
        public void doDoubleClick(int n, int n2) {
            if (AssignmentEntryPane.this.dialog instanceof AssignmentDialog) {
                ((AssignmentDialog)AssignmentEntryPane.this.dialog).assign();
                ((AssignmentDialog)AssignmentEntryPane.this.dialog).setVisible(false);
            } else if (AssignmentEntryPane.this.dialog instanceof ReplaceAssignmentDialog) {
                ((ReplaceAssignmentDialog)AssignmentEntryPane.this.dialog).onOk();
            }
        }
    }
}

