/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.graph;

import com.projity.field.Field;
import com.projity.field.FieldConverter;
import com.projity.graphic.configuration.BarStyles;
import com.projity.graphic.configuration.GraphicConfiguration;
import com.projity.grouping.core.Node;
import com.projity.grouping.core.model.WalkersNodeModel;
import com.projity.pm.graphic.graph.GraphModel;
import com.projity.pm.graphic.graph.GraphParams;
import com.projity.pm.graphic.graph.GraphUI;
import com.projity.pm.graphic.graph.event.GraphEvent;
import com.projity.pm.graphic.graph.event.GraphListener;
import com.projity.pm.graphic.model.cache.NodeModelCache;
import com.projity.pm.task.Project;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;

public abstract class Graph
extends JComponent
implements GraphListener,
GraphParams {
    protected BarStyles barStyles = null;
    protected Project project;
    protected GraphModel model;
    protected GraphicConfiguration config = GraphicConfiguration.getInstance();

    public Graph(Project project, String string) {
        this(new GraphModel(project, string), project);
    }

    protected Graph(GraphModel graphModel, Project project) {
        this.project = project;
        this.setModel(graphModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.updateUI();
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.setDoubleBuffered(true);
        this.setLayout(null);
    }

    @Override
    public GraphUI getUI() {
        return (GraphUI)this.ui;
    }

    @Override
    public NodeModelCache getCache() {
        return this.model.getCache();
    }

    @Override
    public void setCache(NodeModelCache nodeModelCache) {
        this.model.setCache(nodeModelCache);
    }

    public GraphModel getModel() {
        return this.model;
    }

    public Project getProject() {
        return this.project;
    }

    public void cleanUp() {
        if (this.model != null) {
            this.model.removeGraphListener(this);
        }
    }

    public void setModel(GraphModel graphModel) {
        if (this.model != null) {
            graphModel.removeGraphListener(this);
        }
        this.model = graphModel;
        graphModel.addGraphListener(this);
    }

    @Override
    public BarStyles getBarStyles() {
        return this.barStyles;
    }

    @Override
    public void setBarStyles(BarStyles barStyles) {
        this.barStyles = barStyles;
        this.model.setBarStyles(barStyles);
    }

    private String getStringValue(Field field, Node node) {
        WalkersNodeModel walkersNodeModel = this.model.getCache().getWalkersModel();
        Object object = field.getValue(node, walkersNodeModel, null);
        return FieldConverter.toString(object, object.getClass(), null);
    }

    @Override
    public void updateGraph(GraphEvent graphEvent) {
        this.update(graphEvent.getNodes());
    }

    public void update(List list) {
        ((GraphUI)this.ui).updateShapes(list);
        this.repaint();
    }

    @Override
    public void updateUI() {
    }

    @Override
    public Rectangle getDrawingBounds() {
        return this.getVisibleRect();
    }

    @Override
    public GraphicConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public void setConfiguration(GraphicConfiguration graphicConfiguration) {
        this.config = graphicConfiguration;
    }
}

