/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.core;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.cesilko.rachota.core.Day;
import org.cesilko.rachota.core.DiaryScanner;
import org.cesilko.rachota.core.RegularTask;
import org.cesilko.rachota.core.RegularTasksScanner;
import org.cesilko.rachota.core.Settings;
import org.cesilko.rachota.core.Task;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.gui.StartupWindow;
import org.cesilko.rachota.gui.Tools;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Plan {
    private Hashtable days = new Hashtable();
    private Vector regularTasks = new Vector();
    private static Plan plan;
    public static long UPLOAD_IN_5_MINUTES;
    public static long UPLOAD_NOW;

    private Plan() {
    }

    public static Plan getDefault() {
        if (plan == null) {
            plan = new Plan();
        }
        return plan;
    }

    public void addDay(Day day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(day.getDate());
        String ID = this.getDayID(calendar);
        this.days.put(ID, day);
    }

    public Day getDay(Date date) {
        return this.getDay(date, 0);
    }

    public Day getDayBefore(Day day) {
        return this.getDay(day.getDate(), -1);
    }

    public Day getDayAfter(Day day) {
        return this.getDay(day.getDate(), 1);
    }

    public Iterator getDays(int scale) {
        Vector<Day> requiredDays = new Vector<Day>();
        if (scale == 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(3, -1);
            calendar.set(7, calendar.getFirstDayOfWeek());
            Day day = this.getDay(calendar.getTime());
            for (int i = 0; i < 7; ++i) {
                requiredDays.add(day);
                calendar.add(7, 1);
                day = this.getDay(calendar.getTime());
            }
            return requiredDays.iterator();
        }
        if (scale == 1) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(2, -1);
            calendar.set(5, 1);
            int numberOfDays = calendar.getActualMaximum(5);
            Day day = this.getDay(calendar.getTime());
            for (int i = 0; i < numberOfDays; ++i) {
                requiredDays.add(day);
                calendar.add(5, 1);
                day = this.getDay(calendar.getTime());
            }
            return requiredDays.iterator();
        }
        return this.days.values().iterator();
    }

    private Day getDay(Date date, int offset) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, offset);
        String ID = this.getDayID(calendar);
        Day day = (Day)this.days.get(ID);
        if (day == null) {
            day = new Day(new Vector(), calendar.getTime(), null, null);
        }
        return day;
    }

    public String getDayID(Calendar calendar) {
        String ID = "" + calendar.get(1);
        ID = ID + "_" + calendar.get(2);
        ID = ID + "_" + calendar.get(5);
        return ID;
    }

    public boolean isToday(Day day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(day.getDate());
        String thisID = this.getDayID(calendar);
        calendar.setTime(new Date());
        String todayID = this.getDayID(calendar);
        return todayID.equals(thisID);
    }

    public boolean isFuture(Day day) {
        return day.getDate().after(new Date());
    }

    public void addRegularTask(RegularTask regularTask) {
        this.regularTasks.add(regularTask);
    }

    public void removeRegularTask(RegularTask regularTask) {
        this.regularTasks.remove(regularTask);
    }

    public Vector getRegularTasks() {
        return this.regularTasks;
    }

    public static void createBackup() {
        Plan plan = Plan.getDefault();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int thisWeek = calendar.get(3);
        plan.saveWeek(thisWeek, true);
        File backupFile = new File((String)Settings.getDefault().getSetting("userDir") + File.separator + "backup_diary.xml");
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            builder.parse(backupFile);
        }
        catch (Exception e) {
            System.out.println("Error: Can't create backup_diary.xml file. Another try in " + Settings.getDefault().getSetting("backupAge") + " minute(s).");
            e.printStackTrace();
            backupFile.delete();
        }
    }

    public static boolean savePlan() {
        Plan plan = Plan.getDefault();
        Calendar calendar = Calendar.getInstance();
        int thisWeek = calendar.get(3);
        int weekToSave = plan.getNextWeekToSave(thisWeek - 2);
        boolean planSaved = true;
        while (weekToSave != -1) {
            planSaved &= plan.saveWeek(weekToSave, false);
            weekToSave = plan.getNextWeekToSave(weekToSave);
        }
        return planSaved;
    }

    public void uploadDiary(long uploadFrequency) {
        String uploadDiary = (String)Settings.getDefault().getSetting("uploadDiary");
        if (!uploadDiary.equals(Settings.UPLOAD_ON)) {
            return;
        }
        String lastUpload = System.getProperty("lastUpload");
        if (lastUpload == null) {
            System.setProperty("lastUpload", "" + new Date().getTime());
            return;
        }
        long lastUploadAge = new Date().getTime() - Long.parseLong(lastUpload);
        if (lastUploadAge < uploadFrequency) {
            return;
        }
        Thread uploadProcess = new Thread("Rachota Upload Process"){

            @Override
            public void run() {
                try {
                    System.setProperty("lastUpload", "" + new Date().getTime());
                    String uploadUrlPattern = (String)Settings.getDefault().getSetting("uploadDiaryURL");
                    String uploadUsername = (String)Settings.getDefault().getSetting("uploadDiaryUsername");
                    String uploadUrl = Tools.replaceAll(uploadUrlPattern, "$USERNAME", uploadUsername);
                    URL url = new URL(uploadUrl);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setConnectTimeout(5000);
                    connection.setReadTimeout(2000);
                    connection.setRequestMethod("POST");
                    connection.setDoOutput(true);
                    connection.connect();
                    OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
                    String diary = Plan.this.loadThisWeekDiary();
                    writer.write(diary);
                    writer.close();
                    int responseCode = connection.getResponseCode();
                    String responseMessage = connection.getResponseMessage();
                    connection.disconnect();
                    if (responseCode == 200) {
                        return;
                    }
                    Settings.getDefault().setSetting("uploadDiary", Settings.UPLOAD_SUSPENDED);
                    String reason = "[" + responseCode + "] - " + responseMessage;
                    JOptionPane.showMessageDialog(null, Translator.getTranslation("ERROR.UPLOAD_DIARY_ERROR", new String[]{reason}), Translator.getTranslation("ERROR.ERROR_TITLE"), 0);
                    System.out.println("Error: Upload of diary failed due to [" + responseCode + "] - " + responseMessage + ". Temporarily disabling.");
                }
                catch (MalformedURLException exception) {
                    System.out.println("Error: Cannot build diary upload URL.");
                    exception.printStackTrace();
                }
                catch (IOException exception) {
                    System.out.println("Error: Upload of diary to central server failed.");
                    exception.printStackTrace();
                }
            }
        };
        uploadProcess.start();
        if (uploadFrequency == UPLOAD_NOW) {
            while (uploadProcess.isAlive()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    System.out.println("Error: Waiting for final diary upload terminated.");
                }
            }
        }
    }

    private int getNextWeekToSave(int savedWeek) {
        if (savedWeek < 1) {
            return 1;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(3, savedWeek);
        Date savedDate = calendar.getTime();
        int maxWeek = calendar.getMaximum(3);
        for (Day day : this.days.values()) {
            Date date = day.getDate();
            if (!date.after(savedDate)) continue;
            calendar.setTime(date);
            int week = calendar.get(3);
            if (!(week > savedWeek & week < maxWeek)) continue;
            maxWeek = week;
        }
        if (maxWeek == calendar.getMaximum(3)) {
            maxWeek = -1;
        }
        return maxWeek;
    }

    private boolean saveWeek(int week, boolean isBackup) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(7, calendar.getFirstDayOfWeek() + 6);
        int year = calendar.get(1);
        String location = (String)Settings.getDefault().getSetting("userDir");
        location = isBackup ? location + File.separator + "backup_diary.xml" : location + File.separator + "diary_" + year + "_" + week + ".xml";
        try {
            String encoding = (String)Settings.getDefault().getSetting("systemEncoding");
            PrintStream stream = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(location)), true, encoding);
            stream.println("<?xml version=\"1.1\" encoding=\"" + encoding + "\"?>");
            stream.println("<!--");
            stream.println("    Rachota 2.4 diary file - editing not recommended");
            stream.println("    " + new Date());
            stream.println("-->");
            stream.println("<!DOCTYPE week SYSTEM \"diary.dtd\">");
            stream.println();
            String os = System.getProperty("os.name") + " " + System.getProperty("os.version");
            stream.println("<week year=\"" + year + "\" id=\"" + week + "\" os=\"" + os + "\">");
            calendar.set(3, week);
            for (int i = 0; i < 7; ++i) {
                calendar.set(7, i);
                Day day = (Day)this.days.get(this.getDayID(calendar));
                if (day == null) continue;
                day.write(stream);
            }
            stream.println("</week>");
            stream.flush();
            stream.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, Translator.getTranslation("ERROR.WRITE_ERROR", new String[]{location}), Translator.getTranslation("ERROR.ERROR_TITLE"), 0);
        }
        File diaryFile = new File(location);
        return diaryFile.length() != 0L;
    }

    public static void loadPlan() throws Exception {
        String userDir = (String)Settings.getDefault().getSetting("userDir");
        File[] diaries = new File(userDir).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String name = file.getName();
                return name.startsWith("diary_") && name.endsWith(".xml");
            }
        });
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        DiaryScanner.createDTD();
        if (diaries == null) {
            return;
        }
        StartupWindow startupWindow = StartupWindow.getInstance();
        startupWindow.setNumberOfDiaries(diaries.length);
        for (int i = 0; i < diaries.length; ++i) {
            try {
                DiaryScanner scanner = new DiaryScanner(builder.parse(diaries[i]));
                startupWindow.setProgressMessage(diaries[i].getName());
                scanner.loadDocument();
                startupWindow.setProgress(i);
                continue;
            }
            catch (SAXParseException e) {
                e.printStackTrace();
                File backupFile = new File(userDir + File.separator + "backup_diary.xml");
                int currentWeek = Calendar.getInstance().get(3);
                int currentYear = Calendar.getInstance().get(1);
                if (backupFile.exists() & diaries[i].getName().equals("diary_" + currentYear + "_" + currentWeek + ".xml")) {
                    String message = Translator.getTranslation("ERROR.DIARY_CORRUPTED", new String[]{diaries[i].getName()});
                    Object[] buttons = new String[]{Translator.getTranslation("QUESTION.BT_YES"), Translator.getTranslation("QUESTION.BT_NO"), Translator.getTranslation("DATEDIALOG.BT_CANCEL")};
                    int decision = JOptionPane.showOptionDialog(null, message, Translator.getTranslation("ERROR.ERROR_TITLE"), 1, 0, null, buttons, buttons[0]);
                    if (decision == 2) {
                        System.exit(-1);
                    }
                    if (decision != 0) continue;
                    DiaryScanner scanner = new DiaryScanner(builder.parse(backupFile));
                    startupWindow.setProgressMessage("backup_diary.xml");
                    scanner.loadDocument();
                    startupWindow.setProgress(diaries.length - 1);
                    continue;
                }
                JOptionPane.showMessageDialog(null, Translator.getTranslation("ERROR.READ_ERROR", new String[]{diaries[i].getName()}), Translator.getTranslation("ERROR.ERROR_TITLE"), 0);
            }
        }
    }

    public static void saveRegularTasks() {
        String location = (String)Settings.getDefault().getSetting("userDir");
        location = location + File.separator + "regular_tasks.xml";
        try {
            String encoding = (String)Settings.getDefault().getSetting("systemEncoding");
            PrintStream stream = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(location)), true, encoding);
            stream.println("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
            stream.println("<!--");
            stream.println("    Rachota 2.1 regular tasks - editing not recommended");
            stream.println("    " + new Date());
            stream.println("-->");
            stream.println("<!DOCTYPE week SYSTEM \"regular_tasks.dtd\">");
            stream.println();
            stream.println("    <regular_tasks>");
            for (RegularTask regularTask : Plan.getDefault().getRegularTasks()) {
                regularTask.write(stream);
            }
            stream.println("    </regular_tasks>");
            stream.flush();
            stream.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, Translator.getTranslation("ERROR.WRITE_ERROR", new String[]{location}), Translator.getTranslation("ERROR.ERROR_TITLE"), 0);
        }
    }

    public static void loadRegularTasks() throws Exception {
        RegularTasksScanner scanner;
        String userDir = (String)Settings.getDefault().getSetting("userDir");
        String fileName = userDir + File.separator + "regular_tasks.xml";
        File regularTasksFile = new File(fileName);
        if (!regularTasksFile.exists()) {
            return;
        }
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        RegularTasksScanner.createDTD();
        try {
            scanner = new RegularTasksScanner(builder.parse(regularTasksFile));
        }
        catch (SAXException ex) {
            Logger.getLogger(Plan.class.getName()).log(Level.WARNING, "Error occured while parsing existing regular task XML file.", ex);
            return;
        }
        scanner.loadDocument();
    }

    public void copyUnfinishedTasks() {
        Day today = this.getDay(new Date());
        if (!this.existsDayBefore(today)) {
            return;
        }
        Day previousWorkingDay = this.getDayBefore(today);
        while (previousWorkingDay.getTotalTime((Boolean)Settings.getDefault().getSetting("countPrivateTasks")) == 0L) {
            if (!this.existsDayBefore(previousWorkingDay)) {
                return;
            }
            previousWorkingDay = this.getDayBefore(previousWorkingDay);
        }
        for (Task task : previousWorkingDay.getTasks()) {
            if (task.getState() == Task.STATE_DONE || today.getTask(task.getDescription()) != null) continue;
            today.addTask(task.cloneTask());
        }
        if (today.isModified()) {
            this.addDay(today);
        }
    }

    public void addRegularTasks(Day day) {
        boolean pastDay;
        boolean bl = pastDay = !(Plan.getDefault().isFuture(day) | Plan.getDefault().isToday(day));
        if (pastDay) {
            return;
        }
        day.removeNotStartedRegularTasks();
        for (RegularTask regularTask : this.regularTasks) {
            if (!regularTask.isPlannedFor(day) || day.getTask(regularTask.getDescription()) != null) continue;
            RegularTask clone = (RegularTask)regularTask.cloneTask();
            day.addTask(clone);
        }
    }

    private boolean existsDayBefore(Day day) {
        for (Day indexedDay : this.days.values()) {
            if (!indexedDay.getDate().before(day.getDate())) continue;
            return true;
        }
        return false;
    }

    public Vector getCategories() {
        Vector<String> allCategories = new Vector<String>();
        for (Day day : this.days.values()) {
            Vector tasks = day.getTasks();
            for (Task task : tasks) {
                Iterator keywordIter = task.getKeywordIterator();
                while (keywordIter.hasNext()) {
                    String category = (String)keywordIter.next();
                    if (allCategories.contains(category)) continue;
                    allCategories.add(category);
                }
            }
        }
        String[] defaults = new String[]{Translator.getTranslation("CATEGORY.MEETING"), Translator.getTranslation("CATEGORY.DISCUSSION"), Translator.getTranslation("CATEGORY.EMAIL"), Translator.getTranslation("CATEGORY.INTERNET")};
        for (int i = 0; i < defaults.length; ++i) {
            if (allCategories.contains(defaults[i])) continue;
            allCategories.add(defaults[i]);
        }
        return allCategories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadThisWeekDiary() {
        BufferedReader inputStreamReader = null;
        try {
            Calendar calendar = Calendar.getInstance();
            int thisWeek = calendar.get(3);
            int year = calendar.get(1);
            String userDir = (String)Settings.getDefault().getSetting("userDir");
            File thisWeekDiaryFile = new File(userDir + File.separator + "diary_" + year + "_" + thisWeek + ".xml");
            inputStreamReader = new BufferedReader(new InputStreamReader(new FileInputStream(thisWeekDiaryFile)));
            StringBuilder data = new StringBuilder();
            while (inputStreamReader.ready()) {
                data.append(inputStreamReader.readLine().trim());
            }
            String string = data.toString();
            return string;
        }
        catch (FileNotFoundException exception) {
            System.out.println("Error: Cannot find this week diary file.");
            exception.printStackTrace();
        }
        catch (IOException exception) {
            System.out.println("Error: Cannot read this week diary file.");
            exception.printStackTrace();
        }
        finally {
            try {
                inputStreamReader.close();
            }
            catch (IOException exception) {
                System.out.println("Error: Cannot finish reading this week diary file.");
                exception.printStackTrace();
            }
        }
        return null;
    }

    static {
        UPLOAD_IN_5_MINUTES = 300000L;
        UPLOAD_NOW = 0L;
    }
}

