/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.core;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Date;
import org.cesilko.rachota.core.Day;
import org.cesilko.rachota.core.Task;
import org.cesilko.rachota.core.Translator;

public class RegularTask
extends Task {
    private int frequency;
    public static int FREQUENCY_DAILY = 0;
    public static int FREQUENCY_MONDAY = 1;
    public static int FREQUENCY_TUESDAY = 2;
    public static int FREQUENCY_WEDNESDAY = 3;
    public static int FREQUENCY_THURSDAY = 4;
    public static int FREQUENCY_FRIDAY = 5;
    public static int FREQUENCY_SATURDAY = 6;
    public static int FREQUENCY_SUNDAY = 7;
    public static int FREQUENCY_WORKDAY = 8;
    public static int FREQUENCY_WEEKEND = 9;

    public RegularTask(String description, String keyword, String notes, int priority, int state, long duration, Date notificationTime, boolean automaticStart, boolean privateTask, int frequency) {
        super(description, keyword, notes, priority, state, duration, notificationTime, automaticStart, privateTask);
        this.setFrequency(frequency);
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public static String getFrequency(int frequency) {
        return Translator.getTranslation("TASK_FREQUENCY_" + frequency);
    }

    @Override
    public void writeRepetition(PrintStream stream) throws IOException {
        stream.println("            <repetition frequency=\"" + this.frequency + "\"/>");
    }

    public boolean isPlannedFor(Day day) {
        if (this.frequency == FREQUENCY_DAILY) {
            return true;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(day.getDate());
        int dayOfWeek = calendar.get(7) - 1;
        if (dayOfWeek == 0) {
            dayOfWeek = 7;
        }
        if (this.frequency <= FREQUENCY_SUNDAY) {
            return this.frequency == dayOfWeek;
        }
        boolean weekend = dayOfWeek == FREQUENCY_SUNDAY | dayOfWeek == FREQUENCY_SATURDAY;
        if (this.frequency == FREQUENCY_WEEKEND) {
            return weekend;
        }
        return !weekend;
    }

    @Override
    public Task cloneTask() {
        return new RegularTask(this.getDescription(), this.getKeyword(), this.getNotes(), this.getPriority(), STATE_NEW, 0L, this.getNotificationTime(), this.automaticStart(), this.privateTask(), this.frequency);
    }
}

