/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.cesilko.rachota.core.Settings;
import org.cesilko.rachota.gui.Tools;

public class Translator {
    private static PropertyResourceBundle dictionary = null;
    private static PropertyResourceBundle fallbackDictionary = null;
    private static final Logger log = Logger.getLogger(Translator.class.getName());
    private static final String DICTIONARY_PATH_FORMAT = "/org/cesilko/rachota/core/%s";
    private static final String FALLBACK_DICTIONARY = "Dictionary_en_US.properties";
    private static boolean dictionaryLookupDone = false;

    private static void findDictionary() {
        Translator.setupFallback();
        String dictionaryName = (String)Settings.getDefault().getSetting("dictionary");
        InputStream inputStream = null;
        if (!dictionaryName.equals(FALLBACK_DICTIONARY)) {
            inputStream = Translator.class.getResourceAsStream(String.format(DICTIONARY_PATH_FORMAT, dictionaryName));
            if (null != inputStream) {
                try {
                    dictionary = new PropertyResourceBundle(inputStream);
                }
                catch (IOException ex) {
                    log.log(Level.WARNING, "Unable to read dictionary file.", ex);
                }
            } else {
                log.log(Level.WARNING, String.format("Dictionary \"%s\" not found.", dictionaryName));
            }
        }
        if (null == dictionary && null == fallbackDictionary) {
            log.severe("No dictionaries found, unable to continue running...");
            JOptionPane.showMessageDialog(null, "No dictionaries found, unable to continue running...", "ERROR: No dictionaries found.", 0);
            System.exit(1);
        }
        dictionaryLookupDone = true;
    }

    private static void setupFallback() {
        InputStream stream = Translator.class.getResourceAsStream(String.format(DICTIONARY_PATH_FORMAT, FALLBACK_DICTIONARY));
        if (null != stream) {
            try {
                fallbackDictionary = new PropertyResourceBundle(stream);
            }
            catch (IOException ex) {
                log.log(Level.WARNING, "Unable to read fallback dictionary.", ex);
            }
        }
        if (null == fallbackDictionary) {
            log.log(Level.WARNING, String.format("Fallback dictionary \"%s\" not found.", FALLBACK_DICTIONARY));
        }
    }

    private static String lookupWord(String key) {
        if (!dictionaryLookupDone) {
            Translator.findDictionary();
        }
        String result = null;
        if (null != dictionary) {
            try {
                result = dictionary.getString(key);
            }
            catch (MissingResourceException ex) {
                log.log(Level.INFO, String.format("Unable to find the translation bound to key %s in current dictionary.", key), ex);
            }
        }
        if (null == result) {
            try {
                result = fallbackDictionary.getString(key);
            }
            catch (MissingResourceException inEx) {
                log.log(Level.WARNING, String.format("Unable to find the translation bound to key %s.", key), inEx);
            }
        }
        return result != null ? result : key;
    }

    private static String getTranslation(String word, boolean removeAnds) {
        String translation = Translator.lookupWord(word);
        if (removeAnds) {
            translation = Translator.removeAnds(translation);
        }
        return translation;
    }

    private static String removeAnds(String word) {
        return Tools.replaceAll(word, "&", "");
    }

    public static String getTranslation(String word) {
        return Translator.getTranslation(word, true);
    }

    public static String getTranslation(String word, String[] substitutions) {
        String translation = Translator.getTranslation(word, true);
        int count = substitutions.length;
        for (int i = 0; i < count; ++i) {
            translation = Tools.replaceAll(translation, "${" + i + "}", substitutions[i]);
        }
        return translation;
    }

    public static char getMnemonic(String word) {
        String translation = Translator.getTranslation(word, false);
        int index = translation.indexOf("&");
        return index == -1 ? (char)'\u001f' : translation.charAt(index + 1);
    }
}

