/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.core.filters;

import java.util.Iterator;
import java.util.Vector;
import org.cesilko.rachota.core.Task;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.core.filters.AbstractTaskFilter;

public class DescriptionFilter
extends AbstractTaskFilter {
    public static final int RULE_CONTAINS = 0;
    public static final int RULE_CONTAINS_NOT = 1;

    public DescriptionFilter(int contentRule, String subString) {
        super(contentRule, subString);
    }

    public DescriptionFilter() {
        this(0, "");
    }

    @Override
    public Vector getContentRules() {
        Vector<String> contentRules = new Vector<String>();
        contentRules.add(Translator.getTranslation("FILTER.RULE_CONTAINS"));
        contentRules.add(Translator.getTranslation("FILTER.RULE_CONTAINS_NOT"));
        return contentRules;
    }

    @Override
    public Vector filterTasks(Vector tasks) {
        Vector filteredTasks = (Vector)tasks.clone();
        Iterator iterator = tasks.iterator();
        String subString = this.getContent();
        int contentRule = this.getContentRule();
        block4: while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            boolean containsSubString = task.getDescription().toLowerCase().indexOf(subString.toLowerCase()) != -1;
            switch (contentRule) {
                case 0: {
                    if (containsSubString) continue block4;
                    filteredTasks.remove(task);
                    continue block4;
                }
                case 1: {
                    if (!containsSubString) continue block4;
                    filteredTasks.remove(task);
                    continue block4;
                }
            }
            System.out.println("Error: Task description can't be filtered by content rule: " + this.getContentRules().get(contentRule));
        }
        return filteredTasks;
    }

    @Override
    public String toString() {
        return Translator.getTranslation("TASK_DESCRIPTION");
    }
}

