/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.gui.Tools;

public class StartupWindow
extends JFrame {
    private static JLabel lbDiary;
    private JLabel lbImage;
    private static JLabel lbLoading;
    private static JProgressBar pbLoading;
    private boolean loading = true;
    private static StartupWindow startupWindow;

    private StartupWindow() {
        this.initComponents();
        this.setLocationRelativeTo(null);
        this.showWindow();
    }

    public static StartupWindow getInstance() {
        if (startupWindow != null) {
            return startupWindow;
        }
        startupWindow = new StartupWindow();
        return startupWindow;
    }

    @Override
    public Font getFont() {
        return Tools.getFont();
    }

    private void initComponents() {
        this.lbImage = new JLabel(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/logo_name_48.png")));
        lbLoading = new JLabel();
        pbLoading = new JProgressBar();
        lbDiary = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.lbImage, gridBagConstraints);
        lbLoading.setFont(this.getFont());
        lbLoading.setText(Translator.getTranslation("MESSAGE.PROGRESS_LOADING"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)lbLoading, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)pbLoading, gridBagConstraints);
        lbDiary.setFont(this.getFont());
        lbDiary.setText("settings.cfg");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)lbDiary, gridBagConstraints);
        this.pack();
    }

    public void setNumberOfDiaries(int numberOfDiaries) {
        pbLoading.setMaximum(numberOfDiaries);
    }

    public void setProgress(int numberOfReadDiaries) {
        pbLoading.setValue(numberOfReadDiaries);
        if (numberOfReadDiaries == pbLoading.getMaximum()) {
            this.loading = false;
        }
    }

    public void setProgressMessage(String progressMessage) {
        lbDiary.setText(progressMessage);
    }

    public void hideWindow() {
        pbLoading.setValue(pbLoading.getMaximum());
        this.loading = false;
    }

    private void showWindow() {
        this.setVisible(true);
        class Fader
        extends Thread {
            Fader() {
            }

            @Override
            public void run() {
                boolean colorUp = true;
                int colorRGB = 0;
                while (StartupWindow.this.loading) {
                    Color color = new Color(colorRGB, colorRGB, colorRGB);
                    lbLoading.setForeground(color);
                    if (colorUp) {
                        if ((colorRGB += 16) > 255) {
                            colorRGB = 255;
                            colorUp = false;
                        }
                    } else if ((colorRGB -= 16) < 0) {
                        colorRGB = 0;
                        colorUp = true;
                    }
                    try {
                        Fader.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                StartupWindow.this.setVisible(false);
            }
        }
        Fader fader = new Fader();
        fader.setPriority(1);
        fader.start();
    }

    static {
        startupWindow = null;
    }
}

