/*
 * Decompiled with CFR 0.152.
 */
package org.ujoframework.hibernateSupport;

import java.lang.reflect.Method;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.LazyInitializationException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.property.Getter;
import org.ujoframework.Ujo;
import org.ujoframework.UjoProperty;

public class UjoLazyPropertyGetter
implements Getter {
    private final UjoProperty ujoProperty;

    public UjoLazyPropertyGetter(String string, Class clazz) {
        try {
            Ujo ujo = (Ujo)clazz.newInstance();
            this.ujoProperty = ujo.readProperties().find(string, true);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Can't create an Ujo instance from the " + clazz, exception);
        }
    }

    public final Object get(Object object) throws HibernateException {
        try {
            return ((Ujo)object).readValue(this.ujoProperty);
        }
        catch (LazyInitializationException lazyInitializationException) {
            this.solveLazy(object);
            return ((Ujo)object).readValue(this.ujoProperty);
        }
    }

    public Object getForInsert(Object object, Map map, SessionImplementor sessionImplementor) throws HibernateException {
        return this.get(object);
    }

    public Class getReturnType() {
        return this.ujoProperty.getType();
    }

    public String getMethodName() {
        return this.ujoProperty.getName();
    }

    public Method getMethod() {
        return null;
    }

    private void solveLazy(Object object) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

