/*
 * Decompiled with CFR 0.152.
 */
package net.ponec.jworksheet.bo;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import net.ponec.jworksheet.bo.Project;
import net.ponec.jworksheet.core.ApplContext;
import net.ponec.jworksheet.core.ApplTools;
import net.ponec.jworksheet.core.MessageException;
import net.ponec.jworksheet.core.SysTray;
import org.ujoframework.UjoProperty;
import org.ujoframework.extensions.Property;
import org.ujoframework.extensions.UjoAction;
import org.ujoframework.implementation.array.ArrayUjo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameters
extends ArrayUjo {
    public static final String CONFIG_DIR = ".jWorkSheet";
    private static final String VALUE_DEFAULT = "<default>";
    protected static int propertyCount = 0;
    public static final UjoProperty<Parameters, Locale> P_LANG = Parameters.newProperty("Language", Locale.getDefault(), propertyCount++);
    public static final UjoProperty<Parameters, Float> P_WORKING_HOURS = Parameters.newProperty("WorkingHours", Float.valueOf(8.0f), propertyCount++);
    public static final UjoProperty<Parameters, Integer> P_FIRST_DAY_OF_WEEK = Parameters.newProperty("FirstDayOfWeek", Calendar.getInstance().getFirstDayOfWeek(), propertyCount++);
    public static final UjoProperty<Parameters, Boolean> P_DECIMAL_TIME_FORMAT = Parameters.newProperty("DecimalTimeFormat", true, propertyCount++);
    public static final UjoProperty<Parameters, String> P_DATE_MAIN_FORMAT = Parameters.newProperty("DateMainFormat", "EE, yyyy/MM/dd'  %s: 'ww", propertyCount++);
    public static final UjoProperty<Parameters, String> P_DATE_REPORT_FORMAT = Parameters.newProperty("DateReportFormat", P_DATE_MAIN_FORMAT.getDefault(), propertyCount++);
    public static final UjoProperty<Parameters, String> P_DATE_REPORT_FORMAT2 = Parameters.newProperty("DateReportFormat2", "d'<br/><span class=\"smallMonth\">'MMMM'</span>'", propertyCount++);
    public static final UjoProperty<Parameters, String> P_REPORT_CSS = Parameters.newProperty("ReportCSS", "styles/style.css", propertyCount++);
    public static final UjoProperty<Parameters, String> P_DATE_GOTO_FORMAT = Parameters.newProperty("DateGotoFormat", "yyyy/MM/dd", propertyCount++);
    public static final UjoProperty<Parameters, Boolean> P_NIMBUS_LAF = Parameters.newProperty("NimbusL&FSupport", !ApplTools.isWindowsOS(), propertyCount++);
    public static final UjoProperty<Parameters, Color> P_COLOR_PRIVATE = Parameters.newProperty("ColorOfPrivateProject", new Color(6136152), propertyCount++);
    public static final UjoProperty<Parameters, Color> P_COLOR_FINISHED_PROJ = Parameters.newProperty("ColorOfFinishedProject", new Color(11119752), propertyCount++);
    public static final UjoProperty<Parameters, Color> P_COLOR_EDITABLE = Parameters.newProperty("ColorOfEditableArea", new Color(16775885), propertyCount++);
    public static final UjoProperty<Parameters, Boolean> P_SYSTRAY_ENABLED = Parameters.newProperty("SystemTrayEnabled", ApplTools.isWindowsOS(), propertyCount++);
    public static final UjoProperty<Parameters, SysTray.Action> P_SYSTRAY_SECOND_CLICK = Parameters.newProperty("SystemTraySecondClick", SysTray.Action.NONE, propertyCount++);
    public static final UjoProperty<Parameters, Boolean> P_MODIFY_FINESHED_PROJ = Parameters.newProperty("ModifyFinishedProject", false, propertyCount++);
    public static final UjoProperty<Parameters, Boolean> P_EXIT_EVENT_CREATE = Parameters.newProperty("ExitEventCreating", true, propertyCount++);
    public static final UjoProperty<Parameters, String> P_EXIT_EVENT_DESCR = Parameters.newProperty("ExitEventDescription", "EXIT", propertyCount++);
    public static final UjoProperty<Parameters, Boolean> P_HIDE_ICONS = Parameters.newProperty("HideButtonIcons", false, propertyCount++);
    public static final UjoProperty<Parameters, Rectangle> P_WINDOW_SIZE = Parameters.newProperty("WindowSize", new Rectangle(-1, -1, 622, 405), propertyCount++);
    public static final UjoProperty<Parameters, Boolean> P_WINDOW_SIZE_RESTORATION = Parameters.newProperty("WindowSizeRestoration", true, propertyCount++);
    public static final UjoProperty<Parameters, Boolean> P_AUTOMATIC_SORTING_BY_TIME = Parameters.newProperty("AutomaticSortingByTime", true, propertyCount++);
    public static final UjoProperty<Parameters, String> P_SYSTEM_BROWSER_PATH = Parameters.newProperty("SystemBrowserPath", "<default>", propertyCount++);
    public static final UjoProperty<Parameters, File> P_DATA_FILE_PATH = Parameters.newProperty("DataFilePath", new File("<default>"), propertyCount++);
    public static final UjoProperty<Parameters, String> P_SORT_PROJ_COLUMN = Parameters.newProperty("SortProjColumn", Project.P_ID.getName(), propertyCount++);
    private DecimalFormat decimalFormat = null;

    public Parameters() {
        for (UjoProperty ujoProperty : this.readProperties()) {
            this.writeValue(ujoProperty, ujoProperty.getDefault());
        }
    }

    @Override
    public int readPropertyCount() {
        return propertyCount;
    }

    @Override
    public void writeValue(UjoProperty ujoProperty, Object object) {
        Object object2;
        if (P_SYSTEM_BROWSER_PATH == ujoProperty && !ApplTools.isValid((String)object)) {
            object = P_SYSTEM_BROWSER_PATH.getDefault();
        } else if (P_DATA_FILE_PATH == ujoProperty) {
            Object object3 = object2 = object != null ? ((File)object).getName().trim() : VALUE_DEFAULT;
            if (VALUE_DEFAULT.equals(object2) || ((String)object2).length() == 0) {
                object = P_DATA_FILE_PATH.getDefault();
            }
            if (object != P_DATA_FILE_PATH.getDefault() && !this.canWrite((File)object)) {
                throw new MessageException("Can't write data to " + object);
            }
        }
        super.writeValue(ujoProperty, object);
        if (P_LANG == ujoProperty) {
            this.setDecimalFormat();
        } else if (P_DATE_MAIN_FORMAT == ujoProperty || P_DATE_REPORT_FORMAT == ujoProperty) {
            new SimpleDateFormat((String)object);
        } else if (P_FIRST_DAY_OF_WEEK == ujoProperty && ((Integer)(object2 = (Integer)object) < 1 || 7 < (Integer)object2)) {
            object2 = ((Integer)object2 + 7000 - 1) % 7 + 1;
            super.writeValue(P_FIRST_DAY_OF_WEEK, object2);
        }
    }

    private boolean canWrite(File file) {
        try {
            boolean bl = file.isFile() ? file.canWrite() : file.createNewFile();
            return bl;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public boolean readAuthorization(UjoAction ujoAction, UjoProperty ujoProperty, Object object) {
        switch (ujoAction.getType()) {
            case 10: {
                return !ujoProperty.isDefault(this);
            }
            case 100: {
                if (ujoProperty == P_SORT_PROJ_COLUMN) {
                    return false;
                }
                boolean bl = ujoProperty == P_DATA_FILE_PATH ? object != P_DATA_FILE_PATH.getDefault() && object != null : ujoProperty != P_WINDOW_SIZE;
                return bl;
            }
        }
        return super.readAuthorization(ujoAction, ujoProperty, object);
    }

    public String getDateFormat(UjoProperty<Parameters, String> ujoProperty, ApplContext applContext) {
        String string = ujoProperty.of(this);
        String string2 = applContext.getLanguageManager().getTextAllways("Week");
        string = String.format(string, string2);
        return string;
    }

    private void setDecimalFormat() {
        Locale locale = P_LANG.of(this);
        this.decimalFormat = ApplTools.createDecimalFormat("0.00", locale);
    }

    @Override
    public void writeValueString(UjoProperty ujoProperty, String string, Class clazz, UjoAction ujoAction) {
        if (P_SYSTRAY_SECOND_CLICK == ujoProperty) {
            if (ApplTools.isValid(string)) {
                super.writeValueString(ujoProperty, string.toUpperCase(), clazz, ujoAction);
            } else {
                ((Property)ujoProperty).setValueFromDefault(this);
            }
        } else {
            super.writeValueString(ujoProperty, string, clazz, ujoAction);
        }
    }

    public String formatTime(int n) {
        boolean bl;
        boolean bl2 = P_DECIMAL_TIME_FORMAT.of(this);
        if (bl2) {
            DecimalFormat decimalFormat = this.decimalFormat;
            float f = (float)n / 60.0f;
            return decimalFormat.format(f);
        }
        boolean bl3 = bl = n < 0;
        if (bl) {
            n = -n;
        }
        int n2 = n / 60;
        int n3 = n % 60;
        StringBuilder stringBuilder = new StringBuilder(6);
        if (bl) {
            stringBuilder.append('-');
        }
        stringBuilder.append(n2);
        stringBuilder.append(':');
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        return stringBuilder.toString();
    }

    static {
        Parameters.init(Parameters.class, true);
    }
}

