/*
 * Decompiled with CFR 0.152.
 */
package net.ponec.jworksheet.bo;

import java.util.ArrayList;
import java.util.Date;
import net.ponec.jworksheet.bo.Event;
import net.ponec.jworksheet.bo.Project;
import net.ponec.jworksheet.bo.TaskType;
import net.ponec.jworksheet.bo.WorkDay;
import net.ponec.jworksheet.bo.item.YearMonthDay;
import org.ujoframework.UjoProperty;
import org.ujoframework.extensions.ListProperty;
import org.ujoframework.extensions.UjoAction;
import org.ujoframework.implementation.map.MapUjo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkSpace
extends MapUjo {
    public static final UjoProperty<WorkSpace, String> P_VERSN = WorkSpace.newProperty("Version", "");
    public static final UjoProperty<WorkSpace, Date> P_CREATED = WorkSpace.newProperty("Created", Date.class);
    public static final UjoProperty<WorkSpace, Date> P_ARCHIVED = WorkSpace.newProperty("Archived", Date.class);
    public static final ListProperty<WorkSpace, WorkDay> P_DAYS = WorkSpace.newPropertyList("Day", WorkDay.class);
    public static final ListProperty<WorkSpace, Project> P_PROJS = WorkSpace.newPropertyList("Project", Project.class);

    public WorkDay findWorkDay(YearMonthDay yearMonthDay) {
        for (WorkDay workDay : P_DAYS.getList(this)) {
            if (!WorkDay.P_DATE.equals(workDay, yearMonthDay)) continue;
            return workDay;
        }
        WorkDay workDay = new WorkDay();
        WorkDay.P_DATE.setValue(workDay, yearMonthDay.cloneDay());
        P_DAYS.addItem(this, workDay);
        return workDay;
    }

    public Project findProject(Integer n) {
        for (Project project : P_PROJS.getList(this)) {
            if (!Project.P_ID.equals(project, n)) continue;
            return project;
        }
        return null;
    }

    public Project findDefaultProject() {
        for (Project project : P_PROJS.getList(this)) {
            if (!Project.P_DEFAULT.of(project).booleanValue() || Project.P_FINISHED.of(project).booleanValue()) continue;
            return project;
        }
        return null;
    }

    public ArrayList<Project> getOpenProjects() {
        ArrayList<Project> arrayList = new ArrayList<Project>(P_PROJS.getItemCount(this));
        for (Project project : P_PROJS.getList(this)) {
            if (Project.P_FINISHED.of(project).booleanValue()) continue;
            arrayList.add(project);
        }
        return arrayList;
    }

    public void assingTasks() {
        for (WorkDay workDay : P_DAYS.getList(this)) {
            for (Event event : WorkDay.P_EVENTS.getList(workDay)) {
                Integer n = Event.P_PROJID.of(event);
                Integer n2 = Event.P_TASKID.of(event);
                Project project = this.findProject(n);
                TaskType taskType = project != null ? project.findTaskType(n2) : null;
                Event.P_PROJ.setValue(event, project);
                Event.P_PROJID.setValue(event, null);
                Event.P_TASK.setValue(event, taskType);
                Event.P_TASKID.setValue(event, null);
            }
        }
    }

    public void createDemoData() {
        TaskType taskType = new TaskType();
        TaskType.P_DESCR.setValue(taskType, "Task of the 1st Project");
        Project project = new Project();
        Project.P_DESCR.setValue(project, "1st Project");
        Project.P_TASKS.addItem(project, taskType);
        P_PROJS.addItem(this, project);
    }

    public void sortDays() {
        P_DAYS.sort(this, WorkDay.P_DATE);
    }

    @Override
    public boolean readAuthorization(UjoAction ujoAction, UjoProperty ujoProperty, Object object) {
        switch (ujoAction.getType()) {
            case 2: {
                if (P_ARCHIVED == ujoProperty) {
                    return object != null;
                }
                if (P_DAYS != ujoProperty || !(object instanceof WorkDay)) break;
                WorkDay workDay = (WorkDay)object;
                return WorkDay.P_EVENTS.getItemCount(workDay) > 0;
            }
        }
        return super.readAuthorization(ujoAction, ujoProperty, object);
    }
}

