/*
 * Decompiled with CFR 0.152.
 */
package net.ponec.jworksheet.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.ponec.jworksheet.bo.Parameters;
import net.ponec.jworksheet.core.ApplContext;
import net.ponec.jworksheet.core.ApplTools;
import net.ponec.jworksheet.core.LanguageManager;
import net.ponec.jworksheet.gui.TopDialog;
import net.ponec.jworksheet.resources.ResourceProvider;

public class BrowserDialog
extends TopDialog {
    private static final Logger LOGGER = Logger.getLogger(BrowserDialog.class.getName());
    private String result = null;
    private JButton bBrowser;
    private JButton bCancel;
    private JButton bOK;
    private ButtonGroup currentDayGroup;
    private JPanel jPanel2;
    private JLabel lBrowser;
    private JPanel pButtons;
    private ButtonGroup reportTypeGroup;
    private JTextField tBrowser;

    public BrowserDialog(ApplContext applContext, String string) {
        super(applContext);
        Object object;
        this.setLocale(applContext.getLanguage());
        this.initComponents();
        this.tBrowser.setText(string);
        this.setTitle("Select an Internet Browser");
        this.setSize(450, 130);
        this.getRootPane().setDefaultButton(this.bOK);
        if (!Parameters.P_HIDE_ICONS.of(this.applContext.getParameters()).booleanValue()) {
            object = new ResourceProvider();
            this.bOK.setIcon(((ResourceProvider)object).getIcon("_tick.png"));
            this.bCancel.setIcon(((ResourceProvider)object).getIcon("_cross.png"));
        }
        object = this.applContext.getLanguageManager();
        ((LanguageManager)object).setFirstRunTexts(this);
    }

    public String getResult() {
        this.setVisible(true);
        return this.result;
    }

    public final void escapeAction(ActionEvent actionEvent) {
        this.bCancelActionPerformed(actionEvent);
    }

    public File selectFile(String string, File file) {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(string);
        jFileChooser.setDialogType(0);
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        if ((n = jFileChooser.showOpenDialog(this)) == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    private void initComponents() {
        this.currentDayGroup = new ButtonGroup();
        this.reportTypeGroup = new ButtonGroup();
        this.jPanel2 = new JPanel();
        this.lBrowser = new JLabel();
        this.pButtons = new JPanel();
        this.bOK = new JButton();
        this.bCancel = new JButton();
        this.tBrowser = new JTextField();
        this.bBrowser = new JButton();
        FormListener formListener = new FormListener();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.jPanel2.setLayout(new GridBagLayout());
        this.lBrowser.setText("Browser file:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.jPanel2.add((Component)this.lBrowser, gridBagConstraints);
        this.pButtons.setLayout(new FlowLayout(1, 5, 0));
        this.bOK.setMnemonic('O');
        this.bOK.setText("OK");
        this.bOK.addActionListener(formListener);
        this.pButtons.add(this.bOK);
        this.bCancel.setMnemonic('C');
        this.bCancel.setText("Cancel");
        this.bCancel.addActionListener(formListener);
        this.pButtons.add(this.bCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.pButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel2.add((Component)this.tBrowser, gridBagConstraints);
        this.bBrowser.setText("...");
        this.bBrowser.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.bBrowser, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 15, 15, 15);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
    }

    private void bBrowserActionPerformed(ActionEvent actionEvent) {
        String string = this.bBrowser.getText().trim();
        File file = ApplTools.isValid(string) ? new File(string) : null;
        file = this.selectFile(this.getTitle(), file);
        if (file != null) {
            this.tBrowser.setText(file.getAbsolutePath());
        }
    }

    private void bOKActionPerformed(ActionEvent actionEvent) {
        this.result = this.tBrowser.getText();
        this.bCancelActionPerformed(actionEvent);
    }

    private void bCancelActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private class FormListener
    implements ActionListener {
        private FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == BrowserDialog.this.bOK) {
                BrowserDialog.this.bOKActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == BrowserDialog.this.bCancel) {
                BrowserDialog.this.bCancelActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == BrowserDialog.this.bBrowser) {
                BrowserDialog.this.bBrowserActionPerformed(actionEvent);
            }
        }
    }
}

