/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import weka.core.DenseInstance;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Range;
import weka.gui.Logger;

public class SubstringReplacerRules
implements EnvironmentHandler,
Serializable {
    private static final long serialVersionUID = -7151320452496749698L;
    protected transient Environment m_env = Environment.getSystemWide();
    protected List<SubstringReplacerMatchRule> m_matchRules;
    protected Instances m_inputStructure;
    protected Instances m_outputStructure;
    protected String m_statusMessagePrefix = "";

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    public SubstringReplacerRules(String matchDetails, Instances inputStructure, String statusMessagePrefix, Logger log, Environment env) {
        this.m_matchRules = SubstringReplacerRules.matchRulesFromInternal(matchDetails, inputStructure, statusMessagePrefix, log, env);
        this.m_inputStructure = new Instances(inputStructure);
        this.m_outputStructure = new Instances(inputStructure).stringFreeStructure();
        this.m_env = env;
        this.m_statusMessagePrefix = statusMessagePrefix;
    }

    public SubstringReplacerRules(String matchDetails, Instances inputStructure) {
        this(matchDetails, inputStructure, "", null, Environment.getSystemWide());
    }

    public static List<SubstringReplacerMatchRule> matchRulesFromInternal(String matchReplaceDetails, Instances inputStructure, String statusMessagePrefix, Logger log, Environment env) {
        String[] mrParts;
        ArrayList<SubstringReplacerMatchRule> matchRules = new ArrayList<SubstringReplacerMatchRule>();
        for (String p : mrParts = matchReplaceDetails.split("@@match-replace@@")) {
            SubstringReplacerMatchRule mr = new SubstringReplacerMatchRule(p.trim());
            mr.m_statusMessagePrefix = statusMessagePrefix;
            mr.m_logger = log;
            mr.init(env, inputStructure);
            matchRules.add(mr);
        }
        return matchRules;
    }

    public void applyRules(Instance inst) {
        for (SubstringReplacerMatchRule mr : this.m_matchRules) {
            mr.apply(inst);
        }
    }

    public Instance makeOutputInstance(Instance inputI) {
        double[] vals = new double[this.m_outputStructure.numAttributes()];
        String[] stringVals = new String[this.m_outputStructure.numAttributes()];
        for (int i = 0; i < inputI.numAttributes(); ++i) {
            if (inputI.attribute(i).isString() && !inputI.isMissing(i)) {
                stringVals[i] = inputI.stringValue(i);
                continue;
            }
            vals[i] = inputI.value(i);
        }
        for (SubstringReplacerMatchRule mr : this.m_matchRules) {
            mr.apply(stringVals);
        }
        for (int i = 0; i < this.m_outputStructure.numAttributes(); ++i) {
            if (!this.m_outputStructure.attribute(i).isString() || stringVals[i] == null) continue;
            this.m_outputStructure.attribute(i).setStringValue(stringVals[i]);
        }
        DenseInstance result = new DenseInstance(inputI.weight(), vals);
        result.setDataset(this.m_outputStructure);
        return result;
    }

    public static class SubstringReplacerMatchRule
    implements Serializable {
        private static final long serialVersionUID = 5792838913737819728L;
        protected String m_match = "";
        protected String m_replace = "";
        protected boolean m_regex;
        protected Pattern m_regexPattern;
        protected boolean m_ignoreCase;
        protected String m_attsToApplyTo = "";
        protected String m_matchS;
        protected String m_replaceS;
        protected int[] m_selectedAtts;
        protected String m_statusMessagePrefix;
        protected Logger m_logger;

        public SubstringReplacerMatchRule() {
        }

        public SubstringReplacerMatchRule(String setup) {
            this.parseFromInternal(setup);
        }

        public SubstringReplacerMatchRule(String match, String replace, boolean regex, boolean ignoreCase, String selectedAtts) {
            this.m_match = match;
            this.m_replace = replace;
            this.m_regex = regex;
            this.m_ignoreCase = ignoreCase;
            this.m_attsToApplyTo = selectedAtts;
        }

        protected void parseFromInternal(String setup) {
            String[] parts = setup.split("@@MR@@");
            if (parts.length < 4 || parts.length > 5) {
                throw new IllegalArgumentException("Malformed match-replace definition: " + setup);
            }
            this.m_attsToApplyTo = parts[0].trim();
            this.m_regex = parts[1].trim().toLowerCase().equals("t");
            this.m_ignoreCase = parts[2].trim().toLowerCase().equals("t");
            this.m_match = parts[3].trim();
            if (this.m_match == null || this.m_match.length() == 0) {
                throw new IllegalArgumentException("Must provide something to match!");
            }
            if (parts.length == 5) {
                this.m_replace = parts[4];
            }
        }

        public void setMatch(String match) {
            this.m_match = match;
        }

        public String getMatch() {
            return this.m_match;
        }

        public void setReplace(String replace) {
            this.m_replace = replace;
        }

        public String getReplace() {
            return this.m_replace;
        }

        public void setRegex(boolean regex) {
            this.m_regex = regex;
        }

        public boolean getRegex() {
            return this.m_regex;
        }

        public void setIgnoreCase(boolean ignore) {
            this.m_ignoreCase = ignore;
        }

        public boolean getIgnoreCase() {
            return this.m_ignoreCase;
        }

        public void setAttsToApplyTo(String a) {
            this.m_attsToApplyTo = a;
        }

        public String getAttsToApplyTo() {
            return this.m_attsToApplyTo;
        }

        public void init(Environment env, Instances structure) {
            HashSet<Integer> indexes;
            this.m_matchS = this.m_match;
            this.m_replaceS = this.m_replace;
            String attsToApplyToS = this.m_attsToApplyTo;
            try {
                this.m_matchS = env.substitute(this.m_matchS);
                this.m_replaceS = env.substitute(this.m_replace);
                attsToApplyToS = env.substitute(attsToApplyToS);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (this.m_regex) {
                String match = this.m_matchS;
                if (this.m_ignoreCase) {
                    match = match.toLowerCase();
                }
                this.m_regexPattern = Pattern.compile(match);
            }
            String tempRangeS = attsToApplyToS;
            tempRangeS = tempRangeS.replace("/first", "first").replace("/last", "last");
            Range tempR = new Range();
            tempR.setRanges(attsToApplyToS);
            try {
                tempR.setUpper(structure.numAttributes() - 1);
                this.m_selectedAtts = tempR.getSelection();
            }
            catch (IllegalArgumentException ex) {
                this.m_selectedAtts = null;
            }
            if (this.m_selectedAtts == null) {
                String[] attParts;
                indexes = new HashSet<Integer>();
                for (String att : attParts = this.m_attsToApplyTo.split(",")) {
                    if ((att = att.trim()).toLowerCase().equals("/first")) {
                        indexes.add(0);
                        continue;
                    }
                    if (att.toLowerCase().equals("/last")) {
                        indexes.add(structure.numAttributes() - 1);
                        continue;
                    }
                    if (structure.attribute(att) != null) {
                        indexes.add(new Integer(structure.attribute(att).index()));
                        continue;
                    }
                    if (this.m_logger == null) continue;
                    String msg = this.m_statusMessagePrefix + "Can't find attribute '" + att + "in the incoming instances - ignoring";
                    this.m_logger.logMessage(msg);
                }
                this.m_selectedAtts = new int[indexes.size()];
                int c = 0;
                for (Integer i : indexes) {
                    this.m_selectedAtts[c++] = i;
                }
            }
            indexes = new HashSet();
            for (int m_selectedAtt : this.m_selectedAtts) {
                if (structure.attribute(m_selectedAtt).isString()) {
                    indexes.add(m_selectedAtt);
                    continue;
                }
                if (this.m_logger == null) continue;
                String msg = this.m_statusMessagePrefix + "Attribute '" + structure.attribute(m_selectedAtt).name() + "is not a string attribute - " + "ignoring";
                this.m_logger.logMessage(msg);
            }
            this.m_selectedAtts = new int[indexes.size()];
            int c = 0;
            for (Integer i : indexes) {
                this.m_selectedAtts[c++] = i;
            }
        }

        public void apply(Instance inst) {
            for (int i = 0; i < this.m_selectedAtts.length; ++i) {
                int numStringVals = inst.attribute(this.m_selectedAtts[i]).numValues();
                if (inst.isMissing(this.m_selectedAtts[i])) continue;
                String value = inst.stringValue(this.m_selectedAtts[i]);
                value = this.apply(value);
                inst.dataset().attribute(this.m_selectedAtts[i]).setStringValue(value);
                if (numStringVals <= 1) continue;
                inst.setValue(this.m_selectedAtts[i], 0.0);
            }
        }

        public void apply(String[] stringVals) {
            for (int i = 0; i < this.m_selectedAtts.length; ++i) {
                if (stringVals[this.m_selectedAtts[i]] == null) continue;
                stringVals[this.m_selectedAtts[i]] = this.apply(stringVals[this.m_selectedAtts[i]]);
            }
        }

        protected String apply(String source) {
            String result = source;
            String match = this.m_matchS;
            if (this.m_ignoreCase) {
                result = result.toLowerCase();
                match = match.toLowerCase();
            }
            if (result != null && result.length() > 0) {
                result = this.m_regex ? this.m_regexPattern.matcher(result).replaceAll(this.m_replaceS) : result.replace(match, this.m_replaceS);
            }
            return result;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append(this.m_regex ? "Regex: " : "Substring: ");
            buff.append(this.m_match).append(" --> ").append(this.m_replace).append("  ");
            buff.append(this.m_ignoreCase ? "[ignore case]" : "").append("  ");
            buff.append("[Atts: " + this.m_attsToApplyTo + "]");
            return buff.toString();
        }

        public String toStringInternal() {
            StringBuffer buff = new StringBuffer();
            buff.append(this.m_attsToApplyTo).append("@@MR@@");
            buff.append(this.m_regex ? "t" : "f").append("@@MR@@");
            buff.append(this.m_ignoreCase ? "t" : "f").append("@@MR@@");
            buff.append(this.m_match).append("@@MR@@");
            buff.append(this.m_replace);
            return buff.toString();
        }
    }
}

